/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.CloseableIterator;
import com.querydsl.core.types.FactoryExpression;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class TransformingIterator<T>
implements CloseableIterator<T> {
    private final Iterator<T> iterator;
    private final Closeable closeable;
    private final FactoryExpression<?> projection;

    public TransformingIterator(Iterator<T> iterator, FactoryExpression<?> projection) {
        Closeable c;
        this.iterator = iterator;
        this.projection = projection;
        this.closeable = iterator instanceof Closeable ? (c = (Closeable)((Object)iterator)) : null;
    }

    public TransformingIterator(Iterator<T> iterator, Closeable closeable, FactoryExpression<?> projection) {
        this.iterator = iterator;
        this.projection = projection;
        this.closeable = closeable;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public T next() {
        Object result = this.iterator.next();
        if (result != null) {
            if (!result.getClass().isArray()) {
                result = new Object[]{result};
            }
            return (T)this.projection.newInstance((Object[])result);
        }
        return null;
    }

    public void remove() {
        this.iterator.remove();
    }

    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

