/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class XMLDataObjectInfoParser
extends DefaultHandler
implements FileChangeListener,
LexicalHandler,
LookupListener {
    private static final StopSaxException STOP = new StopSaxException();
    private static XMLReader sharedParserImpl = null;
    private static final String NULL = "";
    private Reference<XMLDataObject> xml;
    private String parsedId;
    private Lookup lookup;
    private Lookup.Result<Node.Cookie> result;
    private ThreadLocal<Class<?>> QUERY = new ThreadLocal();

    XMLDataObjectInfoParser(XMLDataObject xml) {
        this.xml = new WeakReference<XMLDataObject>(xml);
    }

    public String getPublicId() {
        String nu;
        String id = this.waitFinished();
        return id == (nu = NULL) ? null : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupCookie(Class<?> clazz) {
        if (this.QUERY.get() == clazz) {
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Cyclic deps on queried class: " + clazz + " for " + this.getXml());
            }
            return null;
        }
        Class<?> previous = this.QUERY.get();
        try {
            Lookup.Result<Node.Cookie> r;
            Lookup l;
            block19: {
                this.QUERY.set(clazz);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Will do query for class: " + clazz + " for " + this.getXml());
                }
                do {
                    String id = this.waitFinished();
                    XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
                    synchronized (xMLDataObjectInfoParser) {
                        l = this.lookup != null ? this.lookup : null;
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Lookup is " + l + " for id: " + id);
                    }
                    if (l == null) {
                        l = this.updateLookup(this.getXml(), null, id);
                        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                            XMLDataObject.ERR.fine("Updating lookup: " + l);
                        }
                    }
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Wait lookup is over: " + l + this.getXml());
                    }
                    if (l != null) break block19;
                } while (this.parsedId != null);
                l = Lookup.EMPTY;
            }
            if ((r = this.result) != null) {
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Querying the result: " + r);
                }
            } else if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("No result for lookup: " + this.lookup);
            }
            Object ret = l.lookup(clazz);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Returning value: " + ret + " for " + this.getXml());
            }
            Object object = ret;
            return object;
        }
        finally {
            this.QUERY.set(previous);
        }
    }

    public String waitFinished() {
        return this.waitFinished(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String waitFinished(String ignorePreviousId) {
        InputStream in;
        String previousID;
        String newID;
        XMLDataObject realXML;
        block71: {
            URL url;
            FileObject myFileObject;
            XMLReader parser;
            block70: {
                String string;
                if (sharedParserImpl == null) {
                    XMLDataObject.ERR.fine("No sharedParserImpl, exiting");
                    return NULL;
                }
                parser = sharedParserImpl;
                realXML = this.getXml();
                if (realXML == null) {
                    return NULL;
                }
                myFileObject = realXML.getPrimaryFile();
                newID = null;
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Going to read parsedId for " + realXML);
                }
                XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
                // MONITORENTER : xMLDataObjectInfoParser
                previousID = this.parsedId;
                // MONITOREXIT : xMLDataObjectInfoParser
                if (previousID != null) {
                    if (!XMLDataObject.ERR.isLoggable(Level.FINE)) return previousID;
                    XMLDataObject.ERR.fine("Has already been parsed: " + this.parsedId + " for " + realXML);
                    return previousID;
                }
                url = null;
                in = null;
                url = myFileObject.toURL();
                XMLDataObjectInfoParser xMLDataObjectInfoParser2 = this;
                // MONITORENTER : xMLDataObjectInfoParser2
                try {
                    if (myFileObject.isValid()) break block70;
                    if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                        XMLDataObject.ERR.fine("Invalid file object: " + myFileObject);
                    }
                    string = NULL;
                }
                catch (Throwable throwable) {
                    try {
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        XMLDataObject.ERR.log(Level.WARNING, null, ex);
                    }
                    throw throwable;
                }
                try {
                    if (in == null) return string;
                    in.close();
                    return string;
                }
                catch (IOException ex2) {
                    XMLDataObject.ERR.log(Level.WARNING, null, ex2);
                }
                return string;
            }
            this.parsedId = NULL;
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("parsedId set to NULL for " + realXML);
            }
            try {
                in = myFileObject.getInputStream();
            }
            catch (IOException ex) {
                this.warning(ex, "I/O exception while opening " + myFileObject);
                String ex2 = NULL;
                try {
                    if (in == null) return ex2;
                    in.close();
                    return ex2;
                }
                catch (IOException ex3) {
                    XMLDataObject.ERR.log(Level.WARNING, null, ex3);
                }
                return ex2;
            }
            try {
                XMLReader ex = sharedParserImpl;
                // MONITORENTER : ex
                this.configureParser(parser, false, this);
                parser.setContentHandler(this);
                parser.setErrorHandler(this);
                InputSource input = new InputSource(url.toExternalForm());
                input.setByteStream(in);
                parser.parse(input);
                // MONITOREXIT : ex
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Parse finished for " + realXML);
                }
            }
            catch (StopSaxException stopped) {
                newID = this.parsedId;
                XMLDataObject.ERR.fine("Parsing successfully stopped: " + this.parsedId + " for " + realXML);
            }
            catch (SAXException checkStop) {
                if (STOP.getMessage().equals(checkStop.getMessage())) {
                    newID = this.parsedId;
                    XMLDataObject.ERR.fine("Parsing stopped with STOP message: " + this.parsedId + " for " + realXML);
                    break block71;
                }
                String msg = "Thread:" + Thread.currentThread().getName();
                XMLDataObject.ERR.warning("DocListener should not throw SAXException but STOP one.\n" + msg);
                XMLDataObject.ERR.log(Level.WARNING, null, checkStop);
                Exception ex = checkStop.getException();
                if (ex != null) {
                    XMLDataObject.ERR.log(Level.WARNING, null, ex);
                }
            }
            catch (FileNotFoundException ex) {
                XMLDataObject.ERR.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                XMLDataObject.ERR.log(Level.INFO, null, ex);
            }
            finally {
                if (Boolean.getBoolean("netbeans.profile.memory")) {
                    parser.setContentHandler(XMLDataObject.NullHandler.INSTANCE);
                    parser.setErrorHandler(XMLDataObject.NullHandler.INSTANCE);
                    try {
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", XMLDataObject.NullHandler.INSTANCE);
                    }
                    catch (SAXException stopped) {}
                    try {
                        parser.parse((InputSource)null);
                    }
                    catch (Exception stopped) {}
                }
                parser = null;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            XMLDataObject.ERR.log(Level.WARNING, null, ex);
        }
        // MONITOREXIT : xMLDataObjectInfoParser2
        if (ignorePreviousId != null && ignorePreviousId.equals(newID)) {
            if (!XMLDataObject.ERR.isLoggable(Level.FINE)) return newID;
            XMLDataObject.ERR.fine("No update to ID: " + ignorePreviousId + " for " + realXML);
            return newID;
        }
        if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
            XMLDataObject.ERR.fine("New id: " + newID + " for " + realXML);
        }
        if (newID == null) return newID;
        this.updateLookup(realXML, previousID, newID);
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup updateLookup(XMLDataObject realXML, String previousID, String id) {
        Lookup newLookup;
        if (realXML == null) {
            return this.lookup;
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser = this;
        synchronized (xMLDataObjectInfoParser) {
            if (previousID != null && previousID.equals(id) && this.lookup != null) {
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("No need to update lookup: " + id + " for " + realXML);
                }
                return this.lookup;
            }
        }
        XMLDataObject.Info info = XMLDataObject.getRegisteredInfo(id);
        if (info != null) {
            newLookup = XMLDataObject.createInfoLookup(realXML, info);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from info: " + newLookup + " for " + realXML);
            }
        } else {
            newLookup = Environment.findForOne(realXML);
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Lookup from env: " + newLookup + " for " + realXML);
            }
            if (newLookup == null) {
                newLookup = Lookup.EMPTY;
            }
        }
        XMLDataObjectInfoParser xMLDataObjectInfoParser2 = this;
        synchronized (xMLDataObjectInfoParser2) {
            Lookup.Result<Node.Cookie> prevRes = this.result;
            this.lookup = newLookup;
            if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                XMLDataObject.ERR.fine("Shared lookup updated: " + this.lookup + " for " + realXML);
            }
            this.result = this.lookup.lookupResult(Node.Cookie.class);
            this.result.addLookupListener((LookupListener)this);
            if (prevRes != null) {
                prevRes.removeLookupListener((LookupListener)this);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing property change for " + realXML);
                }
                realXML.firePropertyChange("cookie", null, null);
                if (XMLDataObject.ERR.isLoggable(Level.FINE)) {
                    XMLDataObject.ERR.fine("Firing done for " + realXML);
                }
            }
            return newLookup;
        }
    }

    private void configureParser(XMLReader parser, boolean validation, LexicalHandler lex) {
        try {
            parser.setFeature("http://xml.org/sax/features/validation", validation);
        }
        catch (SAXException sex) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support validation feature.");
        }
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", lex);
        }
        catch (SAXException sex) {
            XMLDataObject.ERR.fine("Warning: XML parser does not support lexical-handler feature.");
        }
    }

    public void warning(Throwable ex) {
        this.warning(ex, null);
    }

    public void warning(Throwable ex, String annotation) {
        XMLDataObject.ERR.log(Level.INFO, annotation, ex);
    }

    @Override
    public void startDTD(String root, String pID, String sID) throws SAXException {
        this.parsedId = pID == null ? NULL : pID;
        XMLDataObject.ERR.fine("Parsed to " + this.parsedId);
        this.stop();
    }

    @Override
    public void endDTD() throws SAXException {
        this.stop();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startEntity {0}", name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endEntity {0}", name);
    }

    @Override
    public void startCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startCDATA");
    }

    @Override
    public void endCDATA() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endCDATA");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "comment len: {0}", length);
    }

    @Override
    public void error(SAXParseException p1) throws SAXException {
        this.stop();
    }

    @Override
    public void fatalError(SAXParseException p1) throws SAXException {
        this.stop();
    }

    @Override
    public void endDocument() throws SAXException {
        this.stop();
    }

    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        this.stop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "characters len: {0}", length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endElement: {0}", qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "endPrefix: {0}", prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "ignorableWhitespace: {0}", length);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "notationDecl: {0}", name);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "processingInstruction: {0}", target);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "resolveEntity: {0}", publicId);
        return super.resolveEntity(publicId, systemId);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "skippedEntity: {0}", name);
    }

    @Override
    public void startDocument() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startDocument");
    }

    @Override
    public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startElement: {0}", qName);
        this.stop();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "startPrefixMapping: {0}", prefix);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "unparsedEntityDecl: {0}", name);
    }

    private void stop() throws SAXException {
        XMLDataObject.ERR.log(Level.FINEST, "stop");
        throw STOP;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    private void fileCreated(FileObject fo) {
    }

    public void fileChanged(FileEvent fe) {
        XMLDataObject realXML = this.getXml();
        if (realXML == null) {
            return;
        }
        if (realXML.getPrimaryFile().equals(fe.getFile())) {
            realXML.clearDocument();
            String prevId = this.parsedId;
            this.parsedId = null;
            XMLDataObject.ERR.fine("cleared parsedId");
            this.waitFinished(prevId);
        }
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void resultChanged(LookupEvent lookupEvent) {
        XMLDataObject realXML = this.getXml();
        if (realXML == null) {
            return;
        }
        realXML.firePropertyChange("cookie", null, null);
        Node n = realXML.getNodeDelegateOrNull();
        if (n instanceof XMLDataObject.XMLNode) {
            ((XMLDataObject.XMLNode)n).update();
        }
    }

    private XMLDataObject getXml() {
        return this.xml.get();
    }

    static {
        try {
            sharedParserImpl = XMLUtil.createXMLReader();
            sharedParserImpl.setEntityResolver(new EmptyEntityResolver());
        }
        catch (SAXException ex) {
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)"System does not contain JAXP 1.1 compliant parser!");
            Logger.getLogger(XMLDataObject.class.getName()).log(Level.WARNING, null, ex);
        }
        try {
            Properties props = System.getProperties();
            String SAX2_KEY = "org.xml.sax.driver";
            if (props.getProperty("org.xml.sax.driver") == null) {
                props.put("org.xml.sax.driver", sharedParserImpl.getClass().getName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }

    private static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemID) {
            InputSource ret = new InputSource(new StringReader(XMLDataObjectInfoParser.NULL));
            ret.setSystemId("StringReader");
            return ret;
        }
    }
}

