/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.studio;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.transform.TransformerException;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.ScenerixxLib;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.DBInternal;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.StudioWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.SocialWebsites;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ImageResizer;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.StandardContextMenu;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.MovieTypeComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.SocialWebsitesComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.StudioWebsitesComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.sync.WebServiceHelper;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.WebsiteIconsPanel;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioDiffPanel;

public class StudioDetailsPanel
extends JPanel
implements LookupListener {
    private static final Logger LOG = Logger.getLogger(StudioDetailsPanel.class.getName());
    private Lookup.Result<Studio> result;
    private Studio currentStudio = new Studio();
    private DB db;
    private int HEIGHT = 450;
    private int WIDTH = 360;
    private JButton btnAddWebsite;
    private JButton btnCopyUrlToClipboard;
    private JButton btnExport;
    private ButtonGroup btnGrpGender;
    private JButton btnImport;
    private JButton btnNew;
    private JButton btnOpenUrl;
    private JButton btnRemoveWebsite;
    private JButton btnReset;
    private JButton btnSave;
    private JButton btnSaveWebsite;
    private JButton btnSearchStudio;
    private JButton btnUpload;
    private JComboBox<SocialWebsites> comboAvailableWebsites;
    private JComboBox<String> comboParent;
    private JComboBox<Studio> comboStudios;
    private JComboBox<MovieType> comboType1;
    private JComboBox<MovieType> comboType2;
    private JComboBox<MovieType> comboType3;
    private JComboBox<MovieType> comboType4;
    private JComboBox<MovieType> comboType5;
    private JComboBox<MovieType> comboType6;
    private JComboBox<StudioWebsites> comboWebsites;
    private JComboBox<String> comboYear;
    private JComboBox<String> comboYearDefunct;
    private JFileChooser jFileChooser1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lbDescription;
    private JLabel lbName;
    private JLabel lbParent;
    private JLabel lbPicture;
    private JLabel lbTypes;
    private JLabel lbUrl;
    private JLabel lbWebsites;
    private JLabel lbYearFounded;
    private JPanel panelStudioDetails;
    private JTextArea taDescription;
    private JTextField tfName;
    private JTextField tfWebsite;
    private WebsiteIconsPanel websiteIconsPanel;

    public StudioDetailsPanel() {
        this.initComponents();
        StandardContextMenu.addTo(this.tfName);
        this.resetForm();
        ArrayList<Object> years = new ArrayList<Object>();
        years.add("??");
        for (int i = LocalDate.now().getYear(); i >= 1900; --i) {
            years.add("" + i);
        }
        this.comboYear.setModel(new DefaultComboBoxModel<String>((String[])years.toArray(String[]::new)));
        this.comboYearDefunct.setModel(new DefaultComboBoxModel<String>((String[])years.toArray(String[]::new)));
        KeyStroke keySave = KeyStroke.getKeyStroke(83, 2);
        AbstractAction performSave = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StudioDetailsPanel.this.saveStudio();
            }
        };
        this.btnSave.setAction(performSave);
        this.btnSave.getActionMap().put("performSaveDetails", performSave);
        this.btnSave.getInputMap(2).put(keySave, "performSaveDetails");
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/icons/OK.png")));
    }

    public void initStudioCombo() {
        List studios = this.db.getStudios();
        Studio placeholderStudio = new Studio();
        placeholderStudio.setName("Load an existing studio");
        studios.add(0, placeholderStudio);
        Studio[] toArray = (Studio[])studios.toArray(Studio[]::new);
        this.comboStudios.setModel(new DefaultComboBoxModel<Studio>(toArray));
        MovieType[] movieTypeValues = MovieType.values();
        this.comboType1.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType2.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType3.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType4.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType5.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType6.setModel(new DefaultComboBoxModel<MovieType>(movieTypeValues));
        this.comboType1.setRenderer(new MovieTypeComboRenderer());
        this.comboType2.setRenderer(new MovieTypeComboRenderer());
        this.comboType3.setRenderer(new MovieTypeComboRenderer());
        this.comboType4.setRenderer(new MovieTypeComboRenderer());
        this.comboType5.setRenderer(new MovieTypeComboRenderer());
        this.comboType6.setRenderer(new MovieTypeComboRenderer());
        ArrayList<SocialWebsites> socialWebsites = new ArrayList<SocialWebsites>();
        socialWebsites.add(null);
        socialWebsites.addAll(Arrays.asList(SocialWebsites.values()));
        this.comboAvailableWebsites.setModel(new DefaultComboBoxModel<SocialWebsites>((SocialWebsites[])socialWebsites.toArray(SocialWebsites[]::new)));
        this.comboAvailableWebsites.setSelectedItem(null);
        this.comboAvailableWebsites.setVisible(false);
        this.comboAvailableWebsites.setRenderer(new SocialWebsitesComboRenderer());
        this.comboWebsites.setRenderer(new StudioWebsitesComboRenderer());
        this.btnSaveWebsite.setVisible(false);
        this.tfWebsite.setVisible(false);
        this.lbUrl.setVisible(false);
    }

    public DB getDb() {
        return this.db;
    }

    public void setDb(DB db) {
        this.db = db;
    }

    private void initComponents() {
        this.btnGrpGender = new ButtonGroup();
        this.jFileChooser1 = new JFileChooser();
        this.panelStudioDetails = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.tfName = new JTextField();
        this.lbName = new JLabel();
        this.lbYearFounded = new JLabel();
        this.comboYear = new JComboBox();
        this.btnNew = new JButton();
        this.btnSave = new JButton();
        this.btnReset = new JButton();
        this.btnExport = new JButton();
        this.btnImport = new JButton();
        this.btnSearchStudio = new JButton();
        this.btnUpload = new JButton();
        this.lbPicture = new JLabel();
        this.lbDescription = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.lbParent = new JLabel();
        this.comboParent = new JComboBox();
        this.comboType1 = new JComboBox();
        this.comboType2 = new JComboBox();
        this.comboType3 = new JComboBox();
        this.comboType4 = new JComboBox();
        this.comboType5 = new JComboBox();
        this.comboType6 = new JComboBox();
        this.lbTypes = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboYearDefunct = new JComboBox();
        this.jLabel3 = new JLabel();
        this.comboStudios = new JComboBox();
        this.btnAddWebsite = new JButton();
        this.comboAvailableWebsites = new JComboBox();
        this.tfWebsite = new JTextField();
        this.btnSaveWebsite = new JButton();
        this.lbWebsites = new JLabel();
        this.lbUrl = new JLabel();
        this.btnOpenUrl = new JButton();
        this.btnCopyUrlToClipboard = new JButton();
        this.comboWebsites = new JComboBox();
        this.btnRemoveWebsite = new JButton();
        this.websiteIconsPanel = new WebsiteIconsPanel();
        this.tfName.setText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.tfName.text"));
        this.tfName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                StudioDetailsPanel.this.tfNameFocusGained(evt);
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.tfNameActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbName, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbYearFounded, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbYearFounded.text"));
        this.comboYear.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNew, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnNew.text"));
        this.btnNew.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnNew.toolTipText"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnNewActionPerformed(evt);
            }
        });
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/icons/OK.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnSave.text"));
        this.btnSave.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnSave.toolTipText"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnSaveActionPerformed(evt);
            }
        });
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        this.btnReset.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnReset.toolTipText"));
        this.btnReset.setLabel(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnReset.label"));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnResetActionPerformed(evt);
            }
        });
        this.btnExport.setIcon(new ImageIcon(this.getClass().getResource("/icons/Upload.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnExport, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnExport.text"));
        this.btnExport.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnExport.toolTipText"));
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnExportActionPerformed(evt);
            }
        });
        this.btnImport.setIcon(new ImageIcon(this.getClass().getResource("/icons/Download.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImport, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnImport.text"));
        this.btnImport.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnImport.toolTipText"));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnImportActionPerformed(evt);
            }
        });
        this.btnSearchStudio.setIcon(new ImageIcon(this.getClass().getResource("/icons/Search.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSearchStudio, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnSearchStudio.text"));
        this.btnSearchStudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnSearchStudioActionPerformed(evt);
            }
        });
        this.btnUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Update.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUpload, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnUpload.text"));
        this.btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnUploadActionPerformed(evt);
            }
        });
        this.lbPicture.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.lbPicture, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbPicture.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbDescription, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbDescription.text"));
        this.taDescription.setColumns(20);
        this.taDescription.setRows(5);
        this.jScrollPane3.setViewportView(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.lbParent, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbParent.text"));
        this.comboParent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                StudioDetailsPanel.this.comboParentFocusGained(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbTypes, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbTypes.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.jLabel2.text"));
        this.comboYearDefunct.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.jLabel3.text"));
        this.comboStudios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.comboStudiosActionPerformed(evt);
            }
        });
        this.btnAddWebsite.setIcon(new ImageIcon(this.getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddWebsite, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnAddWebsite.text"));
        this.btnAddWebsite.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnAddWebsite.toolTipText"));
        this.btnAddWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnAddWebsiteActionPerformed(evt);
            }
        });
        this.tfWebsite.setText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.tfWebsite.text"));
        this.tfWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.tfWebsiteActionPerformed(evt);
            }
        });
        this.btnSaveWebsite.setIcon(new ImageIcon(this.getClass().getResource("/icons/OK.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSaveWebsite, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnSaveWebsite.text"));
        this.btnSaveWebsite.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnSaveWebsite.toolTipText"));
        this.btnSaveWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnSaveWebsiteActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbWebsites, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbWebsites.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbUrl, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.lbUrl.text"));
        this.btnOpenUrl.setIcon(new ImageIcon(this.getClass().getResource("/icons/Globe.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenUrl, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnOpenUrl.text"));
        this.btnOpenUrl.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnOpenUrl.toolTipText"));
        this.btnOpenUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnOpenUrlActionPerformed(evt);
            }
        });
        this.btnCopyUrlToClipboard.setIcon(new ImageIcon(this.getClass().getResource("/icons.fugue/clipboard--pencil.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopyUrlToClipboard, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnCopyUrlToClipboard.text"));
        this.btnCopyUrlToClipboard.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnCopyUrlToClipboard.toolTipText"));
        this.btnCopyUrlToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnCopyUrlToClipboardActionPerformed(evt);
            }
        });
        this.comboWebsites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.comboWebsitesActionPerformed(evt);
            }
        });
        this.btnRemoveWebsite.setIcon(new ImageIcon(this.getClass().getResource("/icons/Erase.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveWebsite, (String)NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnRemoveWebsite.text"));
        this.btnRemoveWebsite.setToolTipText(NbBundle.getMessage(StudioDetailsPanel.class, (String)"StudioDetailsPanel.btnRemoveWebsite.toolTipText"));
        this.btnRemoveWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioDetailsPanel.this.btnRemoveWebsiteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbName).addComponent(this.lbYearFounded).addComponent(this.lbDescription).addComponent(this.lbParent).addComponent(this.lbTypes).addComponent(this.lbUrl).addComponent(this.lbWebsites)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboParent, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboType1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboType2, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboType4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboType5, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboType3, -2, -1, -2).addComponent(this.comboType6, -2, -1, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.comboYear, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboYearDefunct, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addGap(51, 51, 51)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.tfName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSearchStudio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.lbPicture, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboAvailableWebsites, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfWebsite, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSaveWebsite)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnCopyUrlToClipboard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboWebsites, -2, 375, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddWebsite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveWebsite)).addComponent(this.websiteIconsPanel, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUpload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboStudios, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNew).addComponent(this.btnSave).addComponent(this.btnReset).addComponent(this.btnExport).addComponent(this.btnImport).addComponent(this.btnUpload).addComponent(this.jLabel3).addComponent(this.comboStudios, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfName, -2, -1, -2).addComponent(this.lbName)).addComponent(this.lbPicture, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.btnSearchStudio, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbWebsites).addComponent(this.comboWebsites, -2, -1, -2)).addComponent(this.btnAddWebsite).addComponent(this.btnRemoveWebsite).addComponent(this.btnCopyUrlToClipboard).addComponent(this.btnOpenUrl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tfWebsite, -2, -1, -2).addComponent(this.btnSaveWebsite)).addComponent(this.comboAvailableWebsites, -2, -1, -2)).addComponent(this.lbUrl, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.websiteIconsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbYearFounded).addComponent(this.comboYear, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.comboYearDefunct, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbDescription).addComponent(this.jScrollPane3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbParent).addComponent(this.comboParent, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboType1, -2, -1, -2).addComponent(this.comboType2, -2, -1, -2).addComponent(this.comboType3, -2, -1, -2).addComponent(this.lbTypes)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboType4, -2, -1, -2).addComponent(this.comboType5, -2, -1, -2).addComponent(this.comboType6, -2, -1, -2)).addContainerGap(402, Short.MAX_VALUE)));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout panelStudioDetailsLayout = new GroupLayout(this.panelStudioDetails);
        this.panelStudioDetails.setLayout(panelStudioDetailsLayout);
        panelStudioDetailsLayout.setHorizontalGroup(panelStudioDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelStudioDetailsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        panelStudioDetailsLayout.setVerticalGroup(panelStudioDetailsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelStudioDetailsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelStudioDetails, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelStudioDetails, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.newStudio();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.reloadStudio();
    }

    private void btnExportActionPerformed(ActionEvent evt) {
        this.exportStudio();
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        this.importStudio();
    }

    private void btnSearchStudioActionPerformed(ActionEvent evt) {
        this.searchForStudio();
    }

    private void btnUploadActionPerformed(ActionEvent evt) {
        this.checkToUploadStudio(this.currentStudio);
    }

    private void comboParentFocusGained(FocusEvent evt) {
        this.checkIfParentComboIsLoaded();
    }

    private void checkIfParentComboIsLoaded() {
        LOG.info("focus gained");
        LOG.info("parent combobox selected");
        if (this.db != null && this.comboParent.getModel().getSize() == 0) {
            List<String> studios = this.db.getStudios().stream().map(f -> f.getName()).collect(Collectors.toList());
            studios.add(0, null);
            this.comboParent.setModel(new DefaultComboBoxModel<String>(studios.toArray(new String[studios.size()])));
            LOG.info("parent combobox added values");
        }
    }

    private void tfNameFocusGained(FocusEvent evt) {
        this.checkIfParentComboIsLoaded();
    }

    private void comboStudiosActionPerformed(ActionEvent evt) {
        this.studioSelectionChanged();
    }

    private void btnAddWebsiteActionPerformed(ActionEvent evt) {
        this.comboAvailableWebsites.setVisible(true);
        this.tfWebsite.setVisible(true);
        this.lbUrl.setVisible(true);
        this.btnSaveWebsite.setVisible(true);
    }

    private void tfWebsiteActionPerformed(ActionEvent evt) {
    }

    private void btnSaveWebsiteActionPerformed(ActionEvent evt) {
        if (this.tfWebsite.getText().isBlank() || this.comboAvailableWebsites.getSelectedItem() == null) {
            AbstractTopComponent.notifyWarning("Ooops... there's something missing!");
        } else {
            StudioWebsites studioWebsites = new StudioWebsites();
            studioWebsites.setStudio(this.currentStudio);
            studioWebsites.setSocialWebsite((SocialWebsites)this.comboAvailableWebsites.getSelectedItem());
            studioWebsites.setUrl(this.tfWebsite.getText());
            this.comboWebsites.addItem(studioWebsites);
            this.comboAvailableWebsites.setVisible(false);
            this.tfWebsite.setVisible(false);
            this.tfWebsite.setText("");
            this.lbUrl.setVisible(false);
            this.btnSaveWebsite.setVisible(false);
            AbstractTopComponent.notifyInfo("Don't forget to also save the studio!");
        }
    }

    private void btnOpenUrlActionPerformed(ActionEvent evt) {
        if (this.comboWebsites.getSelectedItem() != null) {
            Object url = ((StudioWebsites)this.comboWebsites.getSelectedItem()).getUrl();
            if (!((String)url).startsWith("http")) {
                url = "https://" + (String)url;
            }
            ScenerixxCommon.openExternalBrowser((String)url, this.db.getScenerixxSettings().getPathToDefaultBrowserBinary());
        }
    }

    private void btnCopyUrlToClipboardActionPerformed(ActionEvent evt) {
        if (this.comboWebsites.getSelectedItem() != null) {
            StringSelection selection = new StringSelection(((StudioWebsites)this.comboWebsites.getSelectedItem()).getUrl());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }
    }

    private void btnRemoveWebsiteActionPerformed(ActionEvent evt) {
        this.comboWebsites.removeItem(this.comboWebsites.getSelectedItem());
        AbstractTopComponent.notifyInfo("Don't forget to also save the studio!");
    }

    private void tfNameActionPerformed(ActionEvent evt) {
    }

    private void comboWebsitesActionPerformed(ActionEvent evt) {
    }

    private void studioSelectionChanged() {
        if (((Studio)this.comboStudios.getSelectedItem()).getId() == null) {
            this.newStudio();
        } else {
            this.loadForm((Studio)this.comboStudios.getSelectedItem());
        }
    }

    void saveStudio() {
        if (this.tfName.getText().isEmpty()) {
            JOptionPane.showMessageDialog(null, "You need to provide at least a name", "Cannot save", 0);
        } else if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)this.tfName.getText())).findFirst() != null && this.currentStudio.getId() == null) {
            AbstractTopComponent.notifyWarning("Studio exists already. Data was NOT saved");
        } else {
            this.currentStudio.setName(this.tfName.getText());
            if ("??".equals((String)this.comboYear.getSelectedItem())) {
                this.currentStudio.setYearFounded(null);
            } else {
                this.currentStudio.setYearFounded(Integer.valueOf(Integer.parseInt((String)this.comboYear.getSelectedItem())));
            }
            if ("??".equals((String)this.comboYearDefunct.getSelectedItem())) {
                this.currentStudio.setYearDefunct(null);
            } else {
                this.currentStudio.setYearDefunct(Integer.valueOf(Integer.parseInt((String)this.comboYearDefunct.getSelectedItem())));
            }
            this.currentStudio.setPublicDescription(this.taDescription.getText());
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType1.getSelectedItem()))) {
                this.currentStudio.setType1(null);
            } else {
                this.currentStudio.setType1((MovieType)this.comboType1.getSelectedItem());
            }
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType2.getSelectedItem()))) {
                this.currentStudio.setType2(null);
            } else {
                this.currentStudio.setType2((MovieType)this.comboType2.getSelectedItem());
            }
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType3.getSelectedItem()))) {
                this.currentStudio.setType3(null);
            } else {
                this.currentStudio.setType3((MovieType)this.comboType3.getSelectedItem());
            }
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType4.getSelectedItem()))) {
                this.currentStudio.setType4(null);
            } else {
                this.currentStudio.setType4((MovieType)this.comboType4.getSelectedItem());
            }
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType5.getSelectedItem()))) {
                this.currentStudio.setType5(null);
            } else {
                this.currentStudio.setType5((MovieType)this.comboType5.getSelectedItem());
            }
            if (MovieType.UNDEFINED.equals((Object)((MovieType)this.comboType6.getSelectedItem()))) {
                this.currentStudio.setType6(null);
            } else {
                this.currentStudio.setType6((MovieType)this.comboType6.getSelectedItem());
            }
            if (this.comboParent.getSelectedItem() != null) {
                LOG.info("checking parent studio");
                if (((String)this.comboParent.getSelectedItem()).equalsIgnoreCase(this.currentStudio.getName())) {
                    LOG.info("selected: " + (String)this.comboParent.getSelectedItem() + " - Parent: " + this.currentStudio.getName());
                    this.comboParent.setSelectedItem(null);
                    JOptionPane.showMessageDialog(null, "Studio and parent studio cannot be the same. Parent not set.", "Error", 0);
                } else {
                    Studio studio = (Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(s -> s.name.eq((Object)((String)this.comboParent.getSelectedItem()))).findFirst();
                    this.currentStudio.setParent(studio);
                }
                int i = 0;
                boolean cyclic = false;
                Studio parentStudio = this.currentStudio.getParent();
                while (parentStudio != null) {
                    LOG.info("current : " + this.currentStudio.getName() + " - parent : " + parentStudio.getName());
                    if (this.currentStudio.getName().equalsIgnoreCase(parentStudio.getName())) {
                        cyclic = true;
                        break;
                    }
                    parentStudio = parentStudio.getParent();
                    if (++i <= 20) continue;
                    cyclic = true;
                    parentStudio = null;
                }
                if (cyclic) {
                    JOptionPane.showMessageDialog(null, "There's a cyclic dependency in your parent realtionship", "Cannot save", 0);
                    this.comboParent.setSelectedItem(null);
                    return;
                }
            }
            this.currentStudio.getStudioWebsites().clear();
            int size = this.comboWebsites.getItemCount();
            for (int i = 0; i < size; ++i) {
                StudioWebsites item = this.comboWebsites.getItemAt(i);
                System.out.println("Item at " + i + " = " + String.valueOf(item));
                this.currentStudio.getStudioWebsites().add(item);
            }
            this.currentStudio = (Studio)this.db.getEntityService().save((AbstractEntity)this.currentStudio);
            AbstractTopComponent.notifyInfo("Saved studio '" + this.currentStudio.getName() + "'");
            LOG.info("Saved studio '" + this.currentStudio.getName() + "'.");
            SwingUtilities.invokeLater(() -> AbstractTopComponent.dirtyStudiolist());
            this.setTabTitle();
            this.btnExport.setEnabled(true);
            this.btnUpload.setEnabled(Scenerixx.registered);
        }
    }

    private void reloadStudio() {
        if (this.currentStudio != null && this.currentStudio.getId() != null) {
            LOG.fine("Resetting changes of studio with ID " + this.currentStudio.getId());
            this.currentStudio = (Studio)this.db.getEntityService().load(Studio.class, this.currentStudio.getId().longValue());
            LOG.fine("Studio " + this.currentStudio.getName() + " was reloaded.");
            this.loadForm(this.currentStudio);
        } else {
            this.resetForm();
        }
    }

    private void newStudio() {
        this.currentStudio = new Studio();
        this.resetForm();
        this.setTabTitle();
    }

    private void setTabTitle() {
        SwingUtilities.invokeLater(() -> {
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                Object title = "Studio Details";
                if (this.currentStudio != null && this.currentStudio.getName() != null) {
                    title = "Studio (" + this.currentStudio.getName() + ")";
                }
                ((DetailsTopComponent)details).setStudioTabTitle((String)title);
            }
        });
    }

    private void exportStudio() {
        Exporter e = new Exporter();
        String destinationFileName = e.getDestinationFileName(this.currentStudio, Scenerixx.scenerixxFilesExportDirBase + Scenerixx.scenerixxFilesDirStudio);
        boolean overwriteOption = false;
        if (new File(destinationFileName).exists()) {
            int overwrite = JOptionPane.showConfirmDialog(null, "A file with the name '" + destinationFileName + "' already exists. Do you want to overwrite it?\n'Yes' overwrites the file, 'No' uses a new filename, 'Cancel' aborts", "File exists already", 1, 2);
            if (overwrite == 0) {
                overwriteOption = true;
            } else if (overwrite == 1) {
                overwriteOption = false;
            } else if (overwrite == 2) {
                AbstractTopComponent.notifyInfo("Aborted export. Existing file was not changed.");
                return;
            }
        }
        String exportStudioToFile = "";
        try {
            exportStudioToFile = e.exportStudioToFile(this.currentStudio, Scenerixx.scenerixxFilesExportDirBase + Scenerixx.scenerixxFilesDirStudio, overwriteOption);
            AbstractTopComponent.notify(this.currentStudio.getName() + " exported to " + exportStudioToFile, ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
            LOG.info("Exported '" + this.currentStudio.getName() + "' to " + exportStudioToFile);
        }
        catch (TransformerException ex) {
            JOptionPane.showMessageDialog(null, "An error occured while exporting '" + this.currentStudio.getName() + "' to " + exportStudioToFile + ". Does the destination exists?\nThe error message we received: " + ex.getMessageAndLocation());
        }
    }

    private void checkToUploadStudio(Studio existingStudio) {
        ScenerixxSettings settings = this.db.getScenerixxSettings();
        List<Studio> searchStudioOnServer = WebServiceHelper.searchStudioOnServer(this.tfName.getText(), false);
        if (searchStudioOnServer != null && !searchStudioOnServer.isEmpty()) {
            AbstractTopComponent.notifyInfo("Studio already exists on server");
            JDialog frame = new JDialog((Frame)null, "Studio Diff Panel", true);
            frame.getContentPane().add(new StudioDiffPanel(this, existingStudio, searchStudioOnServer));
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
        } else if (WebServiceHelper.uploadStudio(existingStudio)) {
            AbstractTopComponent.notify("Uploaded studio '" + existingStudio.getName() + "'! Thanks for sharing.", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
            this.btnUpload.setText("Update");
            this.btnUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/synchronize_ftp_password.png")));
        }
    }

    private void searchForStudio() {
        Object found = "";
        Studio studio = null;
        studio = (Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.contains(this.tfName.getText())).findFirst();
        if (studio != null) {
            found = "Found the studio in the database. ";
        } else {
            LOG.info("Check master database");
            DBInternal dbExport = DBInternal.getInstance((String)ScenerixxLib.HSQLDB_DATA_DB_FILE);
            List studiosInMasterDb = dbExport.getStudios();
            LOG.info("There are " + studiosInMasterDb.size() + " studios in the master database");
            int i = 1;
            for (Studio s : studiosInMasterDb) {
                LOG.fine(i++ + " " + s.getName());
            }
            Studio studioFromDb = dbExport.getStudio(this.tfName.getText());
            if (studioFromDb != null) {
                studio = studioFromDb;
                found = "Found " + studio.getName() + " in the master database. ";
            } else {
                LOG.info("Check scenerixx files");
                Importer imp = new Importer();
                try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirStudio, new String[0]), new FileVisitOption[0]);){
                    for (Path filePath : paths.collect(Collectors.toList())) {
                        if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                        try {
                            LOG.finest("Found a file: " + filePath.toString());
                            if (!filePath.toString().endsWith("studio.scenerixx")) continue;
                            LOG.fine("Loading " + filePath.toString());
                            Studio tmpStudio = imp.importStudioFile(filePath.toString());
                            if ((tmpStudio == null || !tmpStudio.getName().toLowerCase().contains(this.tfName.getText().toLowerCase())) && !tmpStudio.getName().toLowerCase().contains(this.tfName.getText().toLowerCase().replaceAll(" ", ""))) continue;
                            studio = tmpStudio;
                            break;
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
                if (studio != null) {
                    found = "Found the studio in the Scenerixx-files. ";
                } else {
                    List<Studio> searchStudioOnServer = WebServiceHelper.searchStudioOnServer(this.tfName.getText(), false);
                    if (searchStudioOnServer != null && !searchStudioOnServer.isEmpty()) {
                        studio = searchStudioOnServer.get(0);
                        Studio parentStudio = WebServiceHelper.searchParentStudioOnServer(studio.getId());
                        if (parentStudio != null) {
                            String parentStudioName = parentStudio.getName();
                            LOG.info("parent studio found: " + String.valueOf(parentStudio));
                            Studio parentFromDb = (Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.equalsIgnoreCase(parentStudioName)).findFirst();
                            if (parentFromDb != null) {
                                LOG.info("This parent already exists");
                                studio.setParent(parentStudio);
                            } else {
                                int importParent = JOptionPane.showConfirmDialog(null, "Should we also import the parent studio '" + parentStudio.getName() + "'?", "Also import parent studio", 0, 3);
                                if (importParent == 0) {
                                    LOG.info("Saved parent");
                                    parentStudio = (Studio)this.db.getEntityService().save((AbstractEntity)parentStudio);
                                    studio.setParent(parentStudio);
                                } else {
                                    LOG.info("parent not imported");
                                }
                            }
                        }
                        found = "Found the studio on the server. ";
                        if (searchStudioOnServer.size() > 1) {
                            JDialog frame = new JDialog((Frame)null, "Studio Diff Panel", true);
                            frame.getContentPane().add(new StudioDiffPanel(this, new Studio(), searchStudioOnServer));
                            frame.setDefaultCloseOperation(2);
                            frame.pack();
                            frame.setLocationRelativeTo(this);
                            frame.setVisible(true);
                            return;
                        }
                    }
                }
            }
        }
        if (studio != null) {
            this.loadForm(studio);
            AbstractTopComponent.notify((String)found + "Don't forget to save the studio if it's the right one", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
        } else {
            AbstractTopComponent.notifyWarning("Could not find a studio with the name " + this.tfName.getText() + "! Why don't you create it and share it with others?");
        }
    }

    private void importStudio() throws HeadlessException {
        block5: {
            this.jFileChooser1.setFileFilter(new FileNameExtensionFilter("Scenerixx-Import files", "scenerixx"));
            this.jFileChooser1.setCurrentDirectory(new File(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirStudio).getAbsoluteFile());
            int ret = this.jFileChooser1.showOpenDialog(this);
            if (ret == 0) {
                LOG.info("Going to import file " + String.valueOf(this.jFileChooser1.getSelectedFile()));
                Importer imp = new Importer();
                try {
                    Studio s = imp.importStudioFile(this.jFileChooser1.getSelectedFile().getAbsolutePath());
                    if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)s.getName())).count() == 0L) {
                        this.db.getEntityService().save((AbstractEntity)s);
                        LOG.info("Imported: " + s.getName());
                        this.loadForm(s);
                        break block5;
                    }
                    LOG.info("There was already a studio named " + s.getName() + ". No changes to the databases were made. Resetting form.");
                    this.resetForm();
                    JOptionPane.showMessageDialog(null, "There is already a studio with the name '" + s.getName() + "'. We cannot handle two studios with the same name yet. No changes were saved.");
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                }
            } else {
                LOG.finest("User requested to cancel import.");
            }
        }
    }

    public void loadForm(Studio s) {
        this.resetForm();
        this.comboWebsites.setModel(new DefaultComboBoxModel<StudioWebsites>((StudioWebsites[])s.getStudioWebsites().toArray(StudioWebsites[]::new)));
        this.tfWebsite.setText("");
        this.comboAvailableWebsites.setSelectedItem(null);
        this.websiteIconsPanel.loadStudio(s);
        this.comboAvailableWebsites.setVisible(false);
        this.tfWebsite.setVisible(false);
        this.btnSaveWebsite.setVisible(false);
        this.lbUrl.setVisible(false);
        this.tfName.setText(s.getName());
        if (s.getYearFounded() == null) {
            this.comboYear.setSelectedIndex(0);
        } else {
            this.comboYear.setSelectedIndex(LocalDate.now().getYear() - s.getYearFounded() + 1);
        }
        if (s.getYearDefunct() == null) {
            this.comboYearDefunct.setSelectedIndex(0);
        } else {
            this.comboYearDefunct.setSelectedIndex(LocalDate.now().getYear() - s.getYearDefunct() + 1);
        }
        this.comboType1.setSelectedItem(s.getType1());
        this.comboType2.setSelectedItem(s.getType2());
        this.comboType3.setSelectedItem(s.getType3());
        this.comboType4.setSelectedItem(s.getType4());
        this.comboType5.setSelectedItem(s.getType5());
        this.comboType6.setSelectedItem(s.getType6());
        this.taDescription.setText(s.getPublicDescription());
        LOG.info("parent: " + String.valueOf(s.getParent()));
        if (s.getParent() != null) {
            this.comboParent.setSelectedItem(s.getParent().getName());
        } else {
            this.comboParent.setSelectedItem(null);
        }
        this.currentStudio = s;
        LOG.info("Loaded studio: " + this.currentStudio.getName());
        this.showPicture(s);
        this.btnExport.setEnabled(true);
        this.btnUpload.setEnabled(Scenerixx.registered);
        if (s.getExternalId() == null) {
            this.btnUpload.setText("Upload");
            this.btnUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Upload.png")));
        } else {
            this.btnUpload.setText("Update");
            this.btnUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/synchronize_ftp_password.png")));
        }
        if (s.getId() == null && Scenerixx.registered) {
            this.btnSearchStudio.setEnabled(true);
        } else {
            this.btnSearchStudio.setEnabled(false);
        }
        if (s.getType1() == null) {
            this.comboType1.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType1.setSelectedItem(s.getType1());
        }
        if (s.getType2() == null) {
            this.comboType2.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType2.setSelectedItem(s.getType2());
        }
        if (s.getType3() == null) {
            this.comboType3.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType3.setSelectedItem(s.getType3());
        }
        if (s.getType4() == null) {
            this.comboType4.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType4.setSelectedItem(s.getType4());
        }
        if (s.getType5() == null) {
            this.comboType5.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType5.setSelectedItem(s.getType5());
        }
        if (s.getType6() == null) {
            this.comboType6.setSelectedItem(MovieType.UNDEFINED);
        } else {
            this.comboType6.setSelectedItem(s.getType6());
        }
    }

    private void showPicture(Studio studio) {
        File profileFile;
        this.lbPicture.setIcon(null);
        this.lbPicture.setSize(0, 0);
        String profilePictureDirectory = this.db.getScenerixxSettings().getProfilePictureDirectory();
        if (profilePictureDirectory != null && !profilePictureDirectory.isEmpty() && (profileFile = new ScenerixxCommon().findProfileFile(studio.getName(), new File(profilePictureDirectory))) != null) {
            this.lbPicture.setSize(this.HEIGHT, this.WIDTH);
            LOG.info("set panle size to " + this.HEIGHT + " - " + this.WIDTH);
            this.lbPicture.setIcon(ImageResizer.rescaleImage(profileFile, this.HEIGHT, this.WIDTH));
        }
    }

    private void prepareRegistrationNeededElements() {
        this.btnUpload.setEnabled(Scenerixx.registered);
        this.btnSearchStudio.setEnabled(Scenerixx.registered);
        if (Scenerixx.registered) {
            this.btnUpload.setToolTipText("<html>Uploads the current studio to the server <br>so others can download it.</html>");
            this.btnSearchStudio.setToolTipText("<html>Tries to find a studio with the specified name.<br>First it looks into the local Scenerixx files and then searches the studio on the server.</html>");
        } else {
            this.btnUpload.setToolTipText("<html>You need to be registered to upload a studio.</html>");
            this.btnSearchStudio.setToolTipText("<html>You need to be registered to search for studios.</html>");
        }
    }

    public void resetForm() {
        if (this.db != null) {
            List<String> studios = this.db.getStudios().stream().map(f -> f.getName()).collect(Collectors.toList());
            studios.add(0, null);
            this.comboParent.setModel(new DefaultComboBoxModel<String>(studios.toArray(new String[studios.size()])));
        }
        this.comboParent.setSelectedItem(null);
        this.prepareRegistrationNeededElements();
        this.btnExport.setEnabled(false);
        this.btnUpload.setEnabled(false);
        this.btnUpload.setText("Upload");
        this.btnUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Upload.png")));
        this.btnSearchStudio.setEnabled(Scenerixx.registered);
        this.tfName.setText("");
        this.comboYear.setSelectedIndex(0);
        this.comboYearDefunct.setSelectedIndex(0);
        this.taDescription.setText("");
        this.comboParent.setSelectedItem(null);
        this.comboType1.setSelectedItem(null);
        this.comboType2.setSelectedItem(null);
        this.comboType3.setSelectedItem(null);
        this.comboType4.setSelectedItem(null);
        this.comboType5.setSelectedItem(null);
        this.comboType6.setSelectedItem(null);
        this.lbPicture.setIcon(null);
        this.lbPicture.setSize(0, 0);
        this.setTabTitle();
        this.comboWebsites.setModel(new DefaultComboBoxModel());
        this.websiteIconsPanel.resetVisibility();
        this.currentStudio = new Studio();
        LOG.fine("Studio form was resetted.");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void resultChanged(LookupEvent lookupEvent) {
        LOG.finest("Change in studio details window was detected.");
        Collection coll = this.result.allInstances();
        if (!coll.isEmpty()) {
            LOG.finest("We have a studio");
            for (Studio s : coll) {
                this.loadForm(s);
            }
        } else {
            this.resetForm();
            LOG.finest("No studio found");
        }
    }
}

