/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.movie;

import com.github.lgooddatepicker.components.DatePicker;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.SequencedCollection;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.DOMException;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.XspfExporter;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.QBookmark;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.QScene;
import xxx.scenerixx.scenerixxlib.model.Resolution;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.model.enums.Tab;
import xxx.scenerixx.scenerixxlib.model.enums.gui.DateFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MovieTypeFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByMovie;
import xxx.scenerixx.scenerixxlib.model.enums.gui.ShowHideMovieFilter;
import xxx.scenerixx.scenerixxlib.model.medium.Dvd;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.search.QSearchQuery;
import xxx.scenerixx.scenerixxlib.model.search.SearchQuery;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.MovieChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.CompareMoviesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.OpenMoviesOwnInstanceAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddPersonsFromClipboardAction;
import xxx.scenerixx.scenerixxmodule.childfactories.special.MovieTypeChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.ResolutionChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.ResolutionHeightChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.ResolutionWidthChildFactory;
import xxx.scenerixx.scenerixxmodule.util.AutocompleterMovies;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.StandardContextMenu;
import xxx.scenerixx.scenerixxmodule.util.gui.bean.ScenerixxBeanTreeView;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.PlaylistSelectionPanel;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.DateFilterComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.MovieTypeFilterComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.OrderByMovieComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.ShowHideFilterComboBoxRenderer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.IDirty;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.action.AddMovieAction;
import xxx.scenerixx.scenerixxmodule.windows.movie.action.RecalculateTotalRuntimeAction;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

@TopComponent.Description(preferredID="MovieListTopComponent", iconBase="icons/movie.png", persistenceType=0)
public final class MovieListTopComponent
extends AbstractTopComponent
implements ExplorerManager.Provider,
IDirty {
    public static final Logger LOG = Logger.getLogger(MovieListTopComponent.class.getName());
    private boolean initialized = false;
    private static final ExplorerManager em = new ExplorerManager();
    private MovieChildFactory movieChildFactory = null;
    private MovieTypeChildFactory movieTypeChildFactory = null;
    private ResolutionChildFactory resolutionChildFactory = null;
    private ResolutionHeightChildFactory resolutionHeightChildFactory = null;
    private ResolutionWidthChildFactory resolutionWidthChildFactory = null;
    private AbstractNode abstractNodeMovieTypes = null;
    private AbstractNode abstractNodeResolution = null;
    private boolean showMoviesWithScenesSet = false;
    private boolean hideMoviesWithScenesSet = false;
    private boolean showMoviesWithScreencaps = false;
    private boolean hideMoviesWithScreencaps = false;
    private boolean showMoviesWithScenerixxFiles = false;
    private boolean hideMoviesWithScenerixxFiles = false;
    private boolean showPersonCompleteMovies = false;
    private boolean hidePersonCompleteMovies = false;
    private boolean showSceneLengthsSetMovies = false;
    private boolean hideSceneLengthsSetMovies = false;
    private boolean showWizard = false;
    private boolean hideWizard = false;
    private boolean showPlaylist = false;
    private boolean showMoviesWithMissingStudios = false;
    private boolean showMoviesWithMissingMediumFile = false;
    private boolean showMoviesWithSeveralMediumFile = false;
    private Playlist playlistToShow = null;
    private boolean showOnlyFavorites = false;
    private boolean showOnlySecret = false;
    private boolean showOnlyRegrettablyAwesome = false;
    private boolean showLastCame;
    private boolean showAllMovies = false;
    private boolean asc = true;
    private AutocompleterMovies autocompleter = new AutocompleterMovies(25, false);
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private boolean doNotAskForPlaylist = false;
    int reloads = 0;
    AbstractNode abstractNodeMovies = null;
    private BeanTreeView beanTreeViewAll;
    private JButton btnApplyDateFilter;
    private JButton btnCreateIntro;
    private JButton btnNewMovie;
    private JButton btnOpen;
    private JButton btnOpenRandom;
    private JButton btnReload;
    private JButton btnReload1;
    private JButton btnSelectRandomNode;
    private JToggleButton btnToggleMore;
    private JCheckBox cbFullscreen;
    private JCheckBox cbLoop;
    public JCheckBox cbPrefixMetaData;
    public JCheckBox cbShowCounter;
    public JCheckBox cbShowLikeCounter;
    public JCheckBox cbShowPosition;
    public JCheckBox cbShowRating;
    public JCheckBox cbShowResolution;
    public JCheckBox cbShowRuntime;
    public JCheckBox cbShowTooltips;
    public JCheckBox cbShowYear;
    private JComboBox<DateFilter> comboDateFilter;
    public JComboBox<MovieTypeFilter> comboMovieTypeFilter;
    public JComboBox<OrderByMovie> comboOrderByMovie;
    public JComboBox<ShowHideMovieFilter> comboShowHideFilter;
    private DatePicker datePickerFrom;
    private DatePicker datePickerTill;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JLabel lbApplyDateFilterFrom;
    private JLabel lbApplyDateFilterTill;
    private JLabel lbFilter;
    private JLabel lbOrderBy;
    private JLabel lbSearch;
    private JLabel lbStatus;
    private JPanel panelLowerPart;
    private JPanel panelShowMore;
    private JTextField tfLimit;
    private JTextField tfSearch;
    public JToggleButton toggleBtnAsc;

    public MovieListTopComponent() {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("Initialize Movies window: " + String.valueOf(now));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("Initializing Movies window");
            TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
            if (dashboard != null) {
                ((DashboardTopComponent)dashboard).setStatus("Initializing Movies window");
            }
        });
        this.initComponents();
        this.setName(Bundle.CTL_MovieListTopComponent());
        this.setToolTipText(Bundle.HINT_MovieListTopComponent());
        this.datePickerFrom.setSettings(ScenerixxCommon.getDatePickerSettings());
        this.datePickerTill.setSettings(ScenerixxCommon.getDatePickerSettings());
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/vlc.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/dice.png"), (int)4, (int)4);
        this.btnOpenRandom.setIcon(ImageUtilities.image2Icon((Image)image));
        this.comboShowHideFilter.setRenderer(new ShowHideFilterComboBoxRenderer());
        StandardContextMenu.addTo(this.tfSearch);
        MovieTypeFilter[] movieTypeFilterValues = MovieTypeFilter.values();
        if (!this.db.getScenerixxSettings().isShowDvd()) {
            ArrayList<MovieTypeFilter> mtfs = new ArrayList<MovieTypeFilter>();
            for (MovieTypeFilter mtf : MovieTypeFilter.values()) {
                if (MovieTypeFilter.Dvd.equals((Object)mtf)) continue;
                mtfs.add(mtf);
            }
            movieTypeFilterValues = (MovieTypeFilter[])mtfs.toArray(MovieTypeFilter[]::new);
        }
        this.comboMovieTypeFilter.setModel(new DefaultComboBoxModel<MovieTypeFilter>(movieTypeFilterValues));
        this.comboMovieTypeFilter.setRenderer(new MovieTypeFilterComboRenderer());
        this.comboOrderByMovie.setModel(new DefaultComboBoxModel<OrderByMovie>(OrderByMovie.values()));
        this.comboOrderByMovie.setRenderer(new OrderByMovieComboRenderer());
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        LOG.info("Initial Show favorites ui state: " + String.valueOf(uiState.getMovielistMovieShowHideMovieFilter()));
        this.toggleBtnAsc.setSelected(uiState.isMovielistAsc());
        this.cbShowCounter.setSelected(uiState.isMovielistCounter());
        this.cbShowLikeCounter.setSelected(uiState.isMovielistICameCounter());
        this.cbShowPosition.setSelected(uiState.isMovielistPosition());
        this.cbShowRating.setSelected(uiState.isMovielistRating());
        this.cbShowRuntime.setSelected(uiState.isMovielistRuntime());
        this.cbShowYear.setSelected(uiState.isMovielistYear());
        this.cbShowResolution.setSelected(uiState.isMovielistResolution());
        this.cbPrefixMetaData.setSelected(uiState.isPrefixMetadata());
        this.asc = uiState.isMovielistAsc();
        this.comboShowHideFilter.setModel(new DefaultComboBoxModel<ShowHideMovieFilter>(ShowHideMovieFilter.values()));
        this.updateShowHideFlags();
        this.comboDateFilter.setRenderer(new DateFilterComboRenderer());
        this.comboDateFilter.setModel(new DefaultComboBoxModel<DateFilter>(DateFilter.values()));
        LOG.info("Show favorites ui state: " + String.valueOf(uiState.getMovielistMovieShowHideMovieFilter()));
        LOG.info("Show favorites options: " + this.db.getScenerixxSettings().isShowFavoritesOnStartup());
        if (this.db.getScenerixxSettings().isShowFavoritesOnStartup()) {
            LOG.info("Show only favorites");
            this.comboShowHideFilter.setSelectedItem(ShowHideMovieFilter.ShowOnlyFavorites);
            this.showOnlyFavorites = true;
        } else {
            if (ShowHideMovieFilter.ShowPlaylist == uiState.getMovielistMovieShowHideMovieFilter()) {
                this.doNotAskForPlaylist = true;
                this.playlistToShow = uiState.getMovielistPlaylistToShow();
                LOG.info("playlist to show: " + String.valueOf(this.playlistToShow));
                if (this.playlistToShow != null) {
                    this.comboShowHideFilter.setSelectedItem(ShowHideMovieFilter.ShowPlaylist);
                } else {
                    this.comboShowHideFilter.setSelectedItem(ShowHideMovieFilter.ShowOnlyFavorites);
                }
            } else {
                this.comboShowHideFilter.setSelectedItem(uiState.getMovielistMovieShowHideMovieFilter());
            }
            this.doNotAskForPlaylist = false;
        }
        this.comboMovieTypeFilter.setSelectedItem(uiState.getMovielistMovieTypeFilter());
        this.comboOrderByMovie.setSelectedItem(uiState.getMovielistMovieOrderByMovie());
        this.toggleAsc();
        this.toggleShowMore();
        this.toggleIcons();
        this.lbStatus.setVisible(false);
        this.btnReload.setVisible(false);
        this.datePickerFrom.setDateToToday();
        this.datePickerTill.setDateToToday();
        this.tfLimit.setText("" + this.db.getScenerixxSettings().getInitialLimit());
        KeyStroke keyDelete = KeyStroke.getKeyStroke(127, 0);
        AbstractAction performDelete = new AbstractAction("performDelete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.deletePlayableItem();
            }
        };
        this.beanTreeViewAll.getActionMap().put("performDelete", performDelete);
        this.beanTreeViewAll.getInputMap(1).put(keyDelete, "performDelete");
        KeyStroke keyEnter = KeyStroke.getKeyStroke(10, 2);
        AbstractAction openSelectedItems = new AbstractAction("OpenSelectedItemsFromMovieList"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.openVlc();
            }
        };
        this.beanTreeViewAll.getActionMap().put("OpenSelectedItemsFromMovieList", openSelectedItems);
        this.beanTreeViewAll.getInputMap(1).put(keyEnter, "OpenSelectedItemsFromMovieList");
        KeyStroke keyAddPersonFromClipboard = KeyStroke.getKeyStroke(10, 192);
        this.beanTreeViewAll.getActionMap().put("OpenSeveralInstances", (Action)SystemAction.get(OpenMoviesOwnInstanceAction.class));
        this.beanTreeViewAll.getInputMap(1).put(keyAddPersonFromClipboard, "OpenSeveralInstances");
        KeyStroke keyOpenInSeveralInstance = KeyStroke.getKeyStroke(86, 192);
        this.beanTreeViewAll.getActionMap().put("AddPersonFromClipboard", (Action)SystemAction.get(AddPersonsFromClipboardAction.class));
        this.beanTreeViewAll.getInputMap(1).put(keyOpenInSeveralInstance, "AddPersonFromClipboard");
        KeyStroke keyInsert = KeyStroke.getKeyStroke(80, 128);
        AbstractAction addToPlaylist = new AbstractAction("AddToPlaylist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("Add to playlist shortcut");
                MovieListTopComponent.this.addToDefaultPlaylist(em.getSelectedNodes());
            }
        };
        this.beanTreeViewAll.getActionMap().put("AddToPlaylist", addToPlaylist);
        this.beanTreeViewAll.getInputMap(1).put(keyInsert, "AddToPlaylist");
        KeyStroke keyPlus = KeyStroke.getKeyStroke(521, 2);
        KeyStroke keyAdd = KeyStroke.getKeyStroke(107, 2);
        AbstractAction addSceneOrBookmark = new AbstractAction("AddSceneOrBookmark"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.addSceneOrBookmark(em.getSelectedNodes());
            }
        };
        this.beanTreeViewAll.getActionMap().put("AddSceneOrBookmark", addSceneOrBookmark);
        this.beanTreeViewAll.getInputMap(1).put(keyPlus, "AddSceneOrBookmark");
        this.beanTreeViewAll.getInputMap(1).put(keyAdd, "AddSceneOrBookmark");
        KeyStroke keyF6 = KeyStroke.getKeyStroke(117, 0);
        AbstractAction performAddToClipboard = new AbstractAction("performAddToClipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("copy to temp playlist");
                int movie = 0;
                int scene = 0;
                int bookmark = 0;
                String displayname = "";
                if (em.getSelectedNodes().length > 0) {
                    for (Node n : em.getSelectedNodes()) {
                        if (n.getValue("movie") != null) {
                            MovieListTopComponent.this.clipboard((IPlayablePlaylistItems)((Movie)n.getValue("movie")));
                            displayname = ((Movie)n.getValue("movie")).getNameOfPlayable();
                            ++movie;
                        }
                        if (n.getValue("scene") != null) {
                            MovieListTopComponent.this.clipboard((IPlayablePlaylistItems)((Scene)n.getValue("scene")));
                            displayname = ((Scene)n.getValue("scene")).getNameOfPlayable();
                            ++scene;
                        }
                        if (n.getValue("bookmark") == null) continue;
                        MovieListTopComponent.this.clipboard((IPlayablePlaylistItems)((Bookmark)n.getValue("bookmark")));
                        displayname = ((Bookmark)n.getValue("bookmark")).getNameOfPlayable();
                        ++bookmark;
                    }
                    if (movie + scene + bookmark == 1) {
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + displayname);
                        LOG.info("added to temporary playlist: " + displayname);
                    } else {
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + ScenerixxCommon.singularPlural(movie, "movie", true) + ", " + ScenerixxCommon.singularPlural(scene, "scene", true) + ", " + ScenerixxCommon.singularPlural(bookmark, "bookmark", true));
                        LOG.info("added to temporary playlist: " + ScenerixxCommon.singularPlural(movie, "movie", true) + ", " + ScenerixxCommon.singularPlural(scene, "scene", true) + ", " + ScenerixxCommon.singularPlural(bookmark, "bookmark", true));
                    }
                    AbstractTopComponent.reloadPlaylist("[TEMPORARY PLAYLIST]");
                }
            }
        };
        this.beanTreeViewAll.getActionMap().put("performAddToClipboard", performAddToClipboard);
        this.beanTreeViewAll.getInputMap(1).put(keyF6, "performAddToClipboard");
        KeyStroke keyF8 = KeyStroke.getKeyStroke(119, 0);
        this.beanTreeViewAll.getActionMap().put("performCompareMovies", (Action)SystemAction.get(CompareMoviesAction.class));
        this.beanTreeViewAll.getInputMap(1).put(keyF8, "performCompareMovies");
        AbstractAction reloadAction = new AbstractAction("reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.reloadList();
            }
        };
        KeyStroke keyF5 = KeyStroke.getKeyStroke(116, 0);
        this.beanTreeViewAll.getActionMap().put("reload", reloadAction);
        this.beanTreeViewAll.getInputMap(1).put(keyF5, "reload");
        AbstractAction randomSelectAction = new AbstractAction("randomSelect"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.selectRandomNode(0);
            }
        };
        KeyStroke keyCtrlR = KeyStroke.getKeyStroke(82, 128);
        this.beanTreeViewAll.getActionMap().put("randomSelect", randomSelectAction);
        this.beanTreeViewAll.getInputMap(1).put(keyCtrlR, "randomSelect");
        AbstractAction randomOpenAction = new AbstractAction("randomOpen"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.openRandomMovie();
            }
        };
        KeyStroke keyAltR = KeyStroke.getKeyStroke(82, 512);
        this.beanTreeViewAll.getActionMap().put("randomOpen", randomOpenAction);
        this.beanTreeViewAll.getInputMap(1).put(keyAltR, "randomOpen");
        AbstractAction markAsFavoriteAction = new AbstractAction("markAsFavorite"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.markAsFavorite();
            }
        };
        KeyStroke keyAltF = KeyStroke.getKeyStroke(70, 512);
        this.beanTreeViewAll.getActionMap().put("markAsFavorite", markAsFavoriteAction);
        this.beanTreeViewAll.getInputMap(1).put(keyAltF, "markAsFavorite");
        AbstractAction unmarkAsFavoriteAction = new AbstractAction("unmarkAsFavorite"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieListTopComponent.this.unmarkAsFavorite();
            }
        };
        KeyStroke keyShiftAltF = KeyStroke.getKeyStroke(70, 576);
        this.beanTreeViewAll.getActionMap().put("unmarkAsFavorite", unmarkAsFavoriteAction);
        this.beanTreeViewAll.getInputMap(1).put(keyShiftAltF, "unmarkAsFavorite");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)this.getActionMap()));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            this.initialized = true;
            LOG.info("Movie list is initialized");
            if (!this.db.getScenerixxSettings().isLoadMoviesOnStartup()) {
                LOG.info("Movie list should not be loaded during startup");
                this.setDirty();
                return;
            }
            this.reloadList();
            try {
                if (em.getRootContext().getChildren().getNodesCount() > 0) {
                    em.setSelectedNodes(new Node[]{em.getRootContext().getChildren().getNodeAt(0)});
                    Movie movie = (Movie)em.getSelectedNodes()[0].getValue("movie");
                    if (movie != null) {
                        this.reloadDetails(movie);
                    }
                }
                LOG.info("finished thread for initializing movie list window " + Duration.between(LocalDateTime.now(), now).toString());
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        });
        this.autocompleter.getAutoComplete().attachTo(this.tfSearch);
        em.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selectedNodes = em.getSelectedNodes();
                ScenerixxCommon.setSelectedNodesInTitle(selectedNodes.length, "playable");
            }
        });
        LOG.info("finished initializing movie list window " + Duration.between(LocalDateTime.now(), now).toString());
    }

    @Override
    public void setDirty() {
        this.setDirty(false);
    }

    public void setDirty(boolean clearList) {
        this.lbStatus.setVisible(true);
        this.lbStatus.setText("View might be out of sync!");
        this.btnReload.setVisible(true);
        if (clearList) {
            this.setRootContext(new ArrayList<Movie>());
        }
    }

    public void deletePlayableItem() {
        boolean reload = false;
        int cntMovie = 0;
        int cntScene = 0;
        int cntBookmark = 0;
        int cntSubBookmark = 0;
        for (Node n : em.getSelectedNodes()) {
            Bookmark bookmark;
            Scene scene;
            Movie movie = (Movie)n.getValue("movie");
            if (movie != null) {
                ++cntMovie;
            }
            if ((scene = (Scene)n.getValue("scene")) != null) {
                ++cntScene;
            }
            if ((bookmark = (Bookmark)n.getValue("bookmark")) == null) continue;
            ++cntBookmark;
            cntSubBookmark += bookmark.getChildren(true).size();
        }
        if (cntMovie > 0 || cntScene > 0 || cntBookmark > 0) {
            Object msg = "<html>Do you really want to delete:<br> ";
            if (cntMovie > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntMovie, "movie", "movies", true) + "<br>";
            }
            if (cntScene > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntScene, "scene", "scenes", true) + "<br>";
            }
            if (cntBookmark > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntBookmark, "bookmark", "bookmarks", true) + "<br>";
                if (cntSubBookmark > 0) {
                    msg = (String)msg + ScenerixxCommon.singularPlural(cntSubBookmark, "sub-bookmark", "sub-bookmarks", true) + "<br>";
                }
            }
            if (0 == JOptionPane.showConfirmDialog(null, msg, "Delete playable items?", 0)) {
                cntMovie = 0;
                cntScene = 0;
                cntBookmark = 0;
                Node nodeToSelect = null;
                for (Node n : em.getSelectedNodes()) {
                    Bookmark bookmark;
                    Scene scene;
                    Movie movie = (Movie)n.getValue("movie");
                    if (movie != null) {
                        nodeToSelect = this.getNextNode();
                        this.db.deleteMovie(movie);
                        ++cntMovie;
                        reload = true;
                    }
                    if ((scene = (Scene)n.getValue("scene")) != null) {
                        scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                        this.db.deleteScene(scene);
                        ++cntScene;
                        nodeToSelect = n.getParentNode();
                    }
                    if ((bookmark = (Bookmark)n.getValue("bookmark")) == null) continue;
                    bookmark = (Bookmark)this.db.getEntityService().load(Bookmark.class, bookmark.getId().longValue());
                    this.db.deleteBookmark(bookmark);
                    ++cntBookmark;
                    nodeToSelect = n.getParentNode();
                }
                if (em.getRootContext().getChildren().getNodesCount() <= 5000) {
                    this.reloadList(nodeToSelect);
                } else {
                    for (int i = 0; i < em.getSelectedNodes().length; ++i) {
                        em.getSelectedNodes()[i].setDisplayName("<html><font color=\"" + ScenerixxCommonLib.RED + "\">Deleted!</font> <strike>" + em.getSelectedNodes()[i].getHtmlDisplayName() + "</strike> (this node will be removed with the next reload)</html>");
                    }
                    MovieListTopComponent.dirtyMovieList();
                }
                if (reload) {
                    MovieListTopComponent.reloadPlaylist();
                    MovieListTopComponent.dirtyStudiolist();
                    MovieListTopComponent.dirtyPersonList();
                    MovieListTopComponent.dirtyMediumFileList();
                }
                Object deletedMsg = "<html>";
                if (cntMovie > 0) {
                    deletedMsg = (String)deletedMsg + ScenerixxCommon.singularPlural(cntMovie, "movie", "movies", true) + "<br>";
                }
                if (cntScene > 0) {
                    deletedMsg = (String)deletedMsg + ScenerixxCommon.singularPlural(cntScene, "scene", "scenes", true) + "<br>";
                }
                if (cntBookmark > 0) {
                    deletedMsg = (String)deletedMsg + ScenerixxCommon.singularPlural(cntBookmark, "bookmark", "bookmarks", true);
                }
                deletedMsg = (String)deletedMsg + "</html>";
                AbstractTopComponent.notify("Deleted", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), (String)deletedMsg, null, NotificationDisplayer.Priority.LOW);
            }
        }
    }

    private void setRootDisplayName(String title, Long runtime, Integer count) {
        LOG.info("root displayname: " + title + " - " + runtime + " - " + count);
        SwingUtilities.invokeLater(() -> {
            String displayString = title;
            if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Type) {
                displayString = "Movie types";
            }
            String sRuntime = "";
            if (this.cbShowRuntime.isSelected() && runtime != null) {
                sRuntime = ScenerixxCommon.readableRuntime(runtime);
            }
            int nodeCount = em.getRootContext().getChildren().getNodesCount();
            if (count != null) {
                nodeCount = count;
            }
            this.setName(Bundle.CTL_MovieListTopComponent() + " [" + nodeCount + "]");
            em.getRootContext().setDisplayName(displayString + " [" + nodeCount + "] " + sRuntime);
        });
    }

    private DB.OrderBy getOrderBy() {
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Title) {
            return DB.OrderBy.TITLE;
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Runtime) {
            this.cbShowRuntime.setSelected(true);
            return DB.OrderBy.RUNTIME;
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.LastModification) {
            return DB.OrderBy.LASTMODIFICATION;
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.DateOfCreation) {
            return DB.OrderBy.CREATED;
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.DateOfShoot) {
            return DB.OrderBy.DATEOFSHOOT;
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Rating) {
            this.cbShowRating.setSelected(true);
            return DB.OrderBy.RATING;
        }
        return DB.OrderBy.TITLE;
    }

    private void reloadList(Node node) {
        LOG.info("RELOOOOOOOOOOOOOOADDING");
        this.doReloadList(node);
    }

    private void doReloadList(Node node) {
        if (!this.initialized) {
            LOG.fine("Still in initialization phase. Abort movie list reload.");
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        LOG.fine("reload list (" + this.reloads + ") " + String.valueOf(now));
        LocalDateTime fromCreation = null;
        LocalDateTime tillCreation = null;
        LocalDateTime fromModification = null;
        LocalDateTime tillModification = null;
        if (this.datePickerFrom.getDate() == null) {
            this.datePickerFrom.setDateToToday();
            MovieListTopComponent.notifyInfo("from-date not set. Set it to today.");
        }
        if (this.datePickerTill.getDate() == null) {
            this.datePickerTill.setDateToToday();
            MovieListTopComponent.notifyInfo("till-date not set. Set it to today.");
        }
        if (DateFilter.DateOfCreation.equals(this.comboDateFilter.getSelectedItem())) {
            fromCreation = this.datePickerFrom.getDate().atStartOfDay();
            tillCreation = this.datePickerTill.getDate().atTime(23, 59, 59);
        }
        if (DateFilter.DateOfLastModification.equals(this.comboDateFilter.getSelectedItem())) {
            fromModification = this.datePickerFrom.getDate().atStartOfDay();
            tillModification = this.datePickerTill.getDate().atTime(23, 59, 59);
        }
        this.db = DB.getInstance();
        this.db.getEntityService().getEntityManager().clear();
        this.comboShowHideFilter.setVisible(true);
        this.lbFilter.setVisible(true);
        if (this.showPlaylist || this.showOnlyFavorites || this.showOnlySecret || this.showLastCame || this.showMoviesWithScenesSet || this.hideMoviesWithScenesSet || this.showMoviesWithScreencaps || this.hideMoviesWithScreencaps || this.showMoviesWithScenerixxFiles || this.hideMoviesWithScenerixxFiles || this.showPersonCompleteMovies || this.hidePersonCompleteMovies || this.showSceneLengthsSetMovies || this.hideSceneLengthsSetMovies) {
            this.comboMovieTypeFilter.setSelectedItem(MovieTypeFilter.All);
            this.comboMovieTypeFilter.setEnabled(false);
        } else {
            this.comboMovieTypeFilter.setEnabled(true);
        }
        if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Type) {
            LOG.info("reload by: movie types");
            this.comboShowHideFilter.setVisible(false);
            this.lbFilter.setVisible(false);
            this.setRootContextOrderByType();
        } else if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.Resolution) {
            LOG.info("reload by: resolution");
            this.comboShowHideFilter.setVisible(false);
            this.lbFilter.setVisible(false);
            this.setRootContextOrderByResolution();
        } else if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.ResolutionHeight) {
            LOG.info("reload by: resolution height");
            this.comboShowHideFilter.setVisible(false);
            this.lbFilter.setVisible(false);
            this.setRootContextOrderByResolutionHeight();
        } else if (this.comboOrderByMovie.getSelectedItem() == OrderByMovie.ResolutionWidth) {
            LOG.info("reload by: resolution width");
            this.comboShowHideFilter.setVisible(false);
            this.lbFilter.setVisible(false);
            this.setRootContextOrderByResolutionWidth();
        } else {
            List movies;
            MovieTypeFilter movieTypeFilter = (MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem();
            LOG.fine("load movies from db with filter: " + String.valueOf(movieTypeFilter) + ": " + Duration.between(LocalDateTime.now(), now).toString());
            Long limit = Long.MAX_VALUE;
            try {
                if (!this.tfLimit.getText().isBlank()) {
                    limit = Long.valueOf(this.tfLimit.getText().trim());
                }
            }
            catch (Exception ex) {
                MovieListTopComponent.notifyWarning("Could not parse limit. Show all nodes.");
            }
            if (this.showOnlyRegrettablyAwesome) {
                LOG.info("reload by: regrettably awesome");
                movies = this.db.getRegrettablyAwesomeMovies(true, this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.showOnlyFavorites) {
                LOG.info("reload by: favorites");
                movies = this.db.getFavoriteMovies(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, fromModification, tillModification, fromCreation, tillCreation, limit.longValue());
            } else if (this.showOnlySecret) {
                LOG.info("reload by: secret");
                movies = this.db.getSecretMovies(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, fromModification, tillModification, fromCreation, tillCreation, limit.longValue());
            } else if (this.showLastCame) {
                LOG.info("reload by: last came");
                movies = this.db.getLastCameMovies(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, fromModification, tillModification, fromCreation, tillCreation, limit.longValue());
            } else if (this.showWizard) {
                LOG.info("reload by: show wizard");
                movies = this.db.getWizardGeneratedMovies(true, this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.hideWizard) {
                LOG.info("reload by: hide wizard");
                movies = this.db.getWizardGeneratedMovies(false, this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.hideSceneLengthsSetMovies) {
                LOG.info("reload by: hide scene length");
                movies = this.db.getMoviesSceneLengthSet(false, this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.showSceneLengthsSetMovies) {
                LOG.info("reload by: show scene length");
                movies = this.db.getMoviesSceneLengthSet(true, this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.showMoviesWithMissingStudios) {
                LOG.info("reload by: show missing studio");
                movies = this.db.getMoviesWithMissingStudios(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.showMoviesWithMissingMediumFile) {
                LOG.info("reload by: show missing medium file");
                movies = this.db.getMoviesWithMissingMediumFile(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else if (this.showMoviesWithSeveralMediumFile) {
                LOG.info("reload by: show movies with several medium file");
                movies = this.db.getMoviesWithSeveralMediumFilesAssigned(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, movieTypeFilter, limit.longValue());
            } else {
                if (this.showPlaylist && this.playlistToShow != null) {
                    LOG.info("reload by: show playlist");
                    if (!this.playlistToShow.isTemporaryPlaylist()) {
                        this.playlistToShow = (Playlist)this.db.getEntityService().load(Playlist.class, this.playlistToShow.getId().longValue());
                    }
                    if (this.playlistToShow != null) {
                        this.showPlaylist(this.playlistToShow);
                    }
                    this.resetDirtyState();
                    return;
                }
                LOG.info("reload by: something else");
                movies = this.db.getMovies(this.tfSearch.getText(), this.getOrderBy(), Scenerixx.unlocked, false, limit.longValue(), fromModification, tillModification, fromCreation, tillCreation, (MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem());
            }
            LOG.fine("Loaded... " + movies.size() + " movies - " + Duration.between(LocalDateTime.now(), now).toString());
            int n = this.setRootContext(movies);
        }
        LOG.fine("root context set. set explored context for node " + String.valueOf(node) + " - " + Duration.between(LocalDateTime.now(), now).toString());
        this.beanTreeViewAll.revalidate();
        this.beanTreeViewAll.requestFocus();
        this.resetDirtyState();
        LOG.fine("finished with " + em.getSelectedNodes().length + " selected nodes... " + Duration.between(LocalDateTime.now(), now).toString());
        LOG.fine("--------");
    }

    private void resetDirtyState() {
        this.lbStatus.setText("");
        this.lbStatus.setVisible(false);
        this.btnReload.setVisible(false);
    }

    private String getSelectedMovieType() {
        String displayName = "All media";
        if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Dvd) {
            displayName = "DVDs";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Movies) {
            displayName = "Movies";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Scenes) {
            displayName = "Single Scenes";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Snippets) {
            displayName = "Snippets";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.VR) {
            displayName = "VR";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.ThreeD) {
            displayName = "3D";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Interactive) {
            displayName = "Interactive";
        }
        return displayName;
    }

    private String getShowHideFilter() {
        String movieType = "[" + this.getSelectedMovieType() + "]";
        Object displayName = "All media";
        if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlyFavorites) {
            displayName = "Favorites " + movieType;
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlySecrets) {
            displayName = "Secrets " + movieType;
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlyRegrettablyAwesome) {
            displayName = "Regrettably Awesome " + movieType;
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowPlaylist) {
            displayName = this.playlistToShow == null || this.playlistToShow.isTemporaryPlaylist() ? "Playlist [temporary]" : "Playlist [" + this.playlistToShow.getName() + "]";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowLastCame) {
            displayName = "Show " + movieType + " I last came";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesThatAreGeneratedByWizard) {
            displayName = "Hide " + movieType + " that are generated by the wizard";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereAllScenesAssociatedToPersons) {
            displayName = "Hide " + movieType + " where all scenes are associated to a person";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereAllScenesLengthSet) {
            displayName = "Hide " + movieType + " where all scene lengths are set";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScreencapExists) {
            displayName = "Hide " + movieType + " where a corresponding screencap exists";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScenerixxFileExists) {
            displayName = "Hide " + movieType + " where a corresponding scenerixx file exists";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScenesAreAssociated) {
            displayName = "Hide " + movieType + " where scenes are associated";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesThatAreGeneratedByWizard) {
            displayName = "Show " + movieType + " that are generated by the wizard";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereAllScenesAssociatedToPersons) {
            displayName = "Show " + movieType + " where all scenes are associated to a person";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereAllScenesLengthSet) {
            displayName = "Show " + movieType + " where all scene lengths are set";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScreencapExists) {
            displayName = "Show " + movieType + " where a corresponding screencap exists";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScenerixxFileExists) {
            displayName = "Show " + movieType + " where a corresponding scenerixx file exists";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScenesAreAssociated) {
            displayName = "Show " + movieType + " where scenes are associated";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithMissingMediumFile) {
            displayName = "Show " + movieType + " with missing medium file";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithSeveralMediumFile) {
            displayName = "Show " + movieType + " with several assigend medium files";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithMissingStudio) {
            displayName = "Show " + movieType + " with missing studio";
        } else if ((ShowHideMovieFilter)this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowAllMovies) {
            displayName = "Show all";
        }
        return displayName;
    }

    public void refresh() {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            LocalDateTime now = LocalDateTime.now();
            Node node = null;
            if (em.getSelectedNodes().length > 0) {
                node = em.getSelectedNodes()[0];
            }
            LOG.fine("Refreshing movie child factory " + this.movieChildFactory.getResultList().size() + " - " + Duration.between(LocalDateTime.now(), now).toString());
            this.movieChildFactory.refresh();
            String displayName1 = this.getShowHideFilter();
            if (this.cbShowRuntime.isSelected()) {
                ArrayList<Movie> tmpList = new ArrayList<Movie>();
                for (INode tmpNode : this.movieChildFactory.getResultList()) {
                    if (!(tmpNode instanceof Movie)) continue;
                    Movie movie = (Movie)tmpNode;
                    tmpList.add(movie);
                }
                this.setRootDisplayName(displayName1, ScenerixxCommon.calculateRuntime(tmpList), em.getRootContext().getChildren().getNodesCount());
            } else {
                this.setRootDisplayName(displayName1, null, em.getRootContext().getChildren().getNodesCount());
            }
            LOG.fine("finished refreshing " + Duration.between(LocalDateTime.now(), now).toString());
            if (node != null) {
                if (node.getValue("scene") != null) {
                    LOG.info("selected scene : " + ((Scene)node.getValue("scene")).getNameOfPlayable());
                    this.selectSceneNode((Scene)node.getValue("scene"));
                } else if (node.getValue("movie") != null) {
                    LOG.info("selected movie : " + ((Movie)node.getValue("movie")).getNameOfPlayable());
                    this.selectMovieNode((Movie)node.getValue("movie"));
                } else if (node.getValue("bookmark") != null) {
                    LOG.info("selected bookmark : " + ((Bookmark)node.getValue("bookmark")).getNameOfPlayable());
                    this.selectBookmarkNode((Bookmark)node.getValue("bookmark"));
                } else {
                    LOG.info("node selected but another one: " + String.valueOf(node));
                }
                LOG.fine("finished selecting node " + Duration.between(LocalDateTime.now(), now).toString());
            } else {
                LOG.info("no node selected");
            }
        });
    }

    public void clearSearchFild() {
        this.tfSearch.setText("");
    }

    public void clearFilter() {
        this.tfSearch.setText("");
        this.tfLimit.setVisible(true);
        this.tfLimit.setText("" + this.db.getScenerixxSettings().getInitialLimit());
        this.comboShowHideFilter.setSelectedItem(ShowHideMovieFilter.ShowAllMovies);
    }

    public int setRootContext(List<Movie> movies) {
        if (!this.initialized) {
            return -1;
        }
        LOG.info("set root context: " + movies.size());
        this.updateShowHideFlags();
        if (!this.asc) {
            Collections.reverse(movies);
        }
        if (!this.tfSearch.getText().isEmpty() && !this.tfSearch.getText().startsWith("#")) {
            ArrayList<Movie> tmpListMovies = new ArrayList<Movie>(movies);
            for (Movie m : tmpListMovies) {
                if (this.db.containsAllSearchTerms(this.tfSearch.getText(), m)) continue;
                LOG.info("REMOVE from result list: " + m.getTitle());
                movies.remove(m);
            }
        }
        if (this.movieChildFactory == null) {
            ArrayList<Movie> tmpList = new ArrayList<Movie>();
            tmpList.addAll(movies);
            this.movieChildFactory = new MovieChildFactory(tmpList, this.showMoviesWithScenesSet, this.hideMoviesWithScenesSet, this.showMoviesWithScenerixxFiles, this.hideMoviesWithScenerixxFiles, this.cbShowCounter.isSelected(), this.showPersonCompleteMovies, this.hidePersonCompleteMovies, this.showSceneLengthsSetMovies, this.hideSceneLengthsSetMovies, this.showWizard, this.hideWizard, this.cbShowLikeCounter.isSelected(), this.cbShowRuntime.isSelected(), this.cbShowRating.isSelected(), this.cbShowPosition.isSelected(), this.showOnlyFavorites, this.showOnlySecret, this.cbShowYear.isSelected(), this.cbShowResolution.isSelected(), this.cbPrefixMetaData.isSelected(), false, this.showMoviesWithScreencaps, this.hideMoviesWithScreencaps){

                @Override
                public void reloadList(Node node, boolean reloadFromDb) {
                    super.reloadList(node, reloadFromDb);
                    MovieListTopComponent.this.reloadList(node);
                    MovieListTopComponent.this.refocus();
                }
            };
            this.abstractNodeMovies = new AbstractNode(Children.create((ChildFactory)this.movieChildFactory, (boolean)false)){

                public Action[] getActions(boolean context) {
                    ArrayList<SystemAction> list = new ArrayList<SystemAction>();
                    list.add(SystemAction.get(AddMovieAction.class));
                    list.add(SystemAction.get(xxx.scenerixx.scenerixxmodule.windows.movie.action.ReloadAction.class));
                    list.add(SystemAction.get(RecalculateTotalRuntimeAction.class));
                    Action[] actions = new Action[list.size()];
                    actions = list.toArray(actions);
                    return actions;
                }

                public Image getIcon(int type) {
                    return ImageUtilities.loadImage((String)((MovieTypeFilter)MovieListTopComponent.this.comboMovieTypeFilter.getSelectedItem()).getIcon());
                }

                public Image getOpenedIcon(int type) {
                    return this.getIcon(type);
                }
            };
            this.refresh();
        } else {
            this.movieChildFactory.getResultList().clear();
            this.movieChildFactory.getResultList().addAll(movies);
            this.movieChildFactory.setShowOnlyFavorites(this.showOnlyFavorites);
            this.movieChildFactory.setShowOnlySecrets(this.showOnlySecret);
            this.movieChildFactory.setShowMoviesWithScenesSet(this.showMoviesWithScenesSet);
            this.movieChildFactory.setHideMoviesWithScenesSet(this.hideMoviesWithScenesSet);
            this.movieChildFactory.setShowMoviesWithScreencaps(this.showMoviesWithScreencaps);
            this.movieChildFactory.setHideMoviesWithScreencaps(this.hideMoviesWithScreencaps);
            this.movieChildFactory.setShowMoviesWithScenerixxFiles(this.showMoviesWithScenerixxFiles);
            this.movieChildFactory.setHideMoviesWithScenerixxFiles(this.hideMoviesWithScenerixxFiles);
            this.movieChildFactory.setShowCounter(this.cbShowCounter.isSelected());
            this.movieChildFactory.setShowPersonCompleteMovies(this.showPersonCompleteMovies);
            this.movieChildFactory.setHidePersonCompleteMovies(this.hidePersonCompleteMovies);
            this.movieChildFactory.setShowSceneLengthCompleteMovies(this.showSceneLengthsSetMovies);
            this.movieChildFactory.setHideSceneLengthCompleteMovies(this.hideSceneLengthsSetMovies);
            this.movieChildFactory.setShowLikeCounter(this.cbShowLikeCounter.isSelected());
            this.movieChildFactory.setShowRuntime(this.cbShowRuntime.isSelected());
            this.movieChildFactory.setShowRating(this.cbShowRating.isSelected());
            this.movieChildFactory.setShowWizard(this.showWizard);
            this.movieChildFactory.setHideWizard(this.hideWizard);
            this.movieChildFactory.setSearchTerms(this.tfSearch.getText());
            this.movieChildFactory.setShowPosition(this.cbShowPosition.isSelected());
            this.movieChildFactory.setShowYear(this.cbShowYear.isSelected());
            this.movieChildFactory.setShowResolution(this.cbShowResolution.isSelected());
            this.movieChildFactory.setPrefixMetadata(this.cbPrefixMetaData.isSelected());
            LOG.info("Refresh Existing ChildFactory ");
            LOG.info("request active");
            SwingUtilities.invokeLater(() -> {
                this.requestActive();
                this.refresh();
            });
        }
        this.abstractNodeMovies.setIconBaseWithExtension(((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem()).getIcon());
        em.setRootContext((Node)this.abstractNodeMovies);
        LOG.info("abstract node : n/a - movies: " + movies.size());
        return movies.size();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.btnNewMovie = new JButton();
        this.btnCreateIntro = new JButton();
        this.panelLowerPart = new JPanel();
        this.jLabel3 = new JLabel();
        this.lbOrderBy = new JLabel();
        this.comboMovieTypeFilter = new JComboBox();
        this.comboOrderByMovie = new JComboBox();
        this.lbSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.btnToggleMore = new JToggleButton();
        this.comboShowHideFilter = new JComboBox();
        this.toggleBtnAsc = new JToggleButton();
        this.panelShowMore = new JPanel();
        this.cbShowPosition = new JCheckBox();
        this.cbShowRating = new JCheckBox();
        this.cbShowRuntime = new JCheckBox();
        this.cbShowCounter = new JCheckBox();
        this.cbShowLikeCounter = new JCheckBox();
        this.datePickerFrom = new DatePicker();
        this.datePickerTill = new DatePicker();
        this.comboDateFilter = new JComboBox();
        this.btnApplyDateFilter = new JButton();
        this.lbApplyDateFilterFrom = new JLabel();
        this.lbApplyDateFilterTill = new JLabel();
        this.cbShowYear = new JCheckBox();
        this.cbShowResolution = new JCheckBox();
        this.cbPrefixMetaData = new JCheckBox();
        this.lbFilter = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.tfLimit = new JTextField();
        this.cbShowTooltips = new JCheckBox();
        this.beanTreeViewAll = new ScenerixxBeanTreeView();
        this.btnSelectRandomNode = new JButton();
        this.btnOpen = new JButton();
        this.cbFullscreen = new JCheckBox();
        this.cbLoop = new JCheckBox();
        this.btnOpenRandom = new JButton();
        this.lbStatus = new JLabel();
        this.btnReload = new JButton();
        this.btnReload1 = new JButton();
        this.btnNewMovie.setIcon(new ImageIcon(this.getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewMovie, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnNewMovie.text"));
        this.btnNewMovie.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnNewMovie.toolTipText"));
        this.btnNewMovie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnNewMovieActionPerformed(evt);
            }
        });
        this.btnCreateIntro.setIcon(new ImageIcon(this.getClass().getResource("/icons/greenbookmark.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateIntro, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnCreateIntro.text"));
        this.btnCreateIntro.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnCreateIntro.toolTipText"));
        this.btnCreateIntro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnCreateIntroActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbOrderBy, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbOrderBy.text"));
        this.comboMovieTypeFilter.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.comboMovieTypeFilter.toolTipText"));
        this.comboMovieTypeFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.comboMovieTypeFilterActionPerformed(evt);
            }
        });
        this.comboOrderByMovie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.comboOrderByMovieActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbSearch, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbSearch.text"));
        this.tfSearch.setText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.tfSearch.text"));
        this.tfSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MovieListTopComponent.this.tfSearchKeyReleased(evt);
            }
        });
        this.btnToggleMore.setIcon(new ImageIcon(this.getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnToggleMore, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnToggleMore.text"));
        this.btnToggleMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnToggleMoreActionPerformed(evt);
            }
        });
        this.comboShowHideFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.comboShowHideFilterActionPerformed(evt);
            }
        });
        this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_ascending.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnAsc, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.toggleBtnAsc.text"));
        this.toggleBtnAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.toggleBtnAscActionPerformed(evt);
            }
        });
        this.cbShowPosition.setLabel(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowPosition.label"));
        this.cbShowPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowPositionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowRating, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowRating.text"));
        this.cbShowRating.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowRatingActionPerformed(evt);
            }
        });
        this.cbShowRuntime.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowRuntime, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowRuntime.text"));
        this.cbShowRuntime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowRuntimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowCounter, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowCounter.text"));
        this.cbShowCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowCounterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowLikeCounter, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowLikeCounter.text"));
        this.cbShowLikeCounter.setActionCommand(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowLikeCounter.actionCommand"));
        this.cbShowLikeCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowLikeCounterActionPerformed(evt);
            }
        });
        this.btnApplyDateFilter.setIcon(new ImageIcon(this.getClass().getResource("/icons/Apply.png")));
        this.btnApplyDateFilter.setLabel(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnApplyDateFilter.label"));
        this.btnApplyDateFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnApplyDateFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbApplyDateFilterFrom, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbApplyDateFilterFrom.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbApplyDateFilterTill, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbApplyDateFilterTill.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowYear, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowYear.text"));
        this.cbShowYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowYearActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowResolution, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowResolution.text"));
        this.cbShowResolution.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowResolutionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbPrefixMetaData, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbPrefixMetaData.text"));
        this.cbPrefixMetaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbPrefixMetaDataActionPerformed(evt);
            }
        });
        GroupLayout panelShowMoreLayout = new GroupLayout(this.panelShowMore);
        this.panelShowMore.setLayout(panelShowMoreLayout);
        panelShowMoreLayout.setHorizontalGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowMoreLayout.createSequentialGroup().addContainerGap().addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowMoreLayout.createSequentialGroup().addComponent(this.cbShowPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowYear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowResolution).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPrefixMetaData).addGap(0, 0, Short.MAX_VALUE)).addGroup(panelShowMoreLayout.createSequentialGroup().addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowMoreLayout.createSequentialGroup().addComponent(this.cbShowCounter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowLikeCounter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowRuntime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowRating).addGap(0, 0, Short.MAX_VALUE)).addGroup(panelShowMoreLayout.createSequentialGroup().addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbApplyDateFilterFrom).addComponent(this.lbApplyDateFilterTill)).addGap(18, 18, 18).addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.datePickerTill, -2, -1, -2).addComponent((Component)this.datePickerFrom, -2, -1, -2)).addGap(18, 18, 18).addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboDateFilter, 0, -1, Short.MAX_VALUE).addComponent(this.btnApplyDateFilter, -1, -1, Short.MAX_VALUE)).addGap(9, 9, 9))).addGap(70, 70, 70))).addContainerGap()));
        panelShowMoreLayout.setVerticalGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowMoreLayout.createSequentialGroup().addContainerGap().addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowCounter).addComponent(this.cbShowLikeCounter).addComponent(this.cbShowRuntime).addComponent(this.cbShowRating)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowYear).addComponent(this.cbShowResolution).addComponent(this.cbPrefixMetaData).addComponent(this.cbShowPosition)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbApplyDateFilterFrom).addComponent((Component)this.datePickerFrom, -2, -1, -2).addComponent(this.comboDateFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelShowMoreLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbApplyDateFilterTill).addComponent((Component)this.datePickerTill, -2, -1, -2).addComponent(this.btnApplyDateFilter)).addGap(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.lbFilter, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbFilter.text"));
        this.jSeparator2.setOrientation(1);
        this.tfLimit.setText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.tfLimit.text"));
        this.tfLimit.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.tfLimit.toolTipText"));
        this.tfLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.tfLimitActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowTooltips, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowTooltips.text"));
        this.cbShowTooltips.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbShowTooltips.toolTipText"));
        this.cbShowTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbShowTooltipsActionPerformed(evt);
            }
        });
        GroupLayout panelLowerPartLayout = new GroupLayout(this.panelLowerPart);
        this.panelLowerPart.setLayout(panelLowerPartLayout);
        panelLowerPartLayout.setHorizontalGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addComponent(this.btnToggleMore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleBtnAsc)).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tfLimit, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, panelLowerPartLayout.createSequentialGroup().addContainerGap().addComponent(this.cbShowTooltips)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addGap(0, 0, 0).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbSearch).addComponent(this.jLabel3).addComponent(this.lbFilter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addComponent(this.comboMovieTypeFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbOrderBy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboOrderByMovie, -2, -1, -2)).addComponent(this.comboShowHideFilter, -2, -1, -2).addComponent(this.tfSearch, -2, 395, -2))).addComponent(this.panelShowMore, -2, -1, -2))));
        panelLowerPartLayout.setVerticalGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lbSearch)).addComponent(this.cbShowTooltips, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createSequentialGroup().addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboShowHideFilter, -2, -1, -2).addComponent(this.lbFilter)).addComponent(this.toggleBtnAsc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelLowerPartLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboMovieTypeFilter, -2, -1, -2).addComponent(this.lbOrderBy).addComponent(this.comboOrderByMovie, -2, -1, -2).addComponent(this.tfLimit, -2, -1, -2))).addComponent(this.btnToggleMore)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelShowMore, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator2)).addContainerGap()));
        this.beanTreeViewAll.setVerticalScrollBarPolicy(22);
        this.btnSelectRandomNode.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/dice.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectRandomNode, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnSelectRandomNode.text"));
        this.btnSelectRandomNode.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnSelectRandomNode.toolTipText"));
        this.btnSelectRandomNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnSelectRandomNodeActionPerformed(evt);
            }
        });
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnOpen.text"));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnOpenActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbFullscreen, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbFullscreen.text"));
        this.cbFullscreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbFullscreenActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbLoop, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.cbLoop.text"));
        this.cbLoop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.cbLoopActionPerformed(evt);
            }
        });
        this.btnOpenRandom.setIcon(new ImageIcon(this.getClass().getResource("/icons.silkcompanion/rainbow_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenRandom, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnOpenRandom.text"));
        this.btnOpenRandom.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnOpenRandom.toolTipText"));
        this.btnOpenRandom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnOpenRandomActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbStatus, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.lbStatus.text"));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnReload.text"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        this.btnReload1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload1, (String)NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnReload1.text"));
        this.btnReload1.setToolTipText(NbBundle.getMessage(MovieListTopComponent.class, (String)"MovieListTopComponent.btnReload1.toolTipText"));
        this.btnReload1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieListTopComponent.this.btnReload1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.beanTreeViewAll, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lbStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnReload1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectRandomNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenRandom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNewMovie).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreateIntro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFullscreen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLoop))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.panelLowerPart, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpen).addComponent(this.cbFullscreen).addComponent(this.cbLoop)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNewMovie).addComponent(this.btnCreateIntro).addComponent(this.btnOpenRandom))).addComponent(this.btnSelectRandomNode).addComponent(this.btnReload1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbStatus).addComponent(this.btnReload)).addComponent((Component)this.beanTreeViewAll, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelLowerPart, -1, -1, -2).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jScrollPane1).addContainerGap()));
    }

    private void cbShowRatingActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void tfSearchKeyReleased(KeyEvent evt) {
        SequencedCollection searchQueries = this.db.getEntityService().find((EntityPathBase)QSearchQuery.searchQuery1).filter(f -> f.tab.eq((Object)Tab.Movies)).filter(f -> f.searchQuery.containsIgnoreCase(this.tfSearch.getText())).order(new Function[]{f -> f.dateOfCreation.asc()}).find(20L);
        LOG.info("previous search queries found: " + searchQueries.size());
        for (SearchQuery sq : searchQueries) {
            LOG.info("sq.getSearchQuery(): " + sq.getSearchQuery() + " " + String.valueOf(sq.getDateOfCreation()) + " " + String.valueOf(sq.getDateOfLastModification()));
        }
        searchQueries = searchQueries.reversed();
        LOG.info("----------");
        for (SearchQuery sq : searchQueries) {
            LOG.info("sq.getSearchQuery(): " + sq.getSearchQuery() + " " + String.valueOf(sq.getDateOfCreation()) + " " + String.valueOf(sq.getDateOfLastModification()));
        }
        LOG.info("!!!!!!!!!!!!!!11");
        for (SearchQuery sq : this.autocompleter.getChoices()) {
            LOG.info("sq.getSearchQuery(): " + sq.getSearchQuery() + " " + String.valueOf(sq.getDateOfCreation()) + " " + String.valueOf(sq.getDateOfLastModification()));
        }
        this.autocompleter.getChoices().clear();
        this.autocompleter.getChoices().addAll(searchQueries.reversed());
        LOG.info("xxxxxxxxxx11");
        for (SearchQuery sq : this.autocompleter.getChoices().reversed()) {
            LOG.info("sq.getSearchQuery(): " + sq.getSearchQuery() + " " + String.valueOf(sq.getDateOfCreation()) + " " + String.valueOf(sq.getDateOfLastModification()));
        }
        if (this.db.getScenerixxSettings().isSearchOnKeyPress() || evt.getKeyCode() == 10) {
            if (evt.getKeyCode() == 37 || evt.getKeyCode() == 39 || evt.getKeyCode() == 34 || evt.getKeyCode() == 33 || evt.getKeyCode() == 32) {
                LOG.finest("Cursor key or space pressed, skip search");
            } else {
                new UpdateSearchResultListWorker().execute();
            }
        }
    }

    private void btnCreateIntroActionPerformed(ActionEvent evt) {
        this.createIntro();
    }

    private void btnNewMovieActionPerformed(ActionEvent evt) {
        this.createMovie();
    }

    private void cbShowRuntimeActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowLikeCounterActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowCounterActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.openVlc();
    }

    private void btnSelectRandomNodeActionPerformed(ActionEvent evt) {
        this.selectRandomNode(0);
    }

    private void cbShowPositionActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void toggleIcons() {
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        if (this.cbShowLikeCounter.isSelected()) {
            this.cbShowLikeCounter.setIcon(new ImageIcon(this.getClass().getResource("/icons2/Heart.png")));
        } else {
            this.cbShowLikeCounter.setIcon(null);
        }
        if (this.cbShowCounter.isSelected()) {
            this.cbShowCounter.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/counter.png")));
        } else {
            this.cbShowCounter.setIcon(null);
        }
        if (this.cbShowRating.isSelected()) {
            this.cbShowRating.setIcon(new ImageIcon(this.getClass().getResource("/icons/favourites.png")));
        } else {
            this.cbShowRating.setIcon(null);
        }
        if (this.cbShowRuntime.isSelected()) {
            this.cbShowRuntime.setIcon(new ImageIcon(this.getClass().getResource("/icons/Stopwatch.png")));
        } else {
            this.cbShowRuntime.setIcon(null);
        }
        if (this.cbShowYear.isSelected()) {
            this.cbShowYear.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/calendar_view_day.png")));
        } else {
            this.cbShowYear.setIcon(null);
        }
        if (this.cbShowResolution.isSelected()) {
            this.cbShowResolution.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/arrow_out.png")));
        } else {
            this.cbShowResolution.setIcon(null);
        }
        if (this.cbPrefixMetaData.isSelected()) {
            this.cbPrefixMetaData.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/text_indent_remove.png")));
        } else {
            this.cbPrefixMetaData.setIcon(null);
        }
    }

    private void comboMovieTypeFilterActionPerformed(ActionEvent evt) {
        if (!this.showPlaylist) {
            this.reloadList();
        }
    }

    private void setRootContextAndDisplayName(List<Movie> movies, String movieType) {
        LOG.info("___Setting root context for " + movieType + " - " + movies.size());
        if (this.movieChildFactory != null) {
            ArrayList<Movie> tmpList = new ArrayList<Movie>();
            tmpList.addAll(movies);
            LOG.info("movie child factory had " + tmpList.size() + " movies");
            int cnt = this.setRootContext(tmpList);
            if (this.cbShowRuntime.isSelected()) {
                this.setRootDisplayName(movieType, ScenerixxCommon.calculateRuntime(tmpList), cnt);
            } else {
                this.setRootDisplayName(movieType, null, cnt);
            }
        } else {
            LOG.info("movie child factory is not available yet");
            int cnt = this.setRootContext(movies);
            if (this.cbShowRuntime.isSelected()) {
                this.setRootDisplayName(movieType, ScenerixxCommon.calculateRuntime(movies), cnt);
            } else {
                this.setRootDisplayName(movieType, null, cnt);
            }
        }
    }

    private void toggleDateFilter(boolean show) {
        this.lbApplyDateFilterFrom.setVisible(show);
        this.lbApplyDateFilterTill.setVisible(show);
        this.btnApplyDateFilter.setVisible(show);
        this.datePickerFrom.setVisible(show);
        this.datePickerTill.setVisible(show);
        this.comboDateFilter.setVisible(show);
    }

    private void comboOrderByMovieActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void btnToggleMoreActionPerformed(ActionEvent evt) {
        this.toggleShowMore();
    }

    private void comboShowHideFilterActionPerformed(ActionEvent evt) {
        this.updateShowHideFlags();
        if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowAllMovies || this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlyFavorites || this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlySecrets) {
            this.toggleDateFilter(true);
        } else {
            this.toggleDateFilter(false);
        }
        if (!this.doNotAskForPlaylist && this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowPlaylist) {
            final PlaylistSelectionPanel panel = new PlaylistSelectionPanel();
            JOptionPane op = new JOptionPane(panel, 3, 2){

                @Override
                public void selectInitialValue() {
                    panel.getComboPlaylist();
                }
            };
            JDialog dlg = op.createDialog("Select a playlist");
            dlg.setVisible(true);
            dlg.addWindowFocusListener(new WindowAdapter(this){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    panel.gainedFocus();
                }
            });
            if (op.getValue() != null && op.getValue().equals(0)) {
                this.playlistToShow = panel.getPlaylist();
                this.showPlaylist(this.playlistToShow);
            } else {
                this.playlistToShow = null;
            }
            this.comboMovieTypeFilter.setSelectedItem(MovieTypeFilter.All);
            this.comboMovieTypeFilter.setEnabled(false);
        } else {
            SwingUtilities.invokeLater(() -> {
                LOG.info("show/hide filter... favorites: " + this.showOnlyFavorites);
                this.reloadList();
                LOG.info("show/hide filter... list reloaded. favorites: " + this.showOnlyFavorites);
            });
        }
    }

    public void openPlaylist(Playlist playlist) {
        LOG.info("opening external playlist: " + playlist.getEntries(Scenerixx.unlocked).size());
        this.playlistToShow = playlist;
        this.doNotAskForPlaylist = true;
        this.comboShowHideFilter.setSelectedItem(ShowHideMovieFilter.ShowPlaylist);
        this.doNotAskForPlaylist = false;
        if (!this.tfSearch.getText().isBlank()) {
            SwingUtilities.invokeLater(() -> MovieListTopComponent.notifyWarning("Attention! The result is filtered by: " + this.tfSearch.getText()));
        }
    }

    public void showPlaylist(Playlist playlist) {
        List<Movie> playables = this.getMoviesFromPlaylist(playlist);
        int cnt = this.setRootContext(playables);
        this.setRootDisplayName(playlist.getName(), ScenerixxCommon.calculateRuntime(playables), cnt);
    }

    public List<Movie> getMoviesFromPlaylist(Playlist playlist) {
        ArrayList<Movie> playables = new ArrayList<Movie>();
        for (IPlayablePlaylistItems p : playlist.getPlayables(Scenerixx.unlocked)) {
            if (p instanceof IPlayable && (p instanceof Movie || p instanceof Scene || p instanceof Bookmark)) {
                playables.add(((IPlayable)p).getMovieAssociated());
                continue;
            }
            LOG.info("cannot add " + String.valueOf(p) + " - probably it's a medium file");
        }
        LOG.info("there are " + playables.size() + " movies on the playlist " + playlist.toString());
        return playables;
    }

    private void toggleBtnAscActionPerformed(ActionEvent evt) {
        this.toggleAsc();
    }

    private void btnOpenRandomActionPerformed(ActionEvent evt) {
        this.openRandomMovie();
    }

    public void markAsFavorite() {
        this.toggleFavorite(true);
    }

    public void unmarkAsFavorite() {
        this.toggleFavorite(false);
    }

    public void toggleFavorite(boolean favorite) {
        this.scenerixxCommon.markAsFavorite(em.getSelectedNodes(), favorite);
    }

    public void openRandomMovie() {
        ArrayList scenes = new ArrayList();
        for (Node n : em.getRootContext().getChildren().getNodes()) {
            Object object;
            if (n.getValue("movie") == null || !((object = n.getValue("movie")) instanceof Movie)) continue;
            Movie movie = (Movie)object;
            scenes.addAll(movie.getScenes());
        }
        Collections.shuffle(scenes);
        Playlist playlist = new Playlist();
        int end = scenes.size();
        if (this.db.getScenerixxSettings().getRandomPlaylistEntries() != null && this.db.getScenerixxSettings().getRandomPlaylistEntries() > 0) {
            end = this.db.getScenerixxSettings().getRandomPlaylistEntries();
            if (scenes.size() < end) {
                LOG.finer("not enough scenes for random opening. use the ones we have");
                end = scenes.size();
            }
        }
        LOG.info("Consider " + end + " entries for random open");
        for (int i = 0; i < end; ++i) {
            PlaylistEntry pe = new PlaylistEntry();
            pe.setScene((Scene)scenes.get(i));
            playlist.getEntries(Scenerixx.unlocked).add(pe);
        }
        this.openVlc(playlist, true);
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void btnApplyDateFilterActionPerformed(ActionEvent evt) {
        if (!(ShowHideMovieFilter.ShowAllMovies.equals(this.comboShowHideFilter.getSelectedItem()) || ShowHideMovieFilter.ShowOnlyFavorites.equals(this.comboShowHideFilter.getSelectedItem()) || ShowHideMovieFilter.ShowOnlySecrets.equals(this.comboShowHideFilter.getSelectedItem()))) {
            MovieListTopComponent.notifyWarning("You can only filter by date if 'all movies', 'secrets' or 'favorites' are shown!");
        } else if (DateFilter.DoNot.equals(this.comboDateFilter.getSelectedItem())) {
            MovieListTopComponent.notifyWarning("You need to specify by what kind of data you want to order.");
        } else {
            this.reloadList();
        }
    }

    private void cbFullscreenActionPerformed(ActionEvent evt) {
        this.toggleFullscreen();
    }

    private void cbLoopActionPerformed(ActionEvent evt) {
        this.toggleLoopIcon();
    }

    private void cbShowYearActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowResolutionActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbPrefixMetaDataActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void tfLimitActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void cbShowTooltipsActionPerformed(ActionEvent evt) {
        this.toggleTooltipIcon();
    }

    private void btnReload1ActionPerformed(ActionEvent evt) {
        this.reloadListAndRefocus();
    }

    private void toggleTooltipIcon() {
        if (this.cbShowTooltips.isSelected()) {
            this.cbShowTooltips.setIcon(new ImageIcon(this.getClass().getResource("/icons.fugue/ui-tooltip-balloon-bottom.png")));
        } else {
            this.cbShowTooltips.setIcon(null);
        }
    }

    private void toggleLoopIcon() {
        if (this.cbLoop.isSelected()) {
            this.cbLoop.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/arrow_repeat.png")));
        } else {
            this.cbLoop.setIcon(null);
        }
    }

    private void toggleFullscreen() {
        if (this.cbFullscreen.isSelected()) {
            this.cbFullscreen.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/television.png")));
        } else {
            this.cbFullscreen.setIcon(null);
        }
    }

    private void toggleAsc() {
        boolean bl = this.asc = !this.asc;
        if (this.asc) {
            this.toggleBtnAsc.setToolTipText("sort ascending");
            this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_ascending.png")));
        } else {
            this.toggleBtnAsc.setToolTipText("sort descending");
            this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_descending.png")));
        }
        this.reloadList();
    }

    private void toggleShowMore() {
        this.panelShowMore.setVisible(this.btnToggleMore.isSelected());
        if (this.btnToggleMore.isSelected()) {
            this.btnToggleMore.setToolTipText("Show less");
            this.btnToggleMore.setIcon(new ImageIcon(this.getClass().getResource("/icons/Remove.png")));
            this.comboShowHideFilter.setModel(new DefaultComboBoxModel<ShowHideMovieFilter>(ShowHideMovieFilter.values()));
        } else {
            this.btnToggleMore.setToolTipText("Show more...");
            this.btnToggleMore.setIcon(new ImageIcon(this.getClass().getResource("/icons/Add.gif")));
            ShowHideMovieFilter[] values = new ShowHideMovieFilter[]{ShowHideMovieFilter.ShowAllMovies, ShowHideMovieFilter.ShowOnlyFavorites, ShowHideMovieFilter.ShowOnlySecrets, ShowHideMovieFilter.ShowOnlyRegrettablyAwesome, ShowHideMovieFilter.ShowPlaylist, ShowHideMovieFilter.ShowLastCame, ShowHideMovieFilter.ShowMoviesThatAreGeneratedByWizard, ShowHideMovieFilter.ShowMoviesWithMissingStudio, ShowHideMovieFilter.HideMoviesWhereAllScenesAssociatedToPersons, ShowHideMovieFilter.HideMoviesWhereAllScenesLengthSet};
            this.comboShowHideFilter.setModel(new DefaultComboBoxModel<ShowHideMovieFilter>(values));
        }
    }

    private void updateShowHideFlags() {
        LOG.info("UPDATESHOWHIDEFILTER: " + String.valueOf(this.comboShowHideFilter.getSelectedItem()));
        this.showMoviesWithScenesSet = false;
        this.hideMoviesWithScenesSet = false;
        this.showMoviesWithScreencaps = false;
        this.hideMoviesWithScreencaps = false;
        this.showMoviesWithScenerixxFiles = false;
        this.hideMoviesWithScenerixxFiles = false;
        this.showPersonCompleteMovies = false;
        this.hidePersonCompleteMovies = false;
        this.showSceneLengthsSetMovies = false;
        this.hideSceneLengthsSetMovies = false;
        this.showWizard = false;
        this.hideWizard = false;
        this.showPlaylist = false;
        this.showMoviesWithMissingMediumFile = false;
        this.showMoviesWithSeveralMediumFile = false;
        this.showMoviesWithMissingStudios = false;
        this.showOnlyFavorites = false;
        this.showOnlySecret = false;
        this.showLastCame = false;
        this.showOnlyRegrettablyAwesome = false;
        this.showAllMovies = false;
        if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesThatAreGeneratedByWizard) {
            this.hideWizard = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereAllScenesAssociatedToPersons) {
            this.hidePersonCompleteMovies = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereAllScenesLengthSet) {
            this.hideSceneLengthsSetMovies = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScreencapExists) {
            this.hideMoviesWithScreencaps = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScenerixxFileExists) {
            this.hideMoviesWithScenerixxFiles = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.HideMoviesWhereScenesAreAssociated) {
            this.hideMoviesWithScenesSet = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesThatAreGeneratedByWizard) {
            this.showWizard = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereAllScenesAssociatedToPersons) {
            this.showPersonCompleteMovies = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereAllScenesLengthSet) {
            this.showSceneLengthsSetMovies = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScreencapExists) {
            this.showMoviesWithScreencaps = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScenerixxFileExists) {
            this.showMoviesWithScenerixxFiles = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWhereScenesAreAssociated) {
            this.showMoviesWithScenesSet = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowPlaylist) {
            this.showPlaylist = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithMissingMediumFile) {
            this.showMoviesWithMissingMediumFile = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithSeveralMediumFile) {
            this.showMoviesWithSeveralMediumFile = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowMoviesWithMissingStudio) {
            this.showMoviesWithMissingStudios = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlyFavorites) {
            this.showOnlyFavorites = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlySecrets) {
            this.showOnlySecret = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowOnlyRegrettablyAwesome) {
            this.showOnlyRegrettablyAwesome = true;
        } else if (this.comboShowHideFilter.getSelectedItem() == ShowHideMovieFilter.ShowLastCame) {
            this.showLastCame = true;
        } else {
            this.tfLimit.setVisible(true);
            this.showAllMovies = true;
        }
    }

    private Node selectRandomNode(int counter) {
        LOG.info("current try to select random node: " + counter);
        if (counter > 99) {
            AbstractTopComponent.notifyWarning("Could not determine a random node. Gave up after 100 tries.");
            return null;
        }
        if (em.getRootContext().getChildren().getNodesCount() <= 0) {
            return null;
        }
        Node selectedNode = null;
        Random rnd = new Random();
        int nextInt = rnd.nextInt(em.getRootContext().getChildren().getNodesCount());
        Node child = em.getRootContext().getChildren().getNodeAt(nextInt);
        if (child != null) {
            try {
                em.setSelectedNodes(new Node[]{child});
                this.beanTreeViewAll.expandNode(child);
                if (child.getChildren() != null && child.getChildren().getNodesCount() > 1) {
                    LOG.info("children count: " + child.getChildren().getNodesCount());
                    for (Node n : child.getChildren().getNodes()) {
                        LOG.info(n.getHtmlDisplayName());
                    }
                    try {
                        int index = rnd.nextInt(child.getChildren().getNodesCount() - 1);
                        selectedNode = child.getChildren().getNodeAt(index);
                        em.setSelectedNodes(new Node[]{selectedNode});
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.severe(iae.getMessage() + " - nodesCount: " + child.getChildren().getNodesCount());
                    }
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return selectedNode;
    }

    public Scene getSelectedScene() {
        Object object;
        if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("scene") != null && (object = em.getSelectedNodes()[0].getValue("scene")) instanceof Scene) {
            Scene scene = (Scene)object;
            return scene;
        }
        return null;
    }

    public Movie getSelectedMovie() {
        Object object;
        if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("movie") != null && (object = em.getSelectedNodes()[0].getValue("movie")) instanceof Movie) {
            Movie movie = (Movie)object;
            return movie;
        }
        return null;
    }

    public Movie getSelectedSingleSceneMovie() {
        Movie mov;
        Object object;
        if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("movie") != null && (object = em.getSelectedNodes()[0].getValue("movie")) instanceof Movie && (mov = (Movie)object).getScenes().size() == 1) {
            return mov;
        }
        return null;
    }

    public Node getSelectedNode() {
        if (em.getSelectedNodes().length > 0) {
            return em.getSelectedNodes()[0];
        }
        return null;
    }

    private void search() {
        if (this.tfSearch.getText().startsWith("#")) {
            int indexId = 1;
            if (this.tfSearch.getText().startsWith("##")) {
                indexId = 2;
            }
            if (this.tfSearch.getText().startsWith("###")) {
                indexId = 3;
            }
            LOG.info("indexId # " + indexId);
            try {
                int parseInt = Integer.parseInt(this.tfSearch.getText().substring(indexId, this.tfSearch.getText().length()));
                LOG.info("parseInt: " + parseInt);
                switch (indexId) {
                    case 1: {
                        Movie filterMov = (Movie)this.db.getEntityService().find((EntityPathBase)QMovie.movie).filter(f -> f.id.eq((Object)Integer.toUnsignedLong(parseInt))).findFirst();
                        this.reloadDetails(filterMov);
                        ArrayList<Movie> arrayList = new ArrayList<Movie>();
                        arrayList.add(filterMov);
                        this.setRootContext(arrayList);
                        this.selectMovieNode(filterMov);
                        break;
                    }
                    case 2: {
                        Scene filterScene = (Scene)this.db.getEntityService().find((EntityPathBase)QScene.scene).filter(f -> f.id.eq((Object)Integer.toUnsignedLong(parseInt))).findFirst();
                        this.reloadDetails(filterScene);
                        ArrayList<Movie> arrayListMovie = new ArrayList<Movie>();
                        arrayListMovie.add(filterScene.getMovieAssociated());
                        this.setRootContext(arrayListMovie);
                        this.selectSceneNode(filterScene);
                        break;
                    }
                    case 3: {
                        Bookmark filterBookmark = (Bookmark)this.db.getEntityService().find((EntityPathBase)QBookmark.bookmark).filter(f -> f.id.eq((Object)Integer.toUnsignedLong(parseInt))).findFirst();
                        this.reloadDetails(filterBookmark);
                        ArrayList<Movie> arrayListBookmark = new ArrayList<Movie>();
                        arrayListBookmark.add(filterBookmark.getMovieAssociated());
                        this.setRootContext(arrayListBookmark);
                        this.selectBookmarkNode(filterBookmark);
                    }
                }
                return;
            }
            catch (NumberFormatException nfw) {
                nfw.printStackTrace();
            }
        }
        List movieList = null;
        String caption = null;
        if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Snippets) {
            movieList = this.db.getSnippets(this.getOrderBy(), Scenerixx.unlocked);
            caption = "Snippets";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.ThreeD) {
            movieList = this.db.get3D(this.getOrderBy(), Scenerixx.unlocked);
            caption = "3D";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.VR) {
            movieList = this.db.getVR(this.getOrderBy(), Scenerixx.unlocked);
            caption = "VR";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Interactive) {
            movieList = this.db.getInteractive(this.getOrderBy(), Scenerixx.unlocked);
            caption = "Interactive";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Movies) {
            movieList = this.db.getCompleteMovies(this.getOrderBy(), Scenerixx.unlocked);
            caption = "Movies";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Scenes) {
            movieList = this.db.getSingleScenes(this.getOrderBy(), Scenerixx.unlocked);
            caption = "Single Scenes";
        } else if ((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem() == MovieTypeFilter.Dvd) {
            movieList = this.db.getDvds(this.getOrderBy(), Scenerixx.unlocked);
            caption = "DVDs";
        }
        if (movieList != null) {
            ArrayList tmpList = new ArrayList(movieList);
            for (Movie d : tmpList) {
                if (this.db.containsAllSearchTerms(this.tfSearch.getText(), d)) continue;
                movieList.remove(d);
            }
            this.setRootContextAndDisplayName(movieList, caption);
        } else if (movieList == null) {
            LOG.info("SEARCH DEFAULT BRANCH!!!!!!!!!!!!!!!!!!!!!!!11");
            this.reloadList();
            if (this.db.getScenerixxSettings().isSearchOnKeyPress()) {
                this.tfSearch.requestFocus();
            }
        }
        LOG.info("caption " + caption + " for " + String.valueOf((MovieTypeFilter)this.comboMovieTypeFilter.getSelectedItem()));
    }

    private void createIntro() {
        Object object;
        if (em.getSelectedNodes().length > 0 && em.getSelectedNodes()[0].getValue("movie") != null && (object = em.getSelectedNodes()[0].getValue("movie")) instanceof Movie) {
            Movie m = (Movie)object;
            boolean introExists = false;
            int newPos = -1;
            for (Bookmark tmpB : m.getBookmarks(Scenerixx.unlocked)) {
                if (!BookmarkType.INTRO.equals((Object)tmpB.getType())) continue;
                introExists = true;
                if (newPos >= tmpB.getPosition()) break;
                newPos = tmpB.getPosition();
                break;
            }
            if (introExists) {
                AbstractTopComponent.notifyError("An Intro bookmark already exists.");
            } else {
                Bookmark b = new Bookmark();
                b.setType(BookmarkType.INTRO);
                b.setDateOfCreation(LocalDateTime.now());
                b.setPosition(newPos + 1);
                b.setMovie(m);
                List mediumFiles = this.db.getMediumFiles(m, Scenerixx.unlocked);
                if (!mediumFiles.isEmpty()) {
                    b.setMedium((Medium)mediumFiles.get(0));
                    b.setEndMedium((Medium)mediumFiles.get(0));
                    b.setEndTime(1);
                }
                m.getBookmarks(true).add(b);
                m = (Movie)this.db.getEntityService().save((AbstractEntity)m);
                em.getSelectedNodes()[0].setValue("movie", (Object)m);
                for (Bookmark tmpB : m.getBookmarks(Scenerixx.unlocked)) {
                    if (!BookmarkType.INTRO.equals((Object)tmpB.getType())) continue;
                    b = tmpB;
                    break;
                }
                LOG.info("ID of created intro bookmark: " + b.getId());
                Bookmark tmpBookmark = b;
                SwingUtilities.invokeLater(() -> {
                    this.refresh();
                    this.reloadList();
                    SwingUtilities.invokeLater(() -> this.selectBookmarkNode(tmpBookmark));
                });
                DetailsTopComponent detailTopComponent = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTopComponent != null) {
                    detailTopComponent.loadBookmark(b);
                    detailTopComponent.requestActive();
                    detailTopComponent.focusStartSecondTextField();
                }
            }
        } else {
            AbstractTopComponent.notifyError("Intro bookmark can only be created if a movie is selected.");
        }
    }

    public void createMovie() throws HeadlessException {
        Movie m = new Movie();
        m.setTitle("[New Movie]");
        m = (Movie)this.db.getEntityService().save((AbstractEntity)m);
        this.scenerixxCommon.askHowManyScenesShouldBeCreated(m, false);
        this.updateShowHideFlags();
        AbstractNode abstractNode = new AbstractNode(Children.create((ChildFactory)new MovieChildFactory(new ArrayList(), this.showMoviesWithScenesSet, this.hideMoviesWithScenesSet, this.showMoviesWithScenerixxFiles, this.hideMoviesWithScenerixxFiles, this.cbShowCounter.isSelected(), this.showPersonCompleteMovies, this.hidePersonCompleteMovies, this.showSceneLengthsSetMovies, this.hideSceneLengthsSetMovies, this.showWizard, this.hideWizard, this.cbShowLikeCounter.isSelected(), this.cbShowRuntime.isSelected(), this.cbShowRating.isSelected(), this.cbShowPosition.isSelected(), this.showOnlyFavorites, this.showOnlySecret, this.cbShowYear.isSelected(), this.cbShowResolution.isSelected(), this.cbPrefixMetaData.isSelected(), false, this.showMoviesWithScreencaps, this.hideMoviesWithScreencaps){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                MovieListTopComponent.this.reloadList(node);
            }
        }, (boolean)false));
        abstractNode.setName("" + m.getId());
        this.reloadList((Node)abstractNode);
        TopComponent detailsList = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
        if (detailsList != null) {
            ((DetailsTopComponent)detailsList).resetForm();
            ((DetailsTopComponent)detailsList).loadMovie(m);
        }
    }

    public void openVlc() {
        if (em.getSelectedNodes().length == 1) {
            if (em.getSelectedNodes()[0].getParentNode() == null) {
                Playlist tmpPlaylist = new Playlist();
                for (Node n : em.getRootContext().getChildren().getNodes()) {
                    if (n.getValue("movie") == null) continue;
                    PlaylistEntry pe = new PlaylistEntry();
                    pe.setMovie((Movie)n.getValue("movie"));
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                }
                this.openVlc(tmpPlaylist, true);
            } else {
                LOG.info("Starting mediums for " + em.getSelectedNodes()[0].getDisplayName());
                this.openVlc(em.getSelectedNodes()[0].getDisplayName(), (Movie)em.getSelectedNodes()[0].getValue("movie"), (Scene)em.getSelectedNodes()[0].getValue("scene"), (Bookmark)em.getSelectedNodes()[0].getValue("bookmark"), null, this.cbLoop.isSelected());
            }
        } else if (em.getSelectedNodes().length > 1) {
            this.openSelectedPlayableItems();
        }
    }

    private void openSelectedPlayableItems() {
        if (em.getSelectedNodes().length >= 1) {
            Playlist tmpPlaylist = new Playlist();
            for (Node n : em.getSelectedNodes()) {
                Bookmark bookmark = (Bookmark)n.getValue("bookmark");
                Scene scene = (Scene)n.getValue("scene");
                Movie movie = (Movie)n.getValue("movie");
                PlaylistEntry pe = new PlaylistEntry();
                if (bookmark != null) {
                    pe.setBookmark(bookmark);
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (movie != null) {
                    pe.setMovie(movie);
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (scene == null) continue;
                pe.setScene(scene);
                tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
            }
            this.openVlc(tmpPlaylist, true);
        }
    }

    private void openVlc(Playlist playlist, boolean temporary) {
        this.openVlc(playlist, temporary, false);
    }

    public void openVlc(Playlist playlist, boolean temporary, boolean randomized) {
        LOG.fine("Open playlist " + playlist.getCodename() + " Temp: " + temporary);
        if (!this.checkIfAllMediumFilesAreOnline(playlist)) {
            if (playlist.getEntries(Scenerixx.unlocked).size() == 1) {
                return;
            }
            String msg = "At least one medium file was not availabe\nShould we start the playlist anyway?";
            if (1 == JOptionPane.showConfirmDialog(null, msg, "Start anyway?", 0)) {
                return;
            }
        }
        Statistic statistic = new Statistic();
        ArrayList<String> paras = new ArrayList<String>();
        paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
        List entries = playlist.getEntries(Scenerixx.unlocked);
        if (randomized) {
            LOG.fine("Play playlist '" + playlist.getName() + "' randomized");
            Collections.shuffle(entries);
        }
        try {
            if (playlist.getName() == null) {
                playlist.setName("tmp_playlist_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()));
            }
            String exportPlaylistToXspf = new XspfExporter().exportPlaylistToXspf(playlist, System.getProperty("java.io.tmpdir"), Scenerixx.unlocked);
            paras.add(exportPlaylistToXspf);
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | DOMException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!temporary) {
            statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.playlist.eq((Object)playlist)).findFirst();
            if (statistic == null) {
                statistic = new Statistic();
                statistic = (Statistic)this.db.getEntityService().save((AbstractEntity)statistic);
            }
            statistic.setPlaylist(playlist);
        }
        if (paras.size() == 1) {
            JOptionPane.showMessageDialog(null, "No medium file was associated to any of the selected items. Cannot play anything.", "Error", 0);
        } else {
            if (this.cbFullscreen.isSelected()) {
                paras.add("-f");
            }
            paras.add("-L");
            LOG.fine("VLC paras: " + paras.stream().map(x -> x).collect(Collectors.joining(" ")));
            try {
                ProcessBuilder builder = new ProcessBuilder(paras);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                InputStream itsOutput = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(itsOutput));
                Thread t = new Thread(() -> {
                    while (process.isAlive()) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                LOG.finest("VLC Stdout: " + line);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                t.start();
                if (!temporary) {
                    statistic.getStarted().add(LocalDateTime.now());
                    this.db.getEntityService().save((AbstractEntity)statistic);
                }
            }
            catch (IOException ex) {
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
    }

    private void addSceneToVlcParas(Scene scene, List<String> paras) {
        MediumFile medium = (MediumFile)scene.getStartMedium();
        if (medium != null) {
            paras.add(medium.getFileCompletePath());
            paras.add(":start-time=" + new ScenerixxCommonLib().getStarttimeForSceneUsingSmartStart(scene, scene.getStartTime(), Scenerixx.unlocked));
            LOG.fine("Check for ignore bookmarks in scene");
            List bookmarks = scene.getBookmarks(Scenerixx.unlocked);
            for (Bookmark b : bookmarks) {
                if (!BookmarkType.IGNORE.equals((Object)b.getType())) continue;
                LOG.fine("Ignore bookmark found in scene " + scene.getNameOfPlayable());
                paras.add(":stop-time=" + b.getStartTime());
                if (scene.getEndMedium() != null && !scene.getEndMedium().equals(scene.getStartMedium())) {
                    paras.add(((MediumFile)scene.getEndMedium()).getFileCompletePath());
                }
                paras.add(medium.getFileCompletePath());
                paras.add(":start-time=" + b.getEndTime());
            }
            if (scene.getEndMedium() != null && !scene.getEndMedium().equals(scene.getStartMedium())) {
                paras.add(((MediumFile)scene.getEndMedium()).getFileCompletePath());
            }
            paras.add(":stop-time=" + scene.getEndTime());
            Object bookmarkParams = "";
            for (Bookmark b : scene.getBookmarks(Scenerixx.unlocked)) {
                bookmarkParams = (String)bookmarkParams + "{name=" + b.getNameOfPlayable() + ",time=" + b.getStartTime() + "},";
            }
            if (!((String)bookmarkParams).isEmpty()) {
                bookmarkParams = ((String)bookmarkParams).substring(0, ((String)bookmarkParams).length() - 1);
                bookmarkParams = "--bookmarks=\"" + (String)bookmarkParams + "\"";
                paras.add((String)bookmarkParams);
            }
            LOG.info("--------BookmarkParams" + (String)bookmarkParams);
        } else if (scene.getMovieAssociated().getScenes().size() == 1 && scene.getMovieAssociated().getStartMedium() != null) {
            LOG.info("no medium associated. Using movie");
            paras.add(((MediumFile)scene.getMovieAssociated().getStartMedium()).getFileCompletePath());
        }
    }

    public void openVlcPlaylist(String displayname, Playlist playlist, boolean randomized) {
        LOG.info("Starting mediums for " + displayname);
        this.openVlc(playlist, false, randomized);
    }

    public void openVlc(String displayname, Movie m, Scene s, Bookmark b, MediumFile mf, boolean loop) {
        this.openVlc(displayname, m, s, b, mf, loop, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openVlc(String displayname, Movie m, Scene s, Bookmark b, MediumFile mf, boolean loop, boolean reload) {
        boolean temporaryPlaylist = false;
        boolean tubeMovie = false;
        LOG.info("Starting mediums for: " + displayname);
        Statistic statistic = new Statistic();
        int startTime = 0;
        Object chapter = "";
        Movie movie = null;
        List<MediumFile> mediumFiles = new ArrayList<MediumFile>();
        if (mf != null) {
            mediumFiles.add(mf);
            statistic = this.createHistoryPlaylistEntry((IPlayable)mf);
        } else if (m != null) {
            movie = m;
            mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
            statistic = this.createHistoryPlaylistEntry((IPlayable)movie);
            if (loop) {
                if (!this.checkIfAllMediumFilesAreOnline(mediumFiles)) {
                    return;
                }
                Playlist p = new Playlist();
                PlaylistEntry pe = new PlaylistEntry();
                pe.setMovie(movie);
                p.getEntries(Scenerixx.unlocked).add(pe);
                this.openVlc(p, true);
                temporaryPlaylist = true;
            }
            startTime = new ScenerixxCommonLib().getStarttimeUsingSmartStart(movie, startTime, Scenerixx.unlocked);
        } else if (s != null) {
            Scene scene = s;
            if (scene.getTitle() != null) {
                chapter = "#" + scene.getTitle();
            }
            if (scene.getChapter() != null) {
                chapter = (String)chapter + ":" + scene.getChapter();
            }
            statistic = this.createHistoryPlaylistEntry((IPlayable)scene);
            if (loop) {
                if (!this.checkIfAllMediumFilesAreOnline(mediumFiles)) {
                    return;
                }
                p = new Playlist();
                p.setName("temp open scene");
                PlaylistEntry pe = new PlaylistEntry();
                pe.setScene(scene);
                p.getEntries(Scenerixx.unlocked).add(pe);
                this.openVlc(p, true);
                temporaryPlaylist = true;
            }
            startTime = scene.getStartTime();
            startTime = new ScenerixxCommonLib().getStarttimeForSceneUsingSmartStart(scene, startTime, Scenerixx.unlocked);
            movie = scene.getMovie();
            mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
            if (scene.getStartMedium() != null) {
                tmpMediumFiles = new ArrayList<MediumFile>();
                int startIndex = 0;
                tmpIndex = 0;
                for (MediumFile mediumFile : mediumFiles) {
                    if (mediumFile.getId().equals(scene.getStartMedium().getId())) {
                        startIndex = tmpIndex;
                    }
                    ++tmpIndex;
                }
                for (i = startIndex; i < mediumFiles.size(); ++i) {
                    tmpMediumFiles.add((MediumFile)mediumFiles.get(i));
                }
                for (i = 0; i < startIndex; ++i) {
                    tmpMediumFiles.add((MediumFile)mediumFiles.get(i));
                }
                mediumFiles.clear();
                mediumFiles.addAll(tmpMediumFiles);
            }
        } else if (b != null) {
            Bookmark bookmark = b;
            if (bookmark.getTitle() != null) {
                chapter = "#" + bookmark.getTitle();
            }
            if (bookmark.getChapter() != null) {
                chapter = (String)chapter + ":" + bookmark.getChapter();
            }
            statistic = this.createHistoryPlaylistEntry((IPlayable)bookmark);
            if (loop) {
                if (!this.checkIfAllMediumFilesAreOnline(mediumFiles)) {
                    return;
                }
                p = new Playlist();
                PlaylistEntry pe = new PlaylistEntry();
                pe.setBookmark(bookmark);
                p.getEntries(Scenerixx.unlocked).add(pe);
                this.openVlc(p, true);
                temporaryPlaylist = true;
            }
            startTime = bookmark.getStartTime();
            if (bookmark.getMovie() != null || bookmark.getParent() != null && bookmark.getParent().getMovie() != null) {
                movie = bookmark.getParent() != null ? bookmark.getParent().getMovie() : bookmark.getMovie();
                mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
                if (bookmark.getMedium() != null) {
                    tmpMediumFiles = new ArrayList();
                    int startIndex = 0;
                    tmpIndex = 0;
                    for (MediumFile mediumFile : tmpMediumFiles) {
                        if (mediumFile.getId().equals(bookmark.getMedium().getId())) {
                            startIndex = tmpIndex;
                        }
                        ++tmpIndex;
                    }
                    for (i = startIndex; i < mediumFiles.size(); ++i) {
                        tmpMediumFiles.add((MediumFile)mediumFiles.get(i));
                    }
                    for (i = 0; i < startIndex; ++i) {
                        tmpMediumFiles.add((MediumFile)mediumFiles.get(i));
                    }
                    mediumFiles.clear();
                    mediumFiles.addAll(tmpMediumFiles);
                }
            }
            if (bookmark.getScene() != null || bookmark.getParent() != null && bookmark.getParent().getScene() != null) {
                Scene tmpScene = null;
                if (bookmark.getParent() != null) {
                    movie = bookmark.getParent().getScene().getMovie();
                    tmpScene = bookmark.getParent().getScene();
                } else {
                    movie = bookmark.getScene().getMovie();
                    tmpScene = bookmark.getScene();
                }
                mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
                if (tmpScene.getStartMedium() != null) {
                    void var20_38;
                    void var20_36;
                    ArrayList<MediumFile> tmpMediumFiles = new ArrayList<MediumFile>();
                    boolean startIndex = false;
                    int tmpIndex = 0;
                    for (MediumFile tmpmf : tmpMediumFiles) {
                        if (tmpmf.getId().equals(tmpScene.getStartMedium().getId())) {
                            startTime = tmpIndex;
                        }
                        ++tmpIndex;
                    }
                    boolean bl = startIndex;
                    while (var20_36 < mediumFiles.size()) {
                        tmpMediumFiles.add((MediumFile)mediumFiles.get((int)var20_36));
                        ++var20_36;
                    }
                    boolean bl2 = false;
                    while (var20_38 < startIndex) {
                        tmpMediumFiles.add((MediumFile)mediumFiles.get((int)var20_38));
                        ++var20_38;
                    }
                    mediumFiles.clear();
                    mediumFiles.addAll(tmpMediumFiles);
                }
            }
            if (bookmark.getMedium() != null) {
                mediumFiles.clear();
                mediumFiles.add((MediumFile)bookmark.getMedium());
            }
        }
        ArrayList<String> paras = new ArrayList<String>();
        paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
        if (mediumFiles.isEmpty()) {
            Dvd dvd = this.db.getDvd(movie, Scenerixx.unlocked);
            if (dvd != null) {
                String dvdparas = "dvd://media/jr/" + (String)chapter;
                paras.add(dvdparas);
                paras.add(":start-time=" + startTime);
            } else {
                if (!this.tryToOpenTubeVideo(movie, s, b, startTime)) {
                    JOptionPane.showMessageDialog(null, "Could not start. No media files nor DVD found");
                    return;
                }
                tubeMovie = true;
            }
        } else {
            paras.add(((MediumFile)mediumFiles.get(0)).getFileCompletePath());
            paras.add(":start-time=" + startTime);
            if (((MediumFile)mediumFiles.get(0)).getDesyncAudio() != null) {
                paras.add(":audio-desync=" + ((MediumFile)mediumFiles.get(0)).getDesyncAudio());
            }
            if (mediumFiles.size() > 1) {
                for (int i = 1; i < mediumFiles.size(); ++i) {
                    paras.add(((MediumFile)mediumFiles.get(i)).getFileCompletePath());
                    if (((MediumFile)mediumFiles.get(i)).getDesyncAudio() == null) continue;
                    paras.add(":audio-desync=" + ((MediumFile)mediumFiles.get(i)).getDesyncAudio());
                }
            }
        }
        if (this.cbFullscreen.isSelected()) {
            paras.add("-f");
        }
        try {
            if (!temporaryPlaylist && !tubeMovie) {
                ProcessBuilder builder = new ProcessBuilder(paras);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                InputStream itsOutput = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(itsOutput));
                Thread thread = new Thread(() -> {
                    LOG.fine("VLC was started ");
                    while (process.isAlive()) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                LOG.finest("VLC Stdout: " + line);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                thread.start();
            }
            statistic.getStarted().add(LocalDateTime.now());
            this.db.getEntityService().save((AbstractEntity)statistic);
            if (!reload) return;
            PlaylistTopComponent playlist = (PlaylistTopComponent)WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlist == null) return;
            if (playlist.getExplorerManager().getSelectedNodes().length == 1) {
                this.reloadList(playlist.getExplorerManager().getSelectedNodes()[0]);
                return;
            }
            MovieListTopComponent.reloadPlaylist();
            return;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
        }
    }

    public Statistic createHistoryPlaylistEntry(IPlayable playable) {
        Bookmark bookmark;
        Scene scene;
        MediumFile mf;
        Movie movie;
        Statistic statistic = null;
        if (playable instanceof Movie) {
            movie = (Movie)playable;
            statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.movie.eq((Object)movie)).findFirst();
        }
        if (playable instanceof MediumFile) {
            mf = (MediumFile)playable;
            statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.medium.eq((Object)mf)).findFirst();
        }
        if (playable instanceof Scene) {
            scene = (Scene)playable;
            statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.scene.eq((Object)scene)).findFirst();
        }
        if (playable instanceof Bookmark) {
            bookmark = (Bookmark)playable;
            statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.bookmark.eq((Object)bookmark)).findFirst();
        }
        if (statistic == null) {
            statistic = new Statistic();
            statistic = (Statistic)this.db.getEntityService().save((AbstractEntity)statistic);
        }
        if (playable instanceof Movie) {
            movie = (Movie)playable;
            statistic.setMovie(movie);
        }
        if (playable instanceof MediumFile) {
            mf = (MediumFile)playable;
            statistic.setMedium((Medium)mf);
        }
        if (playable instanceof Scene) {
            scene = (Scene)playable;
            statistic.setScene(scene);
        }
        if (playable instanceof Bookmark) {
            bookmark = (Bookmark)playable;
            statistic.setBookmark(bookmark);
        }
        this.ps.addHistoryEntry(playable, Scenerixx.unlocked);
        return statistic;
    }

    private boolean checkIfAllMediumFilesAreOnline(Playlist playlist) throws HeadlessException {
        ArrayList<MediumFile> mediumFiles = new ArrayList<MediumFile>();
        for (PlaylistEntry pe : playlist.getEntries(Scenerixx.unlocked)) {
            if (pe.getMediumFile() != null) {
                mediumFiles.add(pe.getMediumFile());
            }
            if (pe.getMovie() != null && pe.getMovie().getStartMedium() != null) {
                mediumFiles.add((MediumFile)pe.getMovie().getStartMedium());
            }
            if (pe.getScene() != null && pe.getScene().getMovieAssociated().getStartMedium() != null) {
                mediumFiles.add((MediumFile)pe.getScene().getMovieAssociated().getStartMedium());
            }
            if (pe.getBookmark() == null || pe.getBookmark().getMovieAssociated().getStartMedium() == null) continue;
            mediumFiles.add((MediumFile)pe.getBookmark().getMovieAssociated().getStartMedium());
        }
        return this.checkIfAllMediumFilesAreOnline(mediumFiles);
    }

    private boolean checkIfAllMediumFilesAreOnline(List<MediumFile> mediumFiles) throws HeadlessException {
        for (int i = 0; i < mediumFiles.size(); ++i) {
            if (Files.exists(Paths.get(mediumFiles.get(i).getFileCompletePath(), new String[0]), new LinkOption[0])) continue;
            JOptionPane.showMessageDialog(null, "Could not start. Some media files are not available. Are all devices online?\nThe first file we could not find: \n" + mediumFiles.get(i).getFileCompletePath(), "Error", 0);
            return false;
        }
        return true;
    }

    private boolean tryToOpenTubeVideo(Movie movie, Scene s, Bookmark b, int startTime) {
        boolean tubeMovie = false;
        ScenerixxSettings scenerixxSettings = this.db.getScenerixxSettings();
        if (movie != null && movie.getTubeUrl() != null && !movie.getTubeUrl().isEmpty()) {
            ScenerixxCommon.openExternalBrowser(this.getTubeUrl(movie.getTubeUrl(), startTime), scenerixxSettings.getPathToDefaultBrowserBinary());
            tubeMovie = true;
        } else if (s != null && s.getMovie().getTubeUrl() != null && !s.getMovie().getTubeUrl().isEmpty()) {
            ScenerixxCommon.openExternalBrowser(this.getTubeUrl(s.getMovie().getTubeUrl(), startTime), scenerixxSettings.getPathToDefaultBrowserBinary());
            tubeMovie = true;
        } else if (b != null && b.getMovieAssociated().getTubeUrl() != null && !b.getMovieAssociated().getTubeUrl().isEmpty()) {
            ScenerixxCommon.openExternalBrowser(this.getTubeUrl(b.getMovieAssociated().getTubeUrl(), startTime), scenerixxSettings.getPathToDefaultBrowserBinary());
            tubeMovie = true;
        }
        return tubeMovie;
    }

    private String getTubeUrl(String url, int startTime) {
        if (((String)url).contains("pornhub.com")) {
            if (((String)url).endsWith("/")) {
                url = ((String)url).substring(0, ((String)url).length() - 1);
            }
            url = (String)url + "&t=" + startTime;
        } else if (((String)url).contains("xhamster.com")) {
            url = (String)url + "?t=" + startTime + ".00";
        } else if (((String)url).contains("youporn.com") || ((String)url).contains("redtube.com")) {
            url = (String)url + "?t=" + startTime;
        }
        return url;
    }

    public void reloadList() {
        if (em.getSelectedNodes().length > 0) {
            LOG.fine("There is a selected node for reloading the list : " + String.valueOf(em.getSelectedNodes()[0]));
            this.reloadList(em.getSelectedNodes()[0]);
        } else {
            LOG.fine("No selected node for reloading the list.");
            this.reloadList(Node.EMPTY);
        }
    }

    public void reloadListAndRefocus() {
        this.reloadList();
        this.refocus();
    }

    public void refocus() {
        Node selectedNode = this.getSelectedNode();
        this.expandMovieNode(selectedNode);
        this.selectMovieNode(this.getNextNode(), false);
        this.selectMovieNode(selectedNode, false);
        this.selectNode(selectedNode, false);
    }

    public IPlayable getSelectedPlayable() {
        IPlayable result = null;
        if (em.getSelectedNodes().length == 1) {
            if (em.getSelectedNodes()[0].getValue("movie") != null) {
                result = (IPlayable)em.getSelectedNodes()[0].getValue("movie");
            }
            if (em.getSelectedNodes()[0].getValue("scene") != null) {
                result = (IPlayable)em.getSelectedNodes()[0].getValue("scene");
            }
            if (em.getSelectedNodes()[0].getValue("bookmark") != null) {
                result = (IPlayable)em.getSelectedNodes()[0].getValue("bookmark");
            }
            if (result != null) {
                LOG.info("selected playable is " + result.getNameOfPlayable());
            }
        }
        return result;
    }

    public Node selectMovieNodeForceRefresh(Movie movie) {
        this.movieChildFactory.refresh();
        return this.selectMovieNodeWithDetailsReload(movie, true);
    }

    public Node selectMovieNode(Movie movie) {
        return this.selectMovieNodeWithDetailsReload(movie, true);
    }

    public Node selectMovieNodeWithDetailsReload(Movie movie, boolean reloadDetails) {
        Node selectMovieNode = this.selectMovieNode(movie, false);
        if (reloadDetails) {
            this.reloadDetails(movie);
        }
        return selectMovieNode;
    }

    public Node getNextNode() {
        Node nextNode = null;
        Node[] selectedNodes = em.getSelectedNodes();
        if (selectedNodes.length > 0) {
            Children children = em.getRootContext().getChildren();
            int i = 0;
            for (Node n : children.getNodes()) {
                ++i;
                if (selectedNodes[selectedNodes.length - 1].equals((Object)n)) break;
            }
            if ((nextNode = em.getRootContext().getChildren().getNodeAt(i)) == null && em.getRootContext().getChildren().getNodesCount() > 1) {
                nextNode = em.getRootContext().getChildren().getNodeAt(i - 2);
            }
        }
        return nextNode;
    }

    public void expandMovieNode(Node node) {
        if (node != null) {
            if (node.getParentNode() != null && node.getParentNode().getValue("movie") != null && node.getParentNode().getValue("movie") instanceof Movie) {
                this.beanTreeViewAll.expandNode(node.getParentNode());
            } else if (node.getParentNode() != null && node.getParentNode().getParentNode() != null && node.getParentNode().getParentNode().getValue("movie") != null && node.getParentNode().getParentNode().getValue("movie") instanceof Movie) {
                this.beanTreeViewAll.expandNode(node.getParentNode().getParentNode());
            } else {
                this.beanTreeViewAll.expandNode(node);
            }
        }
    }

    public void selectMovieNode(Node node) {
        this.selectMovieNode(node, false);
    }

    public void selectMovieNode(Node node, boolean expand) {
        try {
            if (node != null) {
                if (node.getParentNode() != null && node.getParentNode().getValue("movie") != null && node.getParentNode().getValue("movie") instanceof Movie) {
                    node = node.getParentNode();
                } else if (node.getParentNode() != null && node.getParentNode().getParentNode() != null && node.getParentNode().getParentNode().getValue("movie") != null && node.getParentNode().getParentNode().getValue("movie") instanceof Movie) {
                    node = node.getParentNode().getParentNode();
                }
                em.setSelectedNodes(new Node[]{node});
                if (expand) {
                    this.beanTreeViewAll.expandNode(node);
                }
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
        }
    }

    public void selectNode(Node node, boolean expand) {
        if (node != null) {
            try {
                em.setSelectedNodes(new Node[]{node});
                if (expand) {
                    this.beanTreeViewAll.expandNode(node);
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
    }

    public Node selectMovieNode(Movie movie, boolean forceReload) {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("=========");
        Node child = null;
        if (movie != null && (!movie.equals(this.getSelectedPlayable()) || forceReload)) {
            LOG.info("SELECT MOVIE START " + movie.getNameOfPlayable() + " - " + Duration.between(LocalDateTime.now(), now).toString());
            try {
                child = em.getRootContext().getChildren().findChild("" + movie.getId());
                if (child != null) {
                    em.setSelectedNodes(new Node[]{child});
                    this.beanTreeViewAll.expandNode(child);
                } else {
                    LOG.info("Movie was not found in tree. No selection was made");
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
            LOG.info("SELECT MOVIE END " + movie.getNameOfPlayable() + " - " + Duration.between(LocalDateTime.now(), now).toString());
        }
        LOG.info("=========");
        return child;
    }

    public boolean selectSceneNode(Scene s) {
        return this.selectSceneNode(s, false);
    }

    public boolean selectSceneNode(Scene s, boolean updateNode) {
        boolean result = false;
        if (s != null && !s.equals(this.getSelectedPlayable()) && this.movieChildFactory != null) {
            this.movieChildFactory.refresh();
            Node movieNode = this.selectMovieNodeWithDetailsReload(s.getMovie(), false);
            if (movieNode != null) {
                result = true;
                SwingUtilities.invokeLater(() -> {
                    try {
                        Children children = movieNode.getChildren();
                        List nodes = children.snapshot();
                        LOG.finer("Passed in scene: " + String.valueOf(s));
                        Node child = null;
                        for (Node n : nodes) {
                            Scene sceneValue = (Scene)n.getValue("scene");
                            LOG.finer("node scene: " + String.valueOf(sceneValue));
                            if (n.getValue("scene") == null || !Objects.equals(sceneValue.getId(), s.getId())) continue;
                            child = n;
                            break;
                        }
                        if (child != null) {
                            LOG.finest("select scene node " + child.getDisplayName());
                            em.setSelectedNodes(new Node[]{child});
                            this.beanTreeViewAll.expandNode(child);
                            this.beanTreeViewAll.revalidate();
                            DetailsTopComponent detailsTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                            if (detailsTC != null) {
                                detailsTC.loadScene((Scene)child.getValue("scene"));
                                if (updateNode) {
                                    detailsTC.updateDisplayNameOfSelectedNode();
                                }
                            }
                        }
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                    }
                });
            }
        }
        return result;
    }

    public void selectBookmarkNode(Bookmark bookmarkToSelect) {
        SwingUtilities.invokeLater(() -> {
            LocalDateTime now = LocalDateTime.now();
            LOG.info("selectBookmark start " + Duration.between(LocalDateTime.now(), now).toString());
            if (bookmarkToSelect != null && !bookmarkToSelect.equals(this.getSelectedPlayable())) {
                TopComponent detailsTC = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (bookmarkToSelect.getSceneAssociated() != null) {
                    LOG.fine("select bookmark: select associated scene " + bookmarkToSelect.getSceneAssociated().getNameOfPlayable());
                    this.selectSceneNode(bookmarkToSelect.getSceneAssociated());
                } else if (bookmarkToSelect.getMovieAssociated() != null) {
                    LOG.fine("select bookmark: select associated movie " + bookmarkToSelect.getMovieAssociated().getNameOfPlayable());
                    this.selectMovieNodeWithDetailsReload(bookmarkToSelect.getMovieAssociated(), false);
                } else if (bookmarkToSelect.getParent() != null) {
                    LOG.fine("it's a sub-bookmark");
                }
                if (em.getSelectedNodes().length > 0) {
                    LOG.info("There's a selection: " + String.valueOf(em.getSelectedNodes()[0]));
                    this.movieChildFactory.reloadList(em.getSelectedNodes()[0]);
                    this.selectMovieNode(bookmarkToSelect.getMovieAssociated());
                }
                SwingUtilities.invokeLater(() -> {
                    LOG.info("selectBookmark start invokelater: " + Duration.between(LocalDateTime.now(), now).toString());
                    Node parentNode = null;
                    LOG.fine("Bookmark to select: " + bookmarkToSelect.getId() + " - " + bookmarkToSelect.getNameOfPlayable());
                    if (bookmarkToSelect.getMovie() != null && em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("movie") != null && ((Movie)em.getSelectedNodes()[0].getValue("movie")).getId().longValue() == bookmarkToSelect.getMovie().getId().longValue()) {
                        LOG.fine("It's a movie bookmark");
                        parentNode = em.getSelectedNodes()[0];
                    } else if (em.getSelectedNodes().length == 1 && bookmarkToSelect.getParent() == null && em.getSelectedNodes()[0].getValue("scene") != null && ((Scene)em.getSelectedNodes()[0].getValue("scene")).getId().longValue() == bookmarkToSelect.getSceneAssociated().getId().longValue()) {
                        LOG.fine("It's a scene bookmark");
                        parentNode = em.getSelectedNodes()[0];
                    } else if (em.getSelectedNodes().length == 1 && bookmarkToSelect.getParent() != null && em.getSelectedNodes()[0].getValue("scene") != null && ((Scene)em.getSelectedNodes()[0].getValue("scene")).getId().longValue() == bookmarkToSelect.getSceneAssociated().getId().longValue()) {
                        LOG.fine("It's a sub-bookmark");
                        for (Node n : em.getSelectedNodes()[0].getChildren().getNodes()) {
                            if (((Bookmark)n.getValue("bookmark")).getId().longValue() != bookmarkToSelect.getParent().getId().longValue()) continue;
                            parentNode = n;
                        }
                        LOG.fine("sub-bookmark node: " + String.valueOf(parentNode));
                    }
                    if (parentNode != null) {
                        LOG.fine("parentNode: " + String.valueOf(parentNode));
                        Children children = parentNode.getChildren();
                        List<Node> nodes = Arrays.asList(children.getNodes(true));
                        Node child = null;
                        for (Node n : nodes) {
                            LOG.fine("possible node : " + String.valueOf(n));
                            Bookmark bookmarkValue = (Bookmark)n.getValue("bookmark");
                            if (bookmarkValue != null) {
                                LOG.fine("node bookmark: " + String.valueOf(bookmarkValue.getType()) + " - " + bookmarkValue.getNameOfPlayable() + " - " + bookmarkValue.getId() + " - " + bookmarkToSelect.getId());
                            }
                            if (bookmarkValue == null || !Objects.equals(bookmarkValue.getId(), bookmarkToSelect.getId())) continue;
                            child = n;
                            break;
                        }
                        if (child != null) {
                            Node tmpChild = child;
                            SwingUtilities.invokeLater(() -> {
                                LOG.fine("select bookmark node " + tmpChild.getDisplayName());
                                try {
                                    em.setSelectedNodes(new Node[]{tmpChild});
                                }
                                catch (PropertyVetoException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                                }
                                this.beanTreeViewAll.revalidate();
                                if (detailsTC != null) {
                                    ((DetailsTopComponent)detailsTC).loadBookmark((Bookmark)tmpChild.getValue("bookmark"));
                                }
                            });
                        }
                        if (bookmarkToSelect.getParent() != null && bookmarkToSelect.getMovie() == null && bookmarkToSelect.getScene() == null) {
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    Node parentBookmarkNode = em.getSelectedNodes()[0];
                                    if (em.getSelectedNodes().length > 0) {
                                        Object patt0$temp;
                                        LOG.info("There's a selection2: " + String.valueOf(em.getSelectedNodes()[0]));
                                        this.movieChildFactory.reloadList(em.getSelectedNodes()[0]);
                                        this.movieChildFactory.refresh();
                                        if (em.getSelectedNodes()[0].getValue("bookmark") != null && (patt0$temp = em.getSelectedNodes()[0].getValue("bookmark")) instanceof Bookmark) {
                                            Bookmark bookmark = (Bookmark)patt0$temp;
                                            LOG.info("bookmark to select after reload: " + String.valueOf(bookmark));
                                            this.selectBookmarkNode(bookmark);
                                        }
                                    }
                                    Children bookmarkChildren = parentBookmarkNode.getChildren();
                                    List bookmarknodes = bookmarkChildren.snapshot();
                                    Node bookmarkChild = null;
                                    for (Node n : bookmarknodes) {
                                        if (n.getValue("bookmark") == null || !((Bookmark)n.getValue("bookmark") instanceof Bookmark)) continue;
                                        LOG.finer("node sub bookmark: " + ((Bookmark)n.getValue("bookmark")).getNameOfPlayable());
                                        if (n.getValue("bookmark") == null || !Objects.equals(((Bookmark)n.getValue("bookmark")).getId(), bookmarkToSelect.getParent().getId())) continue;
                                        bookmarkChild = n;
                                        this.selectBookmarkNode((Bookmark)n.getValue("bookmark"));
                                        break;
                                    }
                                    if (bookmarkChild != null) {
                                        Children subbookmarkChildren = bookmarkChild.getChildren();
                                        bookmarkChild = null;
                                        List subbookmarknodes = subbookmarkChildren.snapshot();
                                        for (Node n : subbookmarknodes) {
                                            if (n.getValue("bookmark") == null || !Objects.equals(((Bookmark)n.getValue("bookmark")).getId(), bookmarkToSelect.getId())) continue;
                                            bookmarkChild = n;
                                            break;
                                        }
                                        if (bookmarkChild != null) {
                                            LOG.finer("select subbookmark node " + bookmarkChild.getDisplayName());
                                            em.setSelectedNodes(new Node[]{bookmarkChild});
                                            this.beanTreeViewAll.expandNode(bookmarkChild);
                                            this.beanTreeViewAll.revalidate();
                                            if (detailsTC != null) {
                                                ((DetailsTopComponent)detailsTC).loadBookmark((Bookmark)bookmarkChild.getValue("bookmark"));
                                            }
                                        }
                                    }
                                }
                                catch (PropertyVetoException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                                }
                            });
                        }
                    }
                    LOG.info("selectBookmark end invokeLater: " + Duration.between(LocalDateTime.now(), now).toString());
                });
            }
            LOG.info("selectBookmark end - " + Duration.between(LocalDateTime.now(), now).toString());
        });
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    private void setRootContextOrderByResolution() {
        Map moviesByResolution = DB.getInstance().getMoviesByResolution(this.tfSearch.getText());
        List toList = moviesByResolution.keySet().stream().toList();
        ArrayList modifiableList = new ArrayList(toList);
        Collections.sort(modifiableList, (o1, o2) -> o2.compareTo(o1));
        this.resolutionChildFactory = new ResolutionChildFactory(modifiableList, this.tfSearch.getText()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                MovieListTopComponent.this.reloadList();
            }
        };
        this.abstractNodeResolution = new AbstractNode(this, Children.create((ChildFactory)this.resolutionChildFactory, (boolean)false)){

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons.silk/arrow_out.png");
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        em.setRootContext((Node)this.abstractNodeResolution);
        em.getRootContext().setDisplayName("Resolution [" + toList.size() + "]");
    }

    private void setRootContextOrderByResolutionWidth() {
        TreeMap moviesByResolution = DB.getInstance().getMoviesByResolutionReducedWidth(this.tfSearch.getText());
        List widthList = moviesByResolution.keySet().stream().toList();
        ArrayList widthListModifiable = new ArrayList(widthList);
        Collections.reverse(widthListModifiable);
        ArrayList<Resolution> modifiableList = new ArrayList<Resolution>();
        for (Integer i : widthListModifiable) {
            modifiableList.add(new Resolution(i.intValue(), 0));
        }
        this.resolutionWidthChildFactory = new ResolutionWidthChildFactory(modifiableList, this.tfSearch.getText()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                MovieListTopComponent.this.reloadList();
            }
        };
        this.abstractNodeResolution = new AbstractNode(this, Children.create((ChildFactory)this.resolutionWidthChildFactory, (boolean)false)){

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons.silk/arrow_out.png");
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        em.setRootContext((Node)this.abstractNodeResolution);
        em.getRootContext().setDisplayName("Resolution by width [" + widthList.size() + "]");
    }

    private void setRootContextOrderByResolutionHeight() {
        TreeMap moviesByResolution = DB.getInstance().getMoviesByResolutionReducedHeight(this.tfSearch.getText());
        List heightList = moviesByResolution.keySet().stream().toList();
        ArrayList heightListModifiable = new ArrayList(heightList);
        Collections.reverse(heightListModifiable);
        ArrayList<Resolution> modifiableList = new ArrayList<Resolution>();
        for (Integer i : heightListModifiable) {
            modifiableList.add(new Resolution(0, i.intValue()));
        }
        this.resolutionHeightChildFactory = new ResolutionHeightChildFactory(modifiableList, this.tfSearch.getText()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                MovieListTopComponent.this.reloadList();
            }
        };
        this.abstractNodeResolution = new AbstractNode(this, Children.create((ChildFactory)this.resolutionHeightChildFactory, (boolean)false)){

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons.silk/arrow_out.png");
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        em.setRootContext((Node)this.abstractNodeResolution);
        em.getRootContext().setDisplayName("Resolution by height [" + heightList.size() + "]");
    }

    private void setRootContextOrderByType() {
        this.movieTypeChildFactory = new MovieTypeChildFactory(this.cbShowCounter.isSelected(), this.cbShowLikeCounter.isSelected(), this.cbShowRuntime.isSelected(), Scenerixx.unlocked, this.cbShowRating.isSelected(), this.cbShowPosition.isSelected(), this.cbPrefixMetaData.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                LOG.info("RELOAD list - ordering by type");
                MovieListTopComponent.this.reloadList();
            }
        };
        this.abstractNodeMovieTypes = new AbstractNode(Children.create((ChildFactory)this.movieTypeChildFactory, (boolean)false)){

            public Action[] getActions(boolean context) {
                return new Action[]{(Action)WeakListeners.create(Action.class, (EventListener)new ReloadAction(), null)};
            }

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)((MovieTypeFilter)MovieListTopComponent.this.comboMovieTypeFilter.getSelectedItem()).getIcon());
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }

            class ReloadAction
            extends AbstractAction {
                public ReloadAction() {
                    this.putValue("Name", "Reload");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovieListTopComponent.this.reloadList();
                }
            }
        };
        em.setRootContext((Node)this.abstractNodeMovieTypes);
        em.getRootContext().setDisplayName("Movie types [" + MovieType.values().length + "]");
    }

    private void addSceneOrBookmark(Node[] nodes) {
        for (Node n : nodes) {
            Bookmark bookmark;
            Scene scene;
            Movie movie = (Movie)n.getValue("movie");
            if (movie != null) {
                this.scenerixxCommon.addScene(movie);
            }
            if ((scene = (Scene)n.getValue("scene")) != null) {
                this.scenerixxCommon.addBookmark(scene);
            }
            if ((bookmark = (Bookmark)n.getValue("bookmark")) == null) continue;
            this.scenerixxCommon.addSubBookmark(bookmark);
        }
    }

    @Override
    public boolean getShowPosition() {
        return this.cbShowPosition.isSelected();
    }

    @Override
    public boolean getShowCounter() {
        return this.cbShowCounter.isSelected();
    }

    @Override
    public boolean getShowLikeCounter() {
        return this.cbShowLikeCounter.isSelected();
    }

    @Override
    public boolean getShowRuntime() {
        return this.cbShowRuntime.isSelected();
    }

    @Override
    public boolean getShowMoviesWithScenerixxFiles() {
        return this.showMoviesWithScenerixxFiles;
    }

    public boolean getShowMoviesWithScreencaps() {
        return this.showMoviesWithScreencaps;
    }

    @Override
    public boolean getShowRating() {
        return this.cbShowRating.isSelected();
    }

    public MovieChildFactory getMovieChildFactory() {
        return this.movieChildFactory;
    }

    @Override
    public boolean getPrefixMetaData() {
        return this.cbPrefixMetaData.isSelected();
    }

    public Playlist getPlaylistToShow() {
        return this.playlistToShow;
    }

    public void setNextNode(Movie nextMovie) {
        this.selectMovieNode(nextMovie);
    }

    public class UpdateSearchResultListWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            String org = new String(MovieListTopComponent.this.tfSearch.getText());
            Thread.sleep(100L);
            if (MovieListTopComponent.this.tfSearch.getText().equalsIgnoreCase(org)) {
                Thread.sleep(500L);
                if (MovieListTopComponent.this.tfSearch.getText().equalsIgnoreCase(org)) {
                    LOG.fine("Searchterms: " + MovieListTopComponent.this.tfSearch.getText());
                    SwingUtilities.invokeLater(() -> {
                        MovieListTopComponent.this.search();
                        SearchQuery sq = new SearchQuery();
                        sq.setSearchQuery(MovieListTopComponent.this.tfSearch.getText());
                        sq.setTab(Tab.Movies);
                        MovieListTopComponent.this.db.getEntityService().save((AbstractEntity)sq);
                    });
                }
            } else {
                LOG.fine("org: " + org + " - current: " + MovieListTopComponent.this.tfSearch.getText());
            }
            return "";
        }
    }
}

