/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.mediumfile;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.ExportLevel;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.Tab;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MediumFileShowHideFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.MediumFileTypeFilter;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByMediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.DeletedMedium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.search.QSearchQuery;
import xxx.scenerixx.scenerixxlib.model.search.SearchQuery;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.MediumFileChildFactory;
import xxx.scenerixx.scenerixxmodule.util.AutocompleterMovies;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.StandardContextMenu;
import xxx.scenerixx.scenerixxmodule.util.gui.bean.ScenerixxBeanTreeView;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.MediumFileShowHideFilterComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.MediumFileTypeFilterComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.OrderByMediumFileComboRenderer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

@TopComponent.Description(preferredID="MediumFileListTopComponent", iconBase="icons/film.png", persistenceType=2)
public final class MediumFileListTopComponent
extends AbstractTopComponent
implements ExplorerManager.Provider {
    private static final Logger LOG = Logger.getLogger(MediumFileListTopComponent.class.getName());
    private ExplorerManager em = new ExplorerManager();
    private static int currentinstance = 1;
    private boolean initialized = false;
    private boolean mov = false;
    private boolean pix = false;
    private boolean all = false;
    private boolean unknown = false;
    private boolean showDuplicatesByHash = false;
    private boolean asc = true;
    private AutocompleterMovies autocompleter = new AutocompleterMovies(25, true);
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private BeanTreeView beanTreeView1;
    private JButton btnAddToDefaultPlaylist;
    private JButton btnCreateMoviesFromNodes;
    private JButton btnCreateNewInstance;
    private JButton btnCreateNewMovie;
    private JButton btnCreateSingleScenes;
    private JButton btnDeleteFromDatabase;
    private JButton btnDeleteFromDisc;
    private JButton btnReload;
    private JButton btnResetExportLevel;
    private JButton btnSave;
    private JButton btnSelectRandomNode;
    private JButton btnVlc;
    private JCheckBox cbFavorite;
    public JCheckBox cbShowCounter;
    public JCheckBox cbShowDirectory;
    public JCheckBox cbShowFileSize;
    public JCheckBox cbShowPosition;
    private JComboBox<ExportLevel> comboExportLevel;
    public JComboBox<MediumFileTypeFilter> comboFilter;
    public JComboBox<OrderByMediumFile> comboOrderBy;
    public JComboBox<MediumFileShowHideFilter> comboShowHideFilter;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel lbAudioDesync;
    private JLabel lbDuration;
    private JLabel lbExportlevel;
    private JLabel lbOrderBy;
    private JLabel lbPart;
    private JLabel lbRating;
    private JLabel lbSearch;
    private JLabel lbShow;
    private JLabel lbStatus;
    private JLabel lbWidth;
    private JPanel mediumFilePropertiesPanel;
    private JPanel panelShow;
    private JPanel searchOptionsPanel;
    private JTextField tfAudioDesync;
    private JTextField tfDurationHour;
    private JTextField tfDurationMinutes;
    private JTextField tfDurationSeconds;
    private JTextField tfHash;
    private JTextField tfHeight;
    private JTextField tfPart;
    private JTextField tfRating;
    private JTextField tfSearch;
    private JTextField tfWidth;
    public JToggleButton toggleBtnAsc;
    private JToggleButton toggleBtnMore;

    public MediumFileListTopComponent() {
        this("");
    }

    public MediumFileListTopComponent(String searchTerm) {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("Initialize Medium File window: " + String.valueOf(now));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("Initializing Medium File window");
            TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
            if (dashboard != null) {
                ((DashboardTopComponent)dashboard).setStatus("Initializing Medium File window");
            }
        });
        this.initComponents();
        this.tfSearch.setText(searchTerm);
        this.comboOrderBy.setModel(new DefaultComboBoxModel<OrderByMediumFile>(OrderByMediumFile.values()));
        this.comboOrderBy.setRenderer(new OrderByMediumFileComboRenderer());
        this.comboFilter.setModel(new DefaultComboBoxModel<MediumFileTypeFilter>(MediumFileTypeFilter.values()));
        this.comboFilter.setRenderer(new MediumFileTypeFilterComboRenderer());
        this.comboShowHideFilter.setModel(new DefaultComboBoxModel<MediumFileShowHideFilter>(MediumFileShowHideFilter.values()));
        this.comboShowHideFilter.setRenderer(new MediumFileShowHideFilterComboRenderer());
        this.panelShow.setVisible(true);
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        this.toggleBtnAsc.setSelected(uiState.isMediumfilelistAsc());
        this.cbShowCounter.setSelected(uiState.isMediumfilelistCounter());
        this.cbShowDirectory.setSelected(uiState.isMediumfilelistDirectory());
        this.cbShowFileSize.setSelected(uiState.isMediumfilelistFilesize());
        this.cbShowPosition.setSelected(uiState.isMediumfilelistPosition());
        this.comboOrderBy.setSelectedItem(uiState.getMediumfilelistOrderBy());
        this.comboShowHideFilter.setSelectedItem(uiState.getMediumfilelistShowHideFilter());
        this.comboFilter.setSelectedItem(uiState.getMediumfilelistTypeFilter());
        if (this.comboShowHideFilter.getSelectedItem() == null) {
            this.comboShowHideFilter.setSelectedItem(MediumFileShowHideFilter.DoNotHide);
        }
        if (this.comboOrderBy.getSelectedItem() == null) {
            this.comboOrderBy.setSelectedItem(OrderByMediumFile.Name);
        }
        if (this.comboFilter.getSelectedItem() == null) {
            this.comboFilter.setSelectedItem(MediumFileTypeFilter.Movies);
        }
        this.toggleCbFilesize();
        this.toggleCbShowCounter();
        this.toggleCbShowDirectory();
        this.togglePosition();
        this.toggleShowMorePanel();
        this.asc = uiState.isStudiolistAsc();
        this.toggleAsc();
        StandardContextMenu.addTo(this.tfSearch);
        StandardContextMenu.addTo(this.tfAudioDesync);
        StandardContextMenu.addTo(this.tfHash);
        StandardContextMenu.addTo(this.tfDurationHour);
        StandardContextMenu.addTo(this.tfDurationMinutes);
        StandardContextMenu.addTo(this.tfDurationSeconds);
        StandardContextMenu.addTo(this.tfHeight);
        StandardContextMenu.addTo(this.tfPart);
        StandardContextMenu.addTo(this.tfRating);
        StandardContextMenu.addTo(this.tfWidth);
        this.setName("Medium Files");
        this.setToolTipText(Bundle.HINT_MediumFileListTopComponent());
        this.setMinimumSize(new Dimension(0, 0));
        this.lbStatus.setVisible(false);
        this.comboExportLevel.setVisible(this.db.getScenerixxSettings().isShowExport());
        this.lbExportlevel.setVisible(this.db.getScenerixxSettings().isShowExport());
        this.btnResetExportLevel.setVisible(this.db.getScenerixxSettings().isShowExport());
        this.lbAudioDesync.setVisible(this.db.getScenerixxSettings().isShowRare());
        this.tfAudioDesync.setVisible(this.db.getScenerixxSettings().isShowRare());
        this.comboExportLevel.setModel(new DefaultComboBoxModel<ExportLevel>(ExportLevel.values()));
        this.comboExportLevel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof ExportLevel) {
                    ExportLevel level = (ExportLevel)value;
                    this.setToolTipText(level.getDescription());
                    value = level.getLevel();
                } else {
                    this.setToolTipText(null);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(20);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.em, (ActionMap)this.getActionMap()));
        this.disableEditComponents();
        KeyStroke keyEnter = KeyStroke.getKeyStroke(10, 2);
        AbstractAction openSelectedItems = new AbstractAction("OpenSelectedItemsFromMediumFileList"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.startVlc();
            }
        };
        this.beanTreeView1.getActionMap().put("OpenSelectedItemsFromMediumFileList", openSelectedItems);
        this.beanTreeView1.getInputMap(1).put(keyEnter, "OpenSelectedItemsFromMediumFileList");
        KeyStroke keyDelete = KeyStroke.getKeyStroke(127, 0);
        AbstractAction performDelete = new AbstractAction("performDelete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.deleteFromDatabase();
            }
        };
        this.beanTreeView1.getActionMap().put("performDelete", performDelete);
        this.beanTreeView1.getInputMap(1).put(keyDelete, "performDelete");
        KeyStroke keyDeleteFromDisc = KeyStroke.getKeyStroke(127, 1);
        AbstractAction performDeleteFromDisc = new AbstractAction("DeleteFromDisc"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.deleteFromDatabaseAndDisc();
            }
        };
        this.beanTreeView1.getActionMap().put("DeleteFromDisc", performDeleteFromDisc);
        this.beanTreeView1.getInputMap(1).put(keyDeleteFromDisc, "DeleteFromDisc");
        KeyStroke keyInsert = KeyStroke.getKeyStroke(80, 128);
        AbstractAction addToPlaylist = new AbstractAction("AddToPlaylist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.addToDefaultPlaylist(MediumFileListTopComponent.this.em.getSelectedNodes());
            }
        };
        this.beanTreeView1.getActionMap().put("AddToPlaylist", addToPlaylist);
        this.beanTreeView1.getInputMap(1).put(keyInsert, "AddToPlaylist");
        KeyStroke keyF6 = KeyStroke.getKeyStroke(117, 0);
        AbstractAction performAddToClipboard = new AbstractAction("performAddToClipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("copy");
                if (MediumFileListTopComponent.this.em.getSelectedNodes().length > 0) {
                    for (Node n : MediumFileListTopComponent.this.em.getSelectedNodes()) {
                        String displayname = "";
                        if (n.getValue("mediumFile") != null) {
                            MediumFileListTopComponent.this.clipboard((IPlayablePlaylistItems)((MediumFile)n.getValue("mediumFile")));
                            displayname = ((MediumFile)n.getValue("mediumFile")).getFileCompletePath();
                        }
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + displayname);
                        LOG.info("added to temporary playlist: " + displayname);
                    }
                    AbstractTopComponent.reloadPlaylist("[TEMPORARY PLAYLIST]");
                }
            }
        };
        this.beanTreeView1.getActionMap().put("performAddToClipboard", performAddToClipboard);
        this.beanTreeView1.getInputMap(1).put(keyF6, "performAddToClipboard");
        AbstractAction reloadAction = new AbstractAction("reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.reloadList();
            }
        };
        KeyStroke keyF5 = KeyStroke.getKeyStroke(116, 0);
        this.beanTreeView1.getActionMap().put("reload", reloadAction);
        this.beanTreeView1.getInputMap(1).put(keyF5, "reload");
        AbstractAction randomSelectAction = new AbstractAction("randomSelect"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediumFileListTopComponent.this.selectRandomNode();
            }
        };
        KeyStroke keyCtrlR = KeyStroke.getKeyStroke(82, 128);
        this.beanTreeView1.getActionMap().put("randomSelect", randomSelectAction);
        this.beanTreeView1.getInputMap(1).put(keyCtrlR, "randomSelect");
        this.em.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selectedNodes = this.em.getSelectedNodes();
                ScenerixxCommon.setSelectedNodesInTitle(selectedNodes.length, "medium");
            }
            boolean onlyMediumNodesSelected = true;
            boolean onlyUnassociatedNodesSelected = true;
            for (Node n : this.em.getSelectedNodes()) {
                if (n.getValue("mediumFile") == null) {
                    onlyMediumNodesSelected = false;
                    continue;
                }
                if (((MediumFile)n.getValue("mediumFile")).getMovie() == null) continue;
                onlyUnassociatedNodesSelected = false;
            }
            if (this.em.getSelectedNodes().length > 0) {
                this.btnDeleteFromDatabase.setEnabled(true);
                this.btnDeleteFromDisc.setEnabled(true);
                long fileSize = 0L;
                int runtime = 0;
                int selectedCnt = 0;
                for (Node node : this.em.getSelectedNodes()) {
                    MediumFile currentMediumFile = (MediumFile)node.getValue("mediumFile");
                    if (currentMediumFile == null) continue;
                    fileSize += currentMediumFile.getFileSize().longValue();
                    if (currentMediumFile.getMovie() != null && currentMediumFile.getDuration() != null) {
                        runtime += currentMediumFile.getDuration().intValue();
                    }
                    ++selectedCnt;
                }
                String status = selectedCnt + " medium files selected";
                if (fileSize > 0L) {
                    status = status + " [Filesize: " + ScenerixxCommon.readableFileSize(fileSize) + "]";
                }
                if (runtime > 0) {
                    status = status + " [Runtime: " + ScenerixxCommon.readableDuration(runtime) + "]";
                }
                this.lbStatus.setText(status);
                this.lbStatus.setVisible(true);
            } else {
                this.lbStatus.setText("");
                this.lbStatus.setVisible(false);
            }
            if (this.em.getSelectedNodes().length == 0 || !onlyMediumNodesSelected) {
                this.disableEditComponents();
            } else if (this.em.getSelectedNodes().length == 1 && onlyMediumNodesSelected) {
                TopComponent movieList;
                MediumFile currentMediumFile = (MediumFile)this.em.getSelectedNodes()[0].getValue("mediumFile");
                TopComponent detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTopComponent != null && currentMediumFile.getMovie() != null) {
                    Movie loadMovie = (Movie)this.db.getEntityService().load(Movie.class, currentMediumFile.getMovie().getId().longValue());
                    ((DetailsTopComponent)detailTopComponent).loadMovie(loadMovie, true);
                }
                if ((movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null && currentMediumFile.getMovie() != null) {
                    ((MovieListTopComponent)movieList).selectMovieNode(currentMediumFile.getMovie());
                }
                this.tfWidth.setEnabled(true);
                if (currentMediumFile.getWidth() != null) {
                    this.tfWidth.setText("" + currentMediumFile.getWidth());
                } else {
                    this.tfWidth.setText("");
                }
                this.tfHeight.setEnabled(true);
                if (currentMediumFile.getHeight() != null) {
                    this.tfHeight.setText("" + currentMediumFile.getHeight());
                } else {
                    this.tfHeight.setText("");
                }
                this.tfAudioDesync.setEnabled(true);
                if (currentMediumFile.getDesyncAudio() != null) {
                    this.tfAudioDesync.setText("" + currentMediumFile.getDesyncAudio());
                } else {
                    this.tfAudioDesync.setText("");
                }
                if (currentMediumFile.getHashValue() != null) {
                    this.tfHash.setText(currentMediumFile.getHashValue());
                } else {
                    this.tfHash.setText("");
                }
                Integer duration = currentMediumFile.getDuration();
                this.tfDurationHour.setEnabled(true);
                this.tfDurationMinutes.setEnabled(true);
                this.tfDurationSeconds.setEnabled(true);
                if (duration != null) {
                    this.tfDurationHour.setText(String.format("%02d", duration / 1000 / 3600 % 24));
                    this.tfDurationMinutes.setText(String.format("%02d", duration / 1000 / 60 % 60));
                    this.tfDurationSeconds.setText(String.format("%02d", duration / 1000 % 60));
                } else {
                    this.tfDurationHour.setText("");
                    this.tfDurationMinutes.setText("");
                    this.tfDurationSeconds.setText("");
                }
                this.cbFavorite.setEnabled(true);
                this.cbFavorite.setSelected(currentMediumFile.isFavorite());
                this.tfPart.setEnabled(true);
                this.tfPart.setText("" + currentMediumFile.getPart());
                this.tfRating.setEnabled(true);
                Integer rating = currentMediumFile.getRating();
                if (rating != null) {
                    this.tfRating.setText("" + rating);
                } else {
                    this.tfRating.setText("");
                }
                this.comboExportLevel.setEnabled(true);
                if (currentMediumFile.getExportLevel() == null) {
                    this.comboExportLevel.setSelectedItem(null);
                } else {
                    this.comboExportLevel.setSelectedIndex(currentMediumFile.getExportLevel());
                }
                this.btnSave.setEnabled(true);
                this.btnVlc.setEnabled(true);
                this.btnAddToDefaultPlaylist.setEnabled(true);
                this.btnResetExportLevel.setEnabled(true);
                this.btnCreateNewMovie.setEnabled(onlyUnassociatedNodesSelected);
                this.btnCreateSingleScenes.setEnabled(onlyUnassociatedNodesSelected);
                this.btnCreateMoviesFromNodes.setEnabled(onlyUnassociatedNodesSelected);
            } else if (this.em.getSelectedNodes().length > 1 && onlyMediumNodesSelected) {
                this.btnVlc.setEnabled(true);
                this.btnAddToDefaultPlaylist.setEnabled(true);
                this.btnCreateNewMovie.setEnabled(onlyUnassociatedNodesSelected);
                this.btnCreateSingleScenes.setEnabled(onlyUnassociatedNodesSelected);
                this.btnCreateMoviesFromNodes.setEnabled(onlyUnassociatedNodesSelected);
            }
        });
        this.autocompleter.getAutoComplete().attachTo(this.tfSearch);
        this.initialized = true;
        if (!this.db.getScenerixxSettings().isLoadMediumFilesOnStartup()) {
            LOG.info("Medium file list should not be loaded during startup");
            this.setDirty();
            return;
        }
        this.reloadList();
        LOG.info("finished initializing medium file window " + Duration.between(LocalDateTime.now(), now).toString());
    }

    private void disableEditComponents() {
        this.tfWidth.setEnabled(false);
        this.tfWidth.setText("");
        this.tfHeight.setEnabled(false);
        this.tfHeight.setText("");
        this.tfDurationHour.setEnabled(false);
        this.tfDurationMinutes.setEnabled(false);
        this.tfDurationSeconds.setEnabled(false);
        this.tfDurationHour.setText("00");
        this.tfDurationMinutes.setText("00");
        this.tfDurationSeconds.setText("00");
        this.cbFavorite.setEnabled(false);
        this.tfPart.setEnabled(false);
        this.tfPart.setText("");
        this.tfRating.setEnabled(false);
        this.tfRating.setText("");
        this.tfAudioDesync.setText("");
        this.tfAudioDesync.setEnabled(false);
        this.tfHash.setText("");
        this.comboExportLevel.setSelectedItem(null);
        this.comboExportLevel.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.btnVlc.setEnabled(false);
        this.btnAddToDefaultPlaylist.setEnabled(false);
        this.btnResetExportLevel.setEnabled(false);
        this.btnCreateNewMovie.setEnabled(false);
        this.btnCreateSingleScenes.setEnabled(false);
        this.btnCreateMoviesFromNodes.setEnabled(false);
        this.btnDeleteFromDatabase.setEnabled(false);
        this.btnDeleteFromDisc.setEnabled(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.beanTreeView1 = new ScenerixxBeanTreeView();
        this.tfSearch = new JTextField();
        this.lbSearch = new JLabel();
        this.btnCreateNewMovie = new JButton();
        this.btnCreateSingleScenes = new JButton();
        this.btnCreateMoviesFromNodes = new JButton();
        this.btnVlc = new JButton();
        this.btnDeleteFromDatabase = new JButton();
        this.btnDeleteFromDisc = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.searchOptionsPanel = new JPanel();
        this.lbOrderBy = new JLabel();
        this.comboOrderBy = new JComboBox();
        this.comboFilter = new JComboBox();
        this.comboShowHideFilter = new JComboBox();
        this.panelShow = new JPanel();
        this.cbShowCounter = new JCheckBox();
        this.cbShowDirectory = new JCheckBox();
        this.lbShow = new JLabel();
        this.cbShowPosition = new JCheckBox();
        this.cbShowFileSize = new JCheckBox();
        this.toggleBtnMore = new JToggleButton();
        this.toggleBtnAsc = new JToggleButton();
        this.mediumFilePropertiesPanel = new JPanel();
        this.tfHeight = new JTextField();
        this.lbPart = new JLabel();
        this.lbAudioDesync = new JLabel();
        this.lbWidth = new JLabel();
        this.lbDuration = new JLabel();
        this.comboExportLevel = new JComboBox();
        this.lbRating = new JLabel();
        this.btnSave = new JButton();
        this.tfRating = new JTextField();
        this.tfDurationMinutes = new JTextField();
        this.tfWidth = new JTextField();
        this.lbExportlevel = new JLabel();
        this.tfPart = new JTextField();
        this.tfAudioDesync = new JTextField();
        this.tfDurationHour = new JTextField();
        this.btnResetExportLevel = new JButton();
        this.tfDurationSeconds = new JTextField();
        this.cbFavorite = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.tfHash = new JTextField();
        this.lbStatus = new JLabel();
        this.btnSelectRandomNode = new JButton();
        this.btnAddToDefaultPlaylist = new JButton();
        this.btnCreateNewInstance = new JButton();
        this.btnReload = new JButton();
        this.tfSearch.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MediumFileListTopComponent.this.tfSearchKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbSearch, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbSearch.text"));
        this.btnCreateNewMovie.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/film.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateNewMovie, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateNewMovie.text"));
        this.btnCreateNewMovie.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateNewMovie.toolTipText"));
        this.btnCreateNewMovie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnCreateNewMovieActionPerformed(evt);
            }
        });
        this.btnCreateSingleScenes.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Eye.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateSingleScenes, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateSingleScenes.text"));
        this.btnCreateSingleScenes.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateSingleScenes.toolTipText"));
        this.btnCreateSingleScenes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnCreateSingleScenesActionPerformed(evt);
            }
        });
        this.btnCreateMoviesFromNodes.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/movie.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateMoviesFromNodes, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateMoviesFromNodes.text"));
        this.btnCreateMoviesFromNodes.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateMoviesFromNodes.toolTipText"));
        this.btnCreateMoviesFromNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnCreateMoviesFromNodesActionPerformed(evt);
            }
        });
        this.btnVlc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnVlc, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnVlc.text"));
        this.btnVlc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnVlcActionPerformed(evt);
            }
        });
        this.btnDeleteFromDatabase.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Erase.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteFromDatabase, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnDeleteFromDatabase.text"));
        this.btnDeleteFromDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnDeleteFromDatabaseActionPerformed(evt);
            }
        });
        this.btnDeleteFromDisc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeleteFromDisc, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnDeleteFromDisc.text"));
        this.btnDeleteFromDisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnDeleteFromDiscActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbOrderBy, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbOrderBy.text"));
        this.comboOrderBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.comboOrderByActionPerformed(evt);
            }
        });
        this.comboFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.comboFilterActionPerformed(evt);
            }
        });
        this.comboShowHideFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.comboShowHideFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowCounter, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.cbShowCounter.text"));
        this.cbShowCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.cbShowCounterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowDirectory, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.cbShowDirectory.text"));
        this.cbShowDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.cbShowDirectoryActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbShow, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbShow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowPosition, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.cbShowPosition.text"));
        this.cbShowPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.cbShowPositionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowFileSize, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.cbShowFileSize.text"));
        this.cbShowFileSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.cbShowFileSizeActionPerformed(evt);
            }
        });
        GroupLayout panelShowLayout = new GroupLayout(this.panelShow);
        this.panelShow.setLayout(panelShowLayout);
        panelShowLayout.setHorizontalGroup(panelShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowLayout.createSequentialGroup().addContainerGap().addComponent(this.lbShow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowCounter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowFileSize).addContainerGap()));
        panelShowLayout.setVerticalGroup(panelShowLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelShowLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelShowLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowCounter).addComponent(this.cbShowDirectory).addComponent(this.cbShowPosition).addComponent(this.cbShowFileSize).addComponent(this.lbShow)).addContainerGap()));
        this.toggleBtnMore.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnMore, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.toggleBtnMore.text"));
        this.toggleBtnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.toggleBtnMoreActionPerformed(evt);
            }
        });
        this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_ascending.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnAsc, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.toggleBtnAsc.text"));
        this.toggleBtnAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.toggleBtnAscActionPerformed(evt);
            }
        });
        GroupLayout searchOptionsPanelLayout = new GroupLayout(this.searchOptionsPanel);
        this.searchOptionsPanel.setLayout(searchOptionsPanelLayout);
        searchOptionsPanelLayout.setHorizontalGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.toggleBtnAsc).addComponent(this.toggleBtnMore)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchOptionsPanelLayout.createSequentialGroup().addComponent(this.comboFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboShowHideFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbOrderBy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboOrderBy, -2, -1, -2)).addComponent(this.panelShow, -2, -1, -2)).addContainerGap(572, Short.MAX_VALUE)));
        searchOptionsPanelLayout.setVerticalGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchOptionsPanelLayout.createSequentialGroup().addGap(11, 11, 11).addGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toggleBtnAsc).addGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboFilter, -2, -1, -2).addComponent(this.comboShowHideFilter, -2, -1, -2).addComponent(this.lbOrderBy).addComponent(this.comboOrderBy, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelShow, -2, -1, -2).addComponent(this.toggleBtnMore)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.searchOptionsPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Search.png")), this.searchOptionsPanel);
        this.tfHeight.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfHeight.text"));
        this.tfHeight.setNextFocusableComponent(this.tfDurationHour);
        Mnemonics.setLocalizedText((JLabel)this.lbPart, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbPart.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbAudioDesync, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbAudioDesync.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbWidth, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbWidth.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbDuration, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbDuration.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbRating, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbRating.text"));
        this.btnSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/OK.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSave, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnSave.text"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnSaveActionPerformed(evt);
            }
        });
        this.tfRating.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfRating.text"));
        this.tfRating.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfRating.toolTipText"));
        this.tfDurationMinutes.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationMinutes.text"));
        this.tfDurationMinutes.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationMinutes.toolTipText"));
        this.tfDurationMinutes.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationMinutesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationMinutesFocusLost(evt);
            }
        });
        this.tfWidth.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfWidth.text"));
        this.tfWidth.setNextFocusableComponent(this.tfHeight);
        Mnemonics.setLocalizedText((JLabel)this.lbExportlevel, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbExportlevel.text"));
        this.tfPart.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfPart.text"));
        this.tfAudioDesync.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfAudioDesync.text"));
        this.tfDurationHour.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationHour.text"));
        this.tfDurationHour.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationHour.toolTipText"));
        this.tfDurationHour.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationHourFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationHourFocusLost(evt);
            }
        });
        this.btnResetExportLevel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnResetExportLevel, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnResetExportLevel.text"));
        this.btnResetExportLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnResetExportLevelActionPerformed(evt);
            }
        });
        this.tfDurationSeconds.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationSeconds.text"));
        this.tfDurationSeconds.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfDurationSeconds.toolTipText"));
        this.tfDurationSeconds.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationSecondsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MediumFileListTopComponent.this.tfDurationSecondsFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbFavorite, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.cbFavorite.text"));
        this.cbFavorite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.cbFavoriteActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.jLabel1.text"));
        this.tfHash.setEditable(false);
        this.tfHash.setText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.tfHash.text"));
        GroupLayout mediumFilePropertiesPanelLayout = new GroupLayout(this.mediumFilePropertiesPanel);
        this.mediumFilePropertiesPanel.setLayout(mediumFilePropertiesPanelLayout);
        mediumFilePropertiesPanelLayout.setHorizontalGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSave).addComponent(this.cbFavorite)).addGap(664, 664, 664)).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbAudioDesync).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfAudioDesync, -2, 42, -2).addComponent(this.tfHash, -1, 814, Short.MAX_VALUE))).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbWidth).addComponent(this.lbExportlevel).addComponent(this.lbDuration).addComponent(this.lbPart).addComponent(this.lbRating)).addGap(46, 46, 46).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addComponent(this.comboExportLevel, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResetExportLevel)).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addComponent(this.tfWidth, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfHeight, -2, 66, -2)).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tfDurationHour, GroupLayout.Alignment.LEADING, -2, 42, -2).addGroup(GroupLayout.Alignment.LEADING, mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tfRating, -2, 42, -2).addComponent(this.tfPart, -2, 42, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfDurationMinutes, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfDurationSeconds, -2, 42, -2))))).addContainerGap()))));
        mediumFilePropertiesPanelLayout.setVerticalGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediumFilePropertiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfWidth, -2, -1, -2).addComponent(this.lbWidth).addComponent(this.tfHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfDurationHour, -2, -1, -2).addComponent(this.tfDurationMinutes, -2, -1, -2).addComponent(this.tfDurationSeconds, -2, -1, -2).addComponent(this.lbDuration)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbPart).addComponent(this.tfPart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbRating).addComponent(this.tfRating, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbExportlevel).addComponent(this.comboExportLevel, -2, -1, -2).addComponent(this.btnResetExportLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbAudioDesync).addComponent(this.tfAudioDesync, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mediumFilePropertiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfHash, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFavorite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.mediumFilePropertiesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/film.png")), this.mediumFilePropertiesPanel);
        Mnemonics.setLocalizedText((JLabel)this.lbStatus, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.lbStatus.text"));
        this.btnSelectRandomNode.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/dice.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectRandomNode, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnSelectRandomNode.text"));
        this.btnSelectRandomNode.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnSelectRandomNode.toolTipText"));
        this.btnSelectRandomNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnSelectRandomNodeActionPerformed(evt);
            }
        });
        this.btnAddToDefaultPlaylist.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/notes.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddToDefaultPlaylist, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnAddToDefaultPlaylist.text"));
        this.btnAddToDefaultPlaylist.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnAddToDefaultPlaylist.toolTipText"));
        this.btnAddToDefaultPlaylist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnAddToDefaultPlaylistActionPerformed(evt);
            }
        });
        this.btnCreateNewInstance.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Create.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateNewInstance, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateNewInstance.text"));
        this.btnCreateNewInstance.setToolTipText(NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnCreateNewInstance.toolTipText"));
        this.btnCreateNewInstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnCreateNewInstanceActionPerformed(evt);
            }
        });
        this.btnReload.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(MediumFileListTopComponent.class, (String)"MediumFileListTopComponent.btnReload.text"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediumFileListTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnCreateNewInstance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectRandomNode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddToDefaultPlaylist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnVlc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch)).addComponent(this.jTabbedPane1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnCreateNewMovie).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreateSingleScenes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreateMoviesFromNodes)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.lbStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnDeleteFromDisc).addComponent(this.btnDeleteFromDatabase))).addComponent((Component)this.beanTreeView1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCreateNewMovie).addComponent(this.btnCreateSingleScenes).addComponent(this.btnCreateMoviesFromNodes).addComponent(this.btnDeleteFromDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDeleteFromDisc).addComponent(this.btnReload)).addComponent(this.lbStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.beanTreeView1, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSelectRandomNode, GroupLayout.Alignment.TRAILING).addComponent(this.btnAddToDefaultPlaylist).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lbSearch).addComponent(this.btnVlc))).addComponent(this.btnCreateNewInstance)).addGap(12, 12, 12).addComponent(this.jTabbedPane1, -2, -1, -2)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jScrollPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
    }

    private void btnCreateMoviesFromNodesActionPerformed(ActionEvent evt) {
        this.createMoviesFromNodes();
    }

    private void btnCreateSingleScenesActionPerformed(ActionEvent evt) {
        this.createSingleScenes();
    }

    private void btnCreateNewMovieActionPerformed(ActionEvent evt) {
        this.createNewMovie();
    }

    private void btnResetExportLevelActionPerformed(ActionEvent evt) {
        this.resetExportlevel();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        this.saveChanges();
    }

    private void tfDurationSecondsFocusLost(FocusEvent evt) {
        if (this.tfDurationSeconds.getText().isEmpty()) {
            this.tfDurationSeconds.setText("00");
        }
    }

    private void tfDurationSecondsFocusGained(FocusEvent evt) {
        if (this.tfDurationSeconds.getText().equals("00")) {
            this.tfDurationSeconds.setText("");
        }
    }

    private void tfDurationMinutesFocusLost(FocusEvent evt) {
        if (this.tfDurationMinutes.getText().isEmpty()) {
            this.tfDurationMinutes.setText("00");
        }
    }

    private void tfDurationMinutesFocusGained(FocusEvent evt) {
        if (this.tfDurationMinutes.getText().equals("00")) {
            this.tfDurationMinutes.setText("");
        }
    }

    private void tfDurationHourFocusLost(FocusEvent evt) {
        if (this.tfDurationHour.getText().isEmpty()) {
            this.tfDurationHour.setText("00");
        }
    }

    private void tfDurationHourFocusGained(FocusEvent evt) {
        if (this.tfDurationHour.getText().equals("00")) {
            this.tfDurationHour.setText("");
        }
    }

    private void btnVlcActionPerformed(ActionEvent evt) {
        this.startVlc();
    }

    private void tfSearchKeyReleased(KeyEvent evt) {
        List searchQueries = this.db.getEntityService().find((EntityPathBase)QSearchQuery.searchQuery1).filter(f -> f.tab.eq((Object)Tab.MediumFiles)).filter(f -> f.searchQuery.containsIgnoreCase(this.tfSearch.getText())).order(new Function[]{f -> f.dateOfCreation.desc()}).find(20L);
        LOG.info("found: " + searchQueries.size());
        this.autocompleter.getChoices().clear();
        this.autocompleter.getChoices().addAll(searchQueries);
        if (this.db.getScenerixxSettings().isSearchOnKeyPress() || evt.getKeyCode() == 10) {
            if (evt.getKeyCode() == 37 || evt.getKeyCode() == 39 || evt.getKeyCode() == 32) {
                LOG.finest("Cursor key or space pressed, skip search");
            } else {
                new UpdateSearchResultListWorker().execute();
            }
            if (this.tfSearch.getText().isEmpty()) {
                this.setName("Medium Files");
            } else {
                this.setName("Medium Files (" + this.tfSearch.getText() + ")");
                SearchQuery sq = new SearchQuery();
                sq.setSearchQuery(this.tfSearch.getText());
                sq.setTab(Tab.MediumFiles);
                this.db.getEntityService().save((AbstractEntity)sq);
            }
        }
    }

    private void btnDeleteFromDatabaseActionPerformed(ActionEvent evt) {
        this.deleteFromDatabase();
    }

    private void btnDeleteFromDiscActionPerformed(ActionEvent evt) {
        this.deleteFromDatabaseAndDisc();
    }

    private void cbShowDirectoryActionPerformed(ActionEvent evt) {
        this.toggleCbShowDirectory();
    }

    private void cbShowCounterActionPerformed(ActionEvent evt) {
        this.toggleCbShowCounter();
    }

    private void toggleCbShowCounter() {
        if (this.cbShowCounter.isSelected()) {
            this.cbShowCounter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/counter.png")));
        } else {
            this.cbShowCounter.setIcon(null);
        }
        this.reloadList();
    }

    private void toggleCbShowDirectory() {
        if (this.cbShowDirectory.isSelected()) {
            this.cbShowDirectory.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Folder.png")));
        } else {
            this.cbShowDirectory.setIcon(null);
        }
        this.reloadList();
    }

    private void cbShowPositionActionPerformed(ActionEvent evt) {
        this.togglePosition();
    }

    private void togglePosition() {
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        this.reloadList();
    }

    private void cbShowFileSizeActionPerformed(ActionEvent evt) {
        this.toggleCbFilesize();
    }

    private void toggleCbFilesize() {
        if (this.cbShowFileSize.isSelected()) {
            this.cbShowFileSize.setIcon(ImageUtilities.loadImageIcon((String)"icons.silk/compress.png", (boolean)false));
        } else {
            this.cbShowFileSize.setIcon(null);
        }
        this.reloadList();
    }

    private void btnSelectRandomNodeActionPerformed(ActionEvent evt) {
        this.selectRandomNode();
    }

    private void btnAddToDefaultPlaylistActionPerformed(ActionEvent evt) {
        this.addNodesToDefaultPlaylist();
    }

    private void btnCreateNewInstanceActionPerformed(ActionEvent evt) {
        MediumFileListTopComponent.openAnotherInstance();
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
    }

    private void comboOrderByActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void comboFilterActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void comboShowHideFilterActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void toggleBtnMoreActionPerformed(ActionEvent evt) {
        this.toggleShowMorePanel();
    }

    private void toggleBtnAscActionPerformed(ActionEvent evt) {
        this.toggleAsc();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void cbFavoriteActionPerformed(ActionEvent evt) {
        this.toggleFavoriteIcon();
    }

    private void toggleFavoriteIcon() {
        if (this.cbFavorite.isSelected()) {
            this.cbFavorite.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/favourites.png")));
        } else {
            this.cbFavorite.setIcon(null);
        }
    }

    public void setDirty() {
        this.setDirty(false);
    }

    public void setDirty(boolean clearList) {
        this.lbStatus.setVisible(true);
        this.lbStatus.setText("View might be out of sync!");
        this.btnReload.setVisible(true);
        if (clearList) {
            this.setRootContext(new ArrayList<MediumFile>());
        }
    }

    private void toggleAsc() {
        this.toggleBtnAsc.setText("");
        boolean bl = this.asc = !this.asc;
        if (this.asc) {
            this.toggleBtnAsc.setToolTipText("sort ascending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_ascending.png")));
        } else {
            this.toggleBtnAsc.setToolTipText("sort descending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_descending.png")));
        }
        this.reloadList();
    }

    private void toggleShowMorePanel() {
        this.toggleBtnMore.setText("");
        if (!this.panelShow.isVisible()) {
            this.toggleBtnMore.setToolTipText("Show Less");
            this.toggleBtnMore.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Remove.png")));
        } else {
            this.toggleBtnMore.setToolTipText("Show More...");
            this.toggleBtnMore.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        }
        this.panelShow.setVisible(!this.panelShow.isVisible());
    }

    public static MediumFileListTopComponent openAnotherInstance() {
        return MediumFileListTopComponent.openAnotherInstance("");
    }

    public static MediumFileListTopComponent openAnotherInstance(String title) {
        MediumFileListTopComponent mfTopComponent = new MediumFileListTopComponent(title);
        String name = "Medium Files (" + ++currentinstance + ")";
        if (!title.isEmpty()) {
            name = "Medium File (" + title + ")";
        }
        mfTopComponent.setName(name);
        mfTopComponent.open();
        mfTopComponent.requestActive();
        return mfTopComponent;
    }

    private void addNodesToDefaultPlaylist() {
        this.scenerixxCommon.addToDefaultPlaylist(this.em.getSelectedNodes());
        AbstractTopComponent.reloadPlaylist();
    }

    private void selectRandomNode() {
        Random rnd = new Random();
        int nextInt = rnd.nextInt(this.em.getRootContext().getChildren().getNodesCount());
        Node child = this.em.getRootContext().getChildren().getNodeAt(nextInt);
        if (child != null) {
            try {
                this.em.setSelectedNodes(new Node[]{child});
                this.beanTreeView1.expandNode(child);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void findDuplicatesByName() {
        List mediumFiles = this.db.getMediumFiles(Scenerixx.unlocked);
        HashMap x = new HashMap();
        for (MediumFile mf : mediumFiles) {
            if (!x.containsKey(mf.getFileName())) {
                x.put(mf.getFileName(), new ArrayList());
            }
            if (MediumFileService.isPicture((MediumFile)mf) && (this.pix || this.all)) {
                ((List)x.get(mf.getFileName())).add(mf);
                continue;
            }
            if (MediumFileService.isMovie((MediumFile)mf) && (this.mov || this.all)) {
                ((List)x.get(mf.getFileName())).add(mf);
                continue;
            }
            if (!this.all) continue;
            ((List)x.get(mf.getFileName())).add(mf);
        }
        ArrayList<MediumFile> result = new ArrayList<MediumFile>();
        for (Map.Entry next : x.entrySet()) {
            if (((List)next.getValue()).size() <= 1) continue;
            result.addAll((Collection)next.getValue());
        }
        Collections.sort(result, new Comparator<MediumFile>(this){

            @Override
            public int compare(MediumFile mf1, MediumFile mf2) {
                return mf1.getFileName().compareTo(mf2.getFileName());
            }
        });
        this.setRootContext(result);
    }

    private void findDuplicatesByHash() {
        List mediumFiles = this.db.getMediumFiles(Scenerixx.unlocked);
        HashMap x = new HashMap();
        for (MediumFile mf : mediumFiles) {
            if (mf.getHashValue() == null) continue;
            if (!x.containsKey(mf.getHashValue())) {
                x.put(mf.getHashValue(), new ArrayList());
            }
            if (MediumFileService.isPicture((MediumFile)mf) && (this.pix || this.all)) {
                ((List)x.get(mf.getHashValue())).add(mf);
                continue;
            }
            if (MediumFileService.isMovie((MediumFile)mf) && (this.mov || this.all)) {
                ((List)x.get(mf.getHashValue())).add(mf);
                continue;
            }
            if (!this.all) continue;
            ((List)x.get(mf.getHashValue())).add(mf);
        }
        ArrayList<MediumFile> result = new ArrayList<MediumFile>();
        for (Map.Entry next : x.entrySet()) {
            if (((List)next.getValue()).size() <= 1) continue;
            result.addAll((Collection)next.getValue());
        }
        this.setRootContext(result);
    }

    public Node selectMediumFileNode(MediumFile mf, boolean forceReload) {
        Node child = null;
        if (mf != null) {
            try {
                child = this.em.getRootContext().getChildren().findChild("" + mf.getId());
                if (child != null) {
                    this.em.setSelectedNodes(new Node[]{child});
                    this.beanTreeView1.expandNode(child);
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
        return child;
    }

    public Node selectMediumFileNode(MediumFile mf) {
        Node selectMovieNode = this.selectMediumFileNode(mf, false);
        return selectMovieNode;
    }

    public Node getNextNode() {
        return this.getNextNode(0);
    }

    public Node getNextNode(int offset) {
        Node nextNode = Node.EMPTY;
        Node[] selectedNodes = this.em.getSelectedNodes();
        if (selectedNodes.length > 0) {
            Children children = this.em.getRootContext().getChildren();
            int i = 0;
            for (Node n : children.getNodes()) {
                ++i;
                if (selectedNodes[selectedNodes.length - 1].equals((Object)n)) break;
            }
            if ((nextNode = this.em.getRootContext().getChildren().getNodeAt(i + offset)) == null && this.em.getRootContext().getChildren().getNodesCount() > 2) {
                nextNode = this.em.getRootContext().getChildren().getNodeAt(i - 2);
            }
        }
        return nextNode;
    }

    private void deleteFromDatabase() {
        if (this.em.getSelectedNodes().length > 0) {
            if (0 == JOptionPane.showConfirmDialog(null, "Do you really want to delete " + this.em.getSelectedNodes().length + " files from the database?", "Are you sure?", 0)) {
                Node nextNode = this.getNextNode();
                Node nextNextNode = this.getNextNode(1);
                try {
                    for (Node node : this.em.getSelectedNodes()) {
                        MediumFile mf = (MediumFile)node.getValue("mediumFile");
                        boolean tryAgain = false;
                        if (mf.getMovie() != null) {
                            AbstractTopComponent.notifyError("'" + mf.getFileCompletePath() + "' is associated to '" + mf.getMovie().getTitle() + "' and thus cannot be deleted.");
                            tryAgain = true;
                        } else if (!this.db.deleteMediumFile(mf, false)) {
                            AbstractTopComponent.notifyError("'" + mf.getFileCompletePath() + "' is still associated to an entity and thus cannot be deleted.");
                            tryAgain = true;
                        }
                        if (!tryAgain || 0 != JOptionPane.showConfirmDialog(null, "'" + mf.getFileCompletePath() + "' is still associated to an entity and thus cannot be deleted. \nShould we try to dissolve those associations and try again?", "Try again?", 0)) continue;
                        if (!this.db.deleteMediumFile(mf, true)) {
                            AbstractTopComponent.notifyError("We need to talk! Seriously: I'm still not able to delete this file. Please send the error message you find under 'Tools / IDE Log' to me via Discord or mail so that this can get resolved.");
                            continue;
                        }
                        AbstractTopComponent.notifyInfo("Fine. Everythings gone. At least this one file.");
                    }
                    this.reloadList();
                    if (nextNode != null && (MediumFile)nextNode.getValue("mediumFile") != null) {
                        LOG.fine("try to select next node");
                        Node selectMediumFileNode = this.selectMediumFileNode((MediumFile)nextNode.getValue("mediumFile"));
                        if (selectMediumFileNode == null) {
                            LOG.fine("we did not succeed, try the node after next");
                            this.selectMediumFileNode((MediumFile)nextNextNode.getValue("mediumFile"));
                        }
                    }
                }
                catch (Exception ex) {
                    AbstractTopComponent.notifyError("An error occured while trying to delete the file(s) from the database: " + ex.getMessage());
                    LOG.warning(ex.getMessage());
                }
            }
        } else {
            AbstractTopComponent.notifyWarning("No file to delete selected");
        }
    }

    private void deleteFromDatabaseAndDisc() {
        if (this.em.getSelectedNodes().length > 0) {
            long fileSize = 0L;
            for (Node node : this.em.getSelectedNodes()) {
                MediumFile mf = (MediumFile)node.getValue("mediumFile");
                if (mf == null) continue;
                fileSize += mf.getFileSize().longValue();
            }
            if (0 == JOptionPane.showConfirmDialog(null, "Do you really want to delete " + this.em.getSelectedNodes().length + " files [" + ScenerixxCommon.readableFileSize(fileSize) + "] from database and disc?", "Are you sure?", 0)) {
                Node nextNode = this.getNextNode();
                Node nextNextNode = this.getNextNode(1);
                this.lbStatus.setVisible(true);
                this.lbStatus.setText("Start deleting...");
                DeleteFromDiscWorker deleteFormDiscWorker = new DeleteFromDiscWorker();
                deleteFormDiscWorker.execute();
                deleteFormDiscWorker.setNextNode(nextNode);
                deleteFormDiscWorker.setNextNextNode(nextNextNode);
            }
        } else {
            AbstractTopComponent.notifyError("No file to delete selected");
        }
    }

    private DB.OrderBy getOrderBy() {
        DB.OrderBy orderBy = DB.OrderBy.TITLE;
        if (OrderByMediumFile.Name.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.TITLE;
        } else if (OrderByMediumFile.FileExtension.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.FILEEXTENSION;
        } else if (OrderByMediumFile.FileSize.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.FILESIZE;
        } else if (OrderByMediumFile.LastModification.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.LASTMODIFICATION;
        } else if (OrderByMediumFile.DateOfCreation.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.CREATED;
        } else if (OrderByMediumFile.Resolution.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.RESOLUTION;
        } else if (OrderByMediumFile.Runtime.equals(this.comboOrderBy.getSelectedItem())) {
            orderBy = DB.OrderBy.RUNTIME;
        }
        return orderBy;
    }

    public void createNewMovie(List<MediumFile> mediumFiles) {
        Movie newMovie = new Movie();
        if (mediumFiles.isEmpty()) {
            newMovie.setTitle("[New Movie]");
            LOG.info("No medium file provided");
        } else {
            newMovie.setTitle(mediumFiles.get(0).getFileName());
        }
        newMovie = (Movie)this.db.getEntityService().save((AbstractEntity)newMovie);
        boolean noHashValue = false;
        for (MediumFile mf : mediumFiles) {
            if (mf.getHashValue() != null) continue;
            noHashValue = true;
        }
        if (noHashValue) {
            TopComponent indexingTC = WindowManager.getDefault().findTopComponent("IndexingTopComponent");
            if (indexingTC != null) {
                if (JOptionPane.showConfirmDialog(null, "At least one medium file has no hash value yet, thus no movie could be created. Should we now start hashing?", "Start hashing?", 0) == 0) {
                    indexingTC.requestActive();
                    ((IndexingTopComponent)indexingTC).startHashing();
                }
            } else {
                JOptionPane.showMessageDialog(null, "At least one medium file has no hash value yet, thus no movie could be created.", "Unhashed files found", 0);
            }
        } else {
            TopComponent detailTopComponent;
            for (MediumFile mf : mediumFiles) {
                this.scenerixxCommon.addMediumFileToMovie(mf, newMovie);
            }
            this.scenerixxCommon.askHowManyScenesShouldBeCreated(newMovie, false);
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).reloadList();
                ((MovieListTopComponent)movieList).selectMovieNode(newMovie);
            }
            if ((detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent")) != null) {
                detailTopComponent.requestActive();
                ((DetailsTopComponent)detailTopComponent).loadMovie(newMovie);
                ((DetailsTopComponent)detailTopComponent).focusNameTextField();
            }
        }
    }

    private void createSingleScenes() {
        String titlePrefix = JOptionPane.showInputDialog("Should the movie title be prefixed?\nMovie titles which match the prefix already won't be prefixed again (a trailing ' - ' will be ignored). \n\nIf you have: 'Nicole Clitman solo.avi' and 'Nicole C. - solo2.avi'\nand you specify as a prefix 'Nicole Clitman - ' the result would be:\n'Nicole Clitman solo.avi' and 'Nicole Clitman - Nicole C. - solo2.avi'\n\nIf you don't wan't to use a prefix just leave the field empty and press OK");
        if (titlePrefix != null) {
            new CreateSingleScenesWorker(titlePrefix).execute();
        }
    }

    private void createMoviesFromNodes() {
        new CreateMoviesWorker().execute();
    }

    private void createNewMovie() {
        ArrayList<MediumFile> mf = new ArrayList<MediumFile>();
        for (Node n : this.em.getSelectedNodes()) {
            mf.add((MediumFile)n.getValue("mediumFile"));
        }
        this.createNewMovie(mf);
    }

    private void resetExportlevel() {
        ((MediumFile)this.em.getSelectedNodes()[0].getValue("mediumFile")).setExportLevel(null);
        this.db.getEntityService().save((AbstractEntity)((MediumFile)this.em.getSelectedNodes()[0].getValue("mediumFile")));
        this.comboExportLevel.setSelectedItem(null);
    }

    private void saveChanges() {
        if (this.tfDurationHour.getText().length() > 2 || this.tfDurationMinutes.getText().length() > 2 || this.tfDurationSeconds.getText().length() > 2) {
            JOptionPane.showMessageDialog(null, "You entered in one of the duration fields a number with more than two digits.", "Please correct your input", 0);
        } else {
            int duration;
            MediumFile currentMediumFile;
            Object failedFields;
            block27: {
                failedFields = "";
                currentMediumFile = (MediumFile)this.em.getSelectedNodes()[0].getValue("mediumFile");
                if (this.tfHeight.getText().isEmpty()) {
                    currentMediumFile.setHeight(null);
                } else {
                    try {
                        currentMediumFile.setHeight(Integer.valueOf(Integer.parseInt(this.tfHeight.getText())));
                    }
                    catch (NumberFormatException nfe) {
                        failedFields = (String)failedFields + " height ";
                    }
                }
                if (this.tfWidth.getText().isEmpty()) {
                    currentMediumFile.setWidth(null);
                } else {
                    try {
                        currentMediumFile.setWidth(Integer.valueOf(Integer.parseInt(this.tfWidth.getText())));
                    }
                    catch (NumberFormatException nfe) {
                        failedFields = (String)failedFields + " width ";
                    }
                }
                currentMediumFile.setFavorite(this.cbFavorite.isSelected());
                try {
                    currentMediumFile.setPart(Integer.parseInt(this.tfPart.getText()));
                }
                catch (NumberFormatException nfe) {
                    failedFields = (String)failedFields + " part ";
                }
                if (this.tfRating.getText().isEmpty()) {
                    currentMediumFile.setRating(null);
                } else {
                    try {
                        currentMediumFile.setRating(Integer.valueOf(Integer.parseInt(this.tfRating.getText())));
                    }
                    catch (NumberFormatException nfe) {
                        if (this.tfRating.getText().isEmpty()) break block27;
                        failedFields = (String)failedFields + " rating ";
                    }
                }
            }
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            if (!this.tfDurationHour.getText().isEmpty()) {
                hours = ScenerixxCommon.parseInt(this.tfDurationHour.getText());
            }
            if (!this.tfDurationMinutes.getText().isEmpty()) {
                minutes = ScenerixxCommon.parseInt(this.tfDurationMinutes.getText());
            }
            if (!this.tfDurationSeconds.getText().isEmpty()) {
                seconds = ScenerixxCommon.parseInt(this.tfDurationSeconds.getText());
            }
            if ((duration = (hours * 60 * 60 + minutes * 60 + seconds) * 1000) > 0) {
                currentMediumFile.setDuration(Integer.valueOf(duration));
            } else {
                currentMediumFile.setDuration(null);
            }
            if (!this.tfAudioDesync.getText().isEmpty()) {
                try {
                    currentMediumFile.setDesyncAudio(Integer.valueOf(Integer.parseInt(this.tfAudioDesync.getText())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.comboExportLevel.getSelectedItem() != null) {
                LOG.info("export level: " + ((ExportLevel)this.comboExportLevel.getSelectedItem()).getLevel());
                currentMediumFile.setExportLevel(Integer.valueOf(((ExportLevel)this.comboExportLevel.getSelectedItem()).getLevel()));
            }
            this.db.getEntityService().save((AbstractEntity)currentMediumFile);
            if (!((String)failedFields).isEmpty()) {
                JOptionPane.showMessageDialog(null, "The following fields were not saved because of an invalid number was provided: " + (String)failedFields, "Warning", 2);
            }
            this.reloadList(this.em.getSelectedNodes()[0]);
            if (this.em.getSelectedNodes().length == 0) {
                this.disableEditComponents();
            }
        }
    }

    public void reloadList() {
        Node[] selectedNodes = this.em.getSelectedNodes();
        if (selectedNodes.length > 0) {
            this.reloadList(selectedNodes[0]);
        } else {
            this.reloadList(null);
        }
    }

    public void search(String searchterm) {
        this.comboFilter.setSelectedItem(MediumFileTypeFilter.All);
        this.tfSearch.setText(searchterm);
        this.reloadList();
    }

    public void reloadList(Node node) {
        if (!this.initialized) {
            return;
        }
        boolean hideNothing = false;
        boolean hideFilesAssociated = false;
        boolean hideDurationKnown = false;
        boolean hideHashKnown = false;
        boolean showDuplicatesByName = false;
        this.showDuplicatesByHash = false;
        if (MediumFileShowHideFilter.DoNotHide.equals(this.comboShowHideFilter.getSelectedItem())) {
            hideNothing = true;
        } else if (MediumFileShowHideFilter.HideFilesAssociated.equals(this.comboShowHideFilter.getSelectedItem())) {
            hideFilesAssociated = true;
        } else if (MediumFileShowHideFilter.HideFilesDurationKnown.equals(this.comboShowHideFilter.getSelectedItem())) {
            hideDurationKnown = true;
        } else if (MediumFileShowHideFilter.HideFilesHashKnown.equals(this.comboShowHideFilter.getSelectedItem())) {
            hideHashKnown = true;
        } else if (MediumFileShowHideFilter.ShowDuplicatesByName.equals(this.comboShowHideFilter.getSelectedItem())) {
            showDuplicatesByName = true;
        } else if (MediumFileShowHideFilter.ShowDuplicatesByHash.equals(this.comboShowHideFilter.getSelectedItem())) {
            this.showDuplicatesByHash = true;
        }
        DB.OrderBy orderby = this.getOrderBy();
        if (DB.OrderBy.FILESIZE.equals((Object)orderby)) {
            this.cbShowFileSize.setSelected(true);
        }
        this.all = false;
        this.mov = false;
        this.pix = false;
        this.unknown = false;
        if (MediumFileTypeFilter.All.equals(this.comboFilter.getSelectedItem())) {
            this.all = true;
        } else if (MediumFileTypeFilter.Movies.equals(this.comboFilter.getSelectedItem())) {
            this.mov = true;
        } else if (MediumFileTypeFilter.Pictures.equals(this.comboFilter.getSelectedItem())) {
            this.pix = true;
        } else if (MediumFileTypeFilter.Unknown.equals(this.comboFilter.getSelectedItem())) {
            this.unknown = true;
        }
        this.toggleOrderByFields(true);
        if (this.tfSearch.getText().isEmpty()) {
            this.setName("Medium Files");
        } else {
            this.setName("Medium Files (" + this.tfSearch.getText() + ")");
        }
        this.tfSearch.setEnabled(true);
        this.tfSearch.setVisible(true);
        this.lbSearch.setVisible(true);
        if (hideDurationKnown) {
            this.setRootContext(this.db.getMediumFilesWithoutDuration(this.tfSearch.getText(), Scenerixx.unlocked));
        } else if (hideFilesAssociated) {
            this.setRootContext(this.db.getMediumFiles(this.tfSearch.getText(), this.mov, this.pix, hideFilesAssociated, Scenerixx.unlocked, orderby, this.unknown));
        } else if (hideHashKnown) {
            this.setRootContext(this.db.getMediumFiles(this.tfSearch.getText(), this.mov, this.pix, hideFilesAssociated, hideHashKnown, Scenerixx.unlocked, orderby, this.unknown));
        } else if (showDuplicatesByName) {
            this.toggleOrderByFields(false);
            this.tfSearch.setEnabled(false);
            this.tfSearch.setVisible(false);
            this.lbSearch.setVisible(false);
            this.findDuplicatesByName();
            SwingUtilities.invokeLater(() -> this.setName("Medium Files (duplicates by name)"));
        } else if (this.showDuplicatesByHash) {
            this.toggleOrderByFields(false);
            this.tfSearch.setEnabled(false);
            this.tfSearch.setVisible(false);
            this.lbSearch.setVisible(false);
            this.findDuplicatesByHash();
            SwingUtilities.invokeLater(() -> this.setName("Medium Files (duplicates by hash)"));
        } else {
            this.setRootContext(this.db.getMediumFiles(this.tfSearch.getText(), this.mov, this.pix, hideFilesAssociated, Scenerixx.unlocked, orderby, this.unknown));
        }
        if (node != null && !node.equals((Object)Node.EMPTY)) {
            try {
                Node findChild = this.em.getRootContext().getChildren().findChild(node.getName());
                if (findChild != null) {
                    this.em.setSelectedNodes(new Node[]{findChild});
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notify("An error occured: " + ex.getMessage(), ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
            }
        }
        if (this.em.getRootContext().getChildren().getNodesCount() == 0 && this.tfSearch.getText().length() == 40 && !this.tfSearch.getText().contains(" ")) {
            LOG.info("Trying to search for a hash: " + this.tfSearch.getText());
            this.setRootContext(this.db.getMediumFilesByHash(this.tfSearch.getText()));
        }
        this.lbStatus.setText("");
        this.lbStatus.setVisible(false);
        this.btnReload.setVisible(false);
    }

    public void toggleOrderByFields(boolean state) {
        this.lbOrderBy.setVisible(state);
        this.comboOrderBy.setVisible(state);
    }

    private void setRootContext(List<MediumFile> mediumFiles) {
        if (!this.asc) {
            Collections.reverse(mediumFiles);
        }
        this.em.setRootContext((Node)new AbstractNode(this, Children.create((ChildFactory)new MediumFileChildFactory(mediumFiles, this.cbShowCounter.isSelected(), this.cbShowDirectory.isSelected(), this.cbShowPosition.isSelected(), this.cbShowFileSize.isSelected(), this.showDuplicatesByHash, this.tfSearch.getText()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                MediumFileListTopComponent.this.reloadList(node);
            }
        }, (boolean)false)){

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/film.png");
            }

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/film.png");
            }
        });
        this.em.getRootContext().setDisplayName("MediumFiles [" + mediumFiles.size() + "]");
    }

    public void startVlc() {
        if (this.em.getSelectedNodes().length > 0) {
            try {
                MediumFile mf = (MediumFile)this.em.getSelectedNodes()[0].getValue("mediumFile");
                if (this.em.getSelectedNodes().length == 1 && mf.getFileName().toLowerCase().contains("cd1")) {
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
                    paras.add(mf.getFileCompletePath());
                    int oldIndex = 1;
                    int newIndex = 2;
                    String tmpString = mf.getFileCompletePath().replaceAll("CD" + oldIndex, "CD" + newIndex);
                    File f = new File(tmpString);
                    while (f.exists()) {
                        paras.add(tmpString);
                        tmpString = tmpString.replaceAll("CD" + ++oldIndex, "CD" + ++newIndex);
                        f = new File(tmpString);
                    }
                    String[] tmpParas = paras.toArray(new String[paras.size()]);
                    Runtime.getRuntime().exec(tmpParas);
                } else {
                    boolean allVids = true;
                    boolean allAssociated = true;
                    for (Node n : this.em.getSelectedNodes()) {
                        if (!MediumFileService.isMovie((MediumFile)((MediumFile)n.getValue("mediumFile")))) {
                            allVids = false;
                        }
                        if (((MediumFile)n.getValue("mediumFile")).getMovie() != null) continue;
                        allAssociated = false;
                    }
                    if (allAssociated && allVids) {
                        Playlist tmpPlaylist = new Playlist();
                        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                        if (movieList != null) {
                            for (Node n : this.em.getSelectedNodes()) {
                                Movie movie = ((MediumFile)n.getValue("mediumFile")).getMovie();
                                PlaylistEntry pe = new PlaylistEntry();
                                pe.setMovie(movie);
                                tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                            }
                            ((MovieListTopComponent)movieList).openVlc(tmpPlaylist, true, false);
                        }
                    } else if (allVids) {
                        paras = new ArrayList<Object>();
                        paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
                        for (Node n : this.em.getSelectedNodes()) {
                            paras.add(((MediumFile)n.getValue("mediumFile")).getFileCompletePath());
                        }
                        String[] tmpParas = paras.toArray(new String[paras.size()]);
                        Runtime.getRuntime().exec(tmpParas);
                    } else if (MediumFileService.isMovie((MediumFile)mf)) {
                        paras = new ArrayList();
                        paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
                        paras.add(mf.getFileCompletePath());
                        String[] tmpParas = paras.toArray(new String[paras.size()]);
                        Runtime.getRuntime().exec(tmpParas);
                    } else {
                        Desktop.getDesktop().open(new File(mf.getFileCompletePath()));
                    }
                }
                this.db.updateStatistic(mf);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public class UpdateSearchResultListWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            String org = new String(MediumFileListTopComponent.this.tfSearch.getText());
            Thread.sleep(100L);
            if (MediumFileListTopComponent.this.tfSearch.getText().equals(org)) {
                Thread.sleep(500L);
                if (MediumFileListTopComponent.this.tfSearch.getText().equals(org)) {
                    LOG.fine("Searchterms: " + MediumFileListTopComponent.this.tfSearch.getText());
                    MediumFileListTopComponent.this.reloadList(Node.EMPTY);
                }
            }
            return "";
        }
    }

    public class DeleteFromDiscWorker
    extends SwingWorker<String, String> {
        private Node nextNode;
        private Node nextNextNode;

        public void setNextNode(Node nextNode) {
            this.nextNode = nextNode;
        }

        public void setNextNextNode(Node nextNextNode) {
            this.nextNextNode = nextNextNode;
        }

        @Override
        protected void done() {
            Object object;
            super.done();
            MediumFileListTopComponent.this.lbStatus.setText("Finished deleting");
            MediumFileListTopComponent.this.lbStatus.setVisible(false);
            MediumFileListTopComponent.this.reloadList();
            if (this.nextNode != null && this.nextNode.getValue("mediumFile") != null && (object = this.nextNode.getValue("mediumFile")) instanceof MediumFile) {
                MediumFile selectMediumFileNode = (MediumFile)object;
                LOG.info("Trying to select next node");
                if (selectMediumFileNode == null) {
                    LOG.fine("May try it with the next node after");
                    MediumFileListTopComponent.this.selectMediumFileNode((MediumFile)this.nextNextNode.getValue("mediumFile"));
                }
            } else {
                LOG.info("No next node to select available");
            }
        }

        @Override
        protected String doInBackground() throws Exception {
            try {
                for (Node node : MediumFileListTopComponent.this.em.getSelectedNodes()) {
                    MediumFile mf = (MediumFile)node.getValue("mediumFile");
                    this.publish(mf.getFileCompletePath());
                    if (mf.getMovie() != null) {
                        AbstractTopComponent.notify("'" + mf.getFileCompletePath() + "' is associated to '" + mf.getMovie().getTitle() + "' and thus cannot be deleted.", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                        continue;
                    }
                    if (!MediumFileListTopComponent.this.db.deleteMediumFile(mf, false)) {
                        AbstractTopComponent.notify("'" + mf.getFileCompletePath() + "' is still associated to an entity and thus cannot be deleted.", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                    }
                    File f = new File(mf.getFileCompletePath());
                    long fSize = f.length();
                    boolean deleted = f.delete();
                    if (!deleted) {
                        AbstractTopComponent.notify("File '" + mf.getFileCompletePath() + "' could not be deleted from dics! File was not found. We just removed it from the database.", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                        continue;
                    }
                    DeletedMedium dm = new DeletedMedium();
                    dm.setHashValue(mf.getHashValue());
                    MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)dm);
                    StatisticInternal stats = (StatisticInternal)MediumFileListTopComponent.this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{g -> g.dateOfCreation.desc()}).findFirst();
                    if (stats == null) {
                        stats = new StatisticInternal();
                    }
                    stats.setSavedBytes(stats.getSavedBytes() + fSize);
                    MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)stats);
                    MediumFileListTopComponent.this.scenerixxCommon.checkEmptyDirectoryAndDeleteIfWanted(mf);
                }
            }
            catch (Exception ex) {
                AbstractTopComponent.notifyError("An error occured while trying to delete the file(s): " + ex.getMessage());
                LOG.warning(ex.getMessage());
            }
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                MediumFileListTopComponent.this.lbStatus.setText("Deleting: " + s);
            }
        }
    }

    public class CreateSingleScenesWorker
    extends SwingWorker<String, String> {
        private String titlePrefix;
        private Movie newMovie = null;
        private int unhashedFiles = 0;

        public CreateSingleScenesWorker(String prefix) {
            this.titlePrefix = prefix;
        }

        @Override
        protected String doInBackground() throws Exception {
            for (Node n : MediumFileListTopComponent.this.em.getSelectedNodes()) {
                MediumFile mf = (MediumFile)n.getValue("mediumFile");
                if (mf.getHashValue() != null) {
                    this.newMovie = new Movie();
                    String prefix = this.titlePrefix.toLowerCase().trim();
                    while (prefix.endsWith("-")) {
                        prefix = prefix.substring(0, prefix.length() - 2);
                    }
                    prefix = prefix.trim();
                    String filename = mf.getFileName().toLowerCase();
                    if (!filename.startsWith(prefix)) {
                        this.newMovie.setTitle(this.titlePrefix + mf.getFileName());
                    } else {
                        this.newMovie.setTitle(mf.getFileName());
                    }
                    this.newMovie = (Movie)MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)this.newMovie);
                    MediumFileListTopComponent.this.scenerixxCommon.addMediumFileToMovie(mf, this.newMovie, false, false);
                    Scene newScene = new Scene();
                    newScene.setDateOfCreation(LocalDateTime.now());
                    newScene.setPos(1);
                    newScene.setMovie(this.newMovie);
                    MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)newScene);
                    this.newMovie.getScenes().add(newScene);
                    this.newMovie = (Movie)MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)this.newMovie);
                    this.publish("Created a single scene for '" + this.newMovie.getTitle() + "'");
                    continue;
                }
                ++this.unhashedFiles;
            }
            return "";
        }

        @Override
        protected void done() {
            super.done();
            if (this.unhashedFiles != 0) {
                TopComponent indexingTC = WindowManager.getDefault().findTopComponent("IndexingTopComponent");
                if (indexingTC != null) {
                    if (JOptionPane.showConfirmDialog(null, "For " + this.unhashedFiles + " files no scene was created because the file was not hashed yet. Should we now start hashing?", "Start hashing?", 0) == 0) {
                        indexingTC.requestActive();
                        ((IndexingTopComponent)indexingTC).startHashing();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "For " + this.unhashedFiles + " files no scene was created because the file was not hashed yet.", "Unhashed files found", 0);
                }
            }
            if (this.newMovie != null) {
                MediumFileListTopComponent.this.reloadList();
                SwingUtilities.invokeLater(() -> {
                    TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                    if (movieList != null) {
                        ((MovieListTopComponent)movieList).reloadList();
                        SwingUtilities.invokeLater(() -> {
                            ((MovieListTopComponent)movieList).selectMovieNodeForceRefresh(this.newMovie);
                            TopComponent detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                            if (detailTopComponent != null && this.newMovie != null) {
                                LOG.info("Load now " + this.newMovie.getTitle());
                                ((DetailsTopComponent)detailTopComponent).loadMovie(this.newMovie);
                                ((DetailsTopComponent)detailTopComponent).focusNameTextField();
                            }
                        });
                    }
                });
            }
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                MediumFileListTopComponent.this.lbStatus.setText(s);
            }
        }
    }

    public class CreateMoviesWorker
    extends SwingWorker<String, String> {
        private Movie newMovie = null;
        private int unhashedFiles = 0;

        @Override
        protected String doInBackground() throws Exception {
            for (Node n : MediumFileListTopComponent.this.em.getSelectedNodes()) {
                MediumFile mf = (MediumFile)n.getValue("mediumFile");
                if (mf.getHashValue() != null) {
                    this.newMovie = new Movie();
                    this.newMovie.setTitle(mf.getFileName());
                    this.newMovie = (Movie)MediumFileListTopComponent.this.db.getEntityService().save((AbstractEntity)this.newMovie);
                    MediumFileListTopComponent.this.scenerixxCommon.addMediumFileToMovie(mf, this.newMovie, false, false);
                    this.publish("Created a movie for '" + this.newMovie.getTitle() + "'");
                    LOG.info("Created a movie for '" + this.newMovie.getTitle() + "'");
                    continue;
                }
                ++this.unhashedFiles;
            }
            return "";
        }

        @Override
        protected void done() {
            super.done();
            if (this.unhashedFiles != 0) {
                TopComponent indexingTC = WindowManager.getDefault().findTopComponent("IndexingTopComponent");
                if (indexingTC != null) {
                    if (JOptionPane.showConfirmDialog(null, "For " + this.unhashedFiles + " files no movie was created because the file was not hashed yet. Should we now start hashing?", "Start hashing?", 0) == 0) {
                        indexingTC.requestActive();
                        ((IndexingTopComponent)indexingTC).startHashing();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "For " + this.unhashedFiles + " files no movie was created because the file was not hashed yet.", "Unhashed files found", 0);
                }
            }
            MediumFileListTopComponent.this.reloadList();
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).reloadList();
                SwingUtilities.invokeLater(() -> {
                    LOG.info("Going to select: " + this.newMovie.getNameOfPlayable());
                    ((MovieListTopComponent)movieList).selectMovieNodeForceRefresh(this.newMovie);
                    TopComponent detailTopComponent = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                    if (detailTopComponent != null && this.newMovie != null) {
                        ((DetailsTopComponent)detailTopComponent).loadMovie(this.newMovie);
                        ((DetailsTopComponent)detailTopComponent).focusNameTextField();
                    }
                });
            }
        }

        @Override
        protected void process(List<String> item) {
            LOG.info("publish");
            for (String s : item) {
                MediumFileListTopComponent.this.lbStatus.setText(s);
                LOG.info("publish :" + s);
            }
        }
    }
}

