/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene.action;

import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddPersonsFromClipboardPanel;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.CreatePersonsPanel;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.CreatePersonsRowPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class AddPersonsFromClipboardAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();
    private static final Logger LOG = Logger.getLogger(AddPersonsFromClipboardAction.class.getName());

    public AddPersonsFromClipboardAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 192));
        Image image = ImageUtilities.loadImage((String)"icons/persons.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/add_task2.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    /*
     * WARNING - void declaration
     */
    public void performAction(Node[] activatedNodes) {
        boolean termIsMissing = false;
        try {
            String searchTerm = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            LOG.info("clipboard: " + searchTerm);
            searchTerm = searchTerm.trim();
            ArrayList<Person> result = this.db.getPersons(Scenerixx.unlocked);
            ArrayList tmpResult = new ArrayList(result);
            ArrayList<String> missingTerms = new ArrayList<String>();
            String delimiter = null;
            int cntRequestedPersond = 0;
            if (searchTerm.contains("&")) {
                delimiter = "&";
                searchTerm = searchTerm.replaceAll(",", "&");
                searchTerm = StringUtils.replaceIgnoreCase((String)searchTerm, (String)" and ", (String)"&");
            } else if (searchTerm.toLowerCase().contains(" and ")) {
                delimiter = " and ";
                searchTerm = searchTerm.replaceAll("&", " and ");
                searchTerm = searchTerm.replaceAll(",", " and ");
                searchTerm = StringUtils.replaceIgnoreCase((String)searchTerm, (String)" and ", (String)" and ");
            } else if (searchTerm.contains(",")) {
                delimiter = ",";
                searchTerm = searchTerm.replaceAll("&", ",");
                searchTerm = StringUtils.replaceIgnoreCase((String)searchTerm, (String)" and ", (String)",");
            }
            if (delimiter != null) {
                ArrayList<Person> toKeep = new ArrayList<Person>();
                String[] searchTerms = searchTerm.split(delimiter);
                cntRequestedPersond = searchTerms.length;
                for (String string : searchTerms) {
                    if (string.trim().isEmpty()) continue;
                    ArrayList tmpResult2 = new ArrayList(tmpResult);
                    result = new ArrayList<Person>(tmpResult);
                    String[] split = string.trim().split(" ");
                    for (Person person : tmpResult2) {
                        if (!this.db.containsSearchTerm(split, person, true)) {
                            result.remove(person);
                            continue;
                        }
                        toKeep.add(person);
                    }
                }
                result.clear();
                result.addAll(toKeep);
                for (String string : searchTerms) {
                    boolean found = false;
                    for (Person p : toKeep) {
                        if (!p.getName().trim().toLowerCase().contains(string.trim().toLowerCase())) continue;
                        found = true;
                    }
                    if (found) continue;
                    termIsMissing = true;
                    missingTerms.add(string.trim());
                    LOG.info("Could not find the search term " + string);
                }
            } else {
                cntRequestedPersond = 1;
                String[] split = new String[]{searchTerm};
                for (Person p : tmpResult) {
                    if (this.db.containsSearchTerm(split, p)) continue;
                    result.remove(p);
                }
            }
            for (Node n : activatedNodes) {
                Object object;
                if (n.getValue("scene") == null || !((object = n.getValue("scene")) instanceof Scene)) continue;
                Scene scene = (Scene)object;
                scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                if (result.size() == cntRequestedPersond && !termIsMissing) {
                    LOG.info("Names match exactly");
                    for (String[] p : result) {
                        scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                        LOG.info("found " + p.getName());
                        this.db.addPersonToScene((Person)p, scene);
                    }
                    this.updateView();
                    continue;
                }
                if (result.size() > cntRequestedPersond && !termIsMissing) {
                    LOG.info("Some names are ambiguous");
                    this.showPersonToAddDialog(result, searchTerm, delimiter, scene);
                    continue;
                }
                if ((result.size() < cntRequestedPersond || termIsMissing) && delimiter != null) {
                    void var14_27;
                    String string = "";
                    for (String string2 : searchTerm.split(delimiter)) {
                        boolean found = false;
                        for (Person p : result) {
                            LOG.info("Checking " + p.getName());
                            if (!p.getName().toLowerCase().contains(string2.trim().toLowerCase())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        String string3 = " " + (String)var14_27 + " - " + string2;
                        LOG.info(string2 + " not found");
                    }
                    if (termIsMissing) {
                        Object[] options = new String[]{"Search aliases", "Create person(s)", "Forget it"};
                        int resultMissingPerson = JOptionPane.showOptionDialog(null, "<html>Shoot! We are missing: " + (String)var14_27 + "<br> Either we search in the aliases (takes quite some time). Or we create a new person.<br>What do you want to do?</html>", "Cannot find person(s)", 1, 3, null, options, options[0]);
                        if (resultMissingPerson == 0) {
                            boolean foundAll = true;
                            for (String term2 : missingTerms) {
                                List personsWithAlias = this.db.getPersons(true, term2, Scenerixx.unlocked);
                                if (!personsWithAlias.isEmpty()) {
                                    result.addAll(personsWithAlias);
                                    LOG.info("searchterm " + term2 + " seems to be an alias: " + personsWithAlias.size());
                                    continue;
                                }
                                foundAll = false;
                            }
                            if (foundAll) {
                                this.showPersonToAddDialog(result, searchTerm, delimiter, scene);
                            } else {
                                AbstractTopComponent.notifyWarning("No person added. Could not find any aliases");
                            }
                        } else if (resultMissingPerson == 1) {
                            CreatePersonsPanel panel = new CreatePersonsPanel(missingTerms);
                            JOptionPane jOptionPane = new JOptionPane(panel, 3, 2);
                            JDialog dlg = jOptionPane.createDialog("Create persons");
                            dlg.setVisible(true);
                            if (jOptionPane.getValue() != null && jOptionPane.getValue().equals(0)) {
                                for (CreatePersonsRowPanel row : panel.getRows()) {
                                    Person newPerson = new Person();
                                    newPerson.setEthnicity((Ethnicity)row.getComboEthnicity().getSelectedItem());
                                    newPerson.setGender((Gender)row.getComboGender().getSelectedItem());
                                    newPerson.setName(row.getTfName().getText());
                                    newPerson.setWizardGenerated(true);
                                    this.db.getEntityService().save((AbstractEntity)newPerson);
                                    AbstractTopComponent.notifyInfo("Person created: " + newPerson.getName());
                                }
                                this.performAction(activatedNodes);
                            }
                        } else if (resultMissingPerson == 2) {
                            AbstractTopComponent.notifyWarning("No person added. Missing: " + (String)var14_27);
                        }
                    } else {
                        AbstractTopComponent.notifyWarning("Found " + result.size() + " persons but requested " + cntRequestedPersond + ". No person added. Missing: " + (String)var14_27);
                    }
                    LOG.info("Some requested persons are missing.");
                    continue;
                }
                AbstractTopComponent.notifyWarning("Found " + result.size() + " persons but requested " + cntRequestedPersond + ". No person added.");
            }
        }
        catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void showPersonToAddDialog(List<Person> result, String searchTerm, String delimiter, Scene scene) throws HeadlessException {
        ArrayList<Person> tmpPersons = new ArrayList<Person>(result);
        String tmpSearchTerm = searchTerm;
        String tmpDelimiter = delimiter;
        AddPersonsFromClipboardPanel panel = new AddPersonsFromClipboardPanel(tmpPersons, tmpSearchTerm, tmpDelimiter);
        JOptionPane op = new JOptionPane(panel, 3, 2);
        JDialog dlg = op.createDialog("Add persons from clipboard - some names are ambiguous");
        dlg.setVisible(true);
        if (op.getValue() != null && op.getValue().equals(0)) {
            for (JComboBox<Person> cb : panel.getComboBoxes()) {
                scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                Person p = (Person)cb.getSelectedItem();
                this.db.addPersonToScene(p, scene);
            }
            this.updateView();
        } else {
            AbstractTopComponent.notifyInfo("Aborted. No person added");
        }
    }

    private void updateView() {
        SwingUtilities.invokeLater(() -> {
            DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            detailTC.updateDisplayNameOfSelectedNode();
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add person(s) from clipboard";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

