/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.RollbackException;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.comparator.PersonComparator;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.ShowPicturesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.actions.ResetCounterAction;
import xxx.scenerixx.scenerixxmodule.childfactories.actions.ResetIcameCounterAction;
import xxx.scenerixx.scenerixxmodule.childfactories.bookmark.CallableBookmarkChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.bookmark.action.CreateGifAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddPersonsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToDefaultPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeletePlayableFromDatabaseAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteScreencapAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.MarkAsFavoriteAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.RecreateScreencapAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.OpenSeveralInstancesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddBookmarkAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddPersonsFromClipboardAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddSeveralBookmarksAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.OpenBookmarkAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.OpenBookmarkLoopedAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.OpenSceneAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.RemoveAllPersonsAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.SwapPersonAction;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class SceneChildFactory
extends ChildFactory.Detachable<INode>
implements LookupListener {
    public static final Logger LOG = Logger.getLogger(SceneChildFactory.class.getName());
    private List<INode> resultList;
    private boolean showSceneNumber = false;
    private boolean showMovieTitle = false;
    private boolean showPersons = false;
    private boolean showBookmarks = false;
    private boolean showCounter = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showRating = false;
    private boolean showPosition = false;
    private boolean comingFromSearch = false;
    private final DB db = DB.getInstance();
    private final PlaylistService ps = new PlaylistService();
    private Movie movie = null;
    private String searchTerms;
    private static final String ICON_FAVORITE_NAME = "icons/favourites.png";
    private static final Image ICON_FAVORITE = ImageUtilities.loadImage((String)"icons/favourites.png");
    private static final String ICON_LOCK_NAME = "icons/Lock.png";
    private static final Image ICON_LOCK = ImageUtilities.loadImage((String)"icons/Lock.png");
    private static final String ICON_BONUS_NAME = "icons/redbookmark.png";
    private static final Image ICON_BONUS = ImageUtilities.loadImage((String)"icons/redbookmark.png");
    private static final String ICON_BEHIND_THE_SCENES_NAME = "icons/blackbookmark.png";
    private static final Image ICON_BEHIND_THE_SCENES = ImageUtilities.loadImage((String)"icons/blackbookmark.png");
    private static final String ICON_INTERCUT_NAME = "icons/Cut.png";
    private static final Image ICON_INTERCUT = ImageUtilities.loadImage((String)"icons/Cut.png");
    private static final String ICON_SUMMARY_NAME = "icons/Component.png";
    private static final Image ICON_SUMMARY = ImageUtilities.loadImage((String)"icons/Component.png");
    private static final String ICON_DEFAULT_NAME = "icons/bluebookmark.png";
    private static final Image ICON_DEFAULT = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
    private Lookup.Result<Scene> results;

    public SceneChildFactory(Movie movie, List<INode> resultList, boolean showSceneNumber, boolean showMovieTitle, boolean showPersons, boolean showBookmarks, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPositionInList) {
        this(resultList, showSceneNumber, showMovieTitle, showPersons, showBookmarks, showCounter, showLikeCounter, showRuntime, showRating, showPositionInList);
        this.movie = movie;
    }

    public SceneChildFactory(List<INode> resultList, boolean showSceneNumber, boolean showMovieTitle, boolean showPersons, boolean showBookmarks, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPositionInList) {
        this(resultList, showSceneNumber, showMovieTitle, showPersons, showBookmarks, showCounter, showLikeCounter, showRuntime, showRating, false, showPositionInList);
    }

    public SceneChildFactory(List<INode> resultList, boolean showSceneNumber, boolean showMovieTitle, boolean showPersons, boolean showBookmarks, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean comingFromSearch, boolean showPositionInList) {
        this.resultList = resultList;
        if (this.resultList == null) {
            this.resultList = new ArrayList<INode>();
        }
        this.showSceneNumber = showSceneNumber;
        this.showMovieTitle = showMovieTitle;
        this.showPersons = showPersons;
        this.showBookmarks = showBookmarks;
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showRating = showRating;
        this.comingFromSearch = comingFromSearch;
        this.showPosition = showPositionInList;
        if (showPositionInList) {
            int i = 1;
            for (INode n : resultList) {
                if (!(n instanceof Scene)) continue;
                Scene scene = (Scene)n;
                scene.setPositionInList(i++);
            }
            i = 1;
            for (INode n : resultList) {
                if (!(n instanceof Bookmark)) continue;
                Bookmark bookmark = (Bookmark)n;
                bookmark.setPositionInList(i++);
            }
        }
    }

    protected void addNotify() {
        super.addNotify();
        LOG.finer("SceneChildFactory ADD NOTIFY");
        this.results = Utilities.actionsGlobalContext().lookupResult(Scene.class);
        this.results.addLookupListener((LookupListener)this);
    }

    protected void removeNotify() {
        super.removeNotify();
        LOG.info("SceneChildFactory REMOVE NOTIFY");
        if (this.results != null) {
            this.results.removeLookupListener((LookupListener)this);
        }
        this.results = null;
    }

    public void resultChanged(LookupEvent ev) {
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                LOG.finer("result changed");
                Scene selectedScene = ((MovieListTopComponent)movieList).getSelectedScene();
                if (selectedScene != null) {
                    LOG.info("it's a scene: " + selectedScene.getNameOfPlayable() + "... show pictures");
                    ShowPicturesAction.getInstance().showPersonPictures(selectedScene.getPersons(Scenerixx.unlocked));
                }
            }
        });
    }

    public void refresh() {
        this.refresh(true);
    }

    public void setResultList(List<INode> resultList) {
        this.resultList = resultList;
    }

    public void setShowSceneNumber(boolean showSceneNumber) {
        this.showSceneNumber = showSceneNumber;
    }

    public void setShowMovieTitle(boolean showMovieTitle) {
        this.showMovieTitle = showMovieTitle;
    }

    public void setShowPersons(boolean showPersons) {
        this.showPersons = showPersons;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this.showBookmarks = showBookmarks;
    }

    public void setShowCounter(boolean showCounter) {
        this.showCounter = showCounter;
    }

    public void setShowLikeCounter(boolean showLikeCounter) {
        this.showLikeCounter = showLikeCounter;
    }

    public void setShowRuntime(boolean showRuntime) {
        this.showRuntime = showRuntime;
    }

    public boolean isShowRating() {
        return this.showRating;
    }

    public void setShowRating(boolean showRating) {
        this.showRating = showRating;
    }

    public void setComingFromSearch(boolean comingFromSearch) {
        this.comingFromSearch = comingFromSearch;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
    }

    public void reloadList(Node n) {
        LOG.finest("Hook method reloadList in SceneChildFactory: " + String.valueOf(n));
    }

    public void reloadList(Node n, boolean reloadFromDb) {
        LOG.finest("Hook method reloadList in SceneChildFactory: " + String.valueOf(n));
    }

    protected boolean createKeys(List<INode> list) {
        Scene tmpScene = null;
        for (INode s : this.resultList) {
            list.add(s);
            if (s instanceof Scene) {
                Scene scene;
                tmpScene = scene = (Scene)s;
            }
            LOG.finest("Create keys for " + String.valueOf(s));
        }
        if (tmpScene != null && this.showBookmarks && !this.comingFromSearch) {
            list.addAll(tmpScene.getMovie().getBookmarksAsINode(Scenerixx.unlocked));
        } else if (this.movie != null) {
            list.addAll(this.movie.getBookmarksAsINode(Scenerixx.unlocked));
        }
        return true;
    }

    protected Node createNodeForKey(final INode node) {
        String sRuntime;
        Statistic stat;
        Object result = null;
        LOG.finest("create new node for key. Scene: " + String.valueOf(node));
        if (node instanceof Bookmark) {
            Bookmark b = (Bookmark)node;
            if (this.showBookmarks) {
                LOG.fine("node is a bookmark. ID: " + b.getId());
                try {
                    int cnt;
                    MovieBookmarkBeanNode bookmarkBeanNode = new MovieBookmarkBeanNode(b);
                    Object description = "";
                    if (this.showPosition && !this.showSceneNumber) {
                        description = b.getPositionInList() + ". " + (String)description;
                    }
                    if (b.getBookmarkTitle() != null) {
                        description = (String)description + b.getBookmarkTitle();
                    }
                    if (b.getType() != null && !BookmarkType.UNDEFINED.equals((Object)b.getType())) {
                        description = "[" + b.getType().getTitle() + "] " + (String)description;
                    }
                    if (this.showCounter) {
                        cnt = 0;
                        stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.bookmark.eq((Object)b)).findFirst();
                        if (stat != null) {
                            cnt = stat.getStarted().size();
                        }
                        description = (String)description + " [" + ScenerixxCommon.getSumSymbol(cnt) + "]";
                    }
                    if (this.showLikeCounter) {
                        cnt = 0;
                        stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.bookmark.eq((Object)b)).findFirst();
                        if (stat != null) {
                            cnt = stat.getLikes().size();
                        }
                        description = (String)description + " [" + ScenerixxCommon.getColoredHeart(cnt) + "]";
                    }
                    if (this.showRuntime) {
                        int runtime = b.getTotalRuntime();
                        sRuntime = "";
                        sRuntime = b.getStartTime() > 0 && b.getEndTime() <= 0 ? ScenerixxCommon.formatRuntimeBookmarkWithoutEndtime(b.getStartTime()) : ScenerixxCommon.formatRuntime(runtime);
                        description = (String)description + " [" + sRuntime + "]";
                    }
                    if (this.showRating) {
                        int rating = 0;
                        if (b.getRating() != null) {
                            rating = b.getRating();
                        }
                        description = (String)description + "[" + ScenerixxCommon.getColoredStar(rating, b.getRatingDifferentiator()) + "]";
                    }
                    bookmarkBeanNode.setName("bookmark" + b.getId());
                    bookmarkBeanNode.setDisplayName("<html>" + (String)description + "</html>");
                    bookmarkBeanNode.setValue("bookmark", b);
                    result = bookmarkBeanNode;
                }
                catch (IntrospectionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not create scene node. An error occured: " + ex.getMessage());
                }
            }
        }
        if (node instanceof Scene) {
            final Scene scene = (Scene)node;
            LOG.finest("node is a scene");
            Children children = Children.createLazy((Callable)new CallableBookmarkChildFactory(scene, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition, Scenerixx.unlocked));
            result = new AbstractNode(children, Lookups.singleton((Object)scene)){

                public Action[] getActions(boolean context) {
                    ArrayList<Action> list = new ArrayList<Action>();
                    list.add((Action)SharedClassObject.findObject(OpenSceneAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(OpenSeveralInstancesAction.class, (boolean)true));
                    list.add(null);
                    list.add((Action)SystemAction.get(MarkAsFavoriteAction.class));
                    list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
                    list.add(null);
                    list.add((Action)SystemAction.get(AddBookmarkAction.class));
                    list.add((Action)SystemAction.get(AddSeveralBookmarksAction.class));
                    list.add(null);
                    list.add(new RemovePictureFilesPopupAction((Node)this, scene));
                    for (Person p : scene.getPersons(Scenerixx.unlocked)) {
                        list.add((Action)WeakListeners.create(Action.class, (EventListener)new RemovePersonAction((Node)this, p), null));
                    }
                    if (!scene.getPersons(Scenerixx.unlocked).isEmpty()) {
                        list.add((Action)SystemAction.get(RemoveAllPersonsAction.class));
                        list.add((Action)SystemAction.get(SwapPersonAction.class));
                        list.add(null);
                    }
                    if (SceneChildFactory.this.showCounter) {
                        list.add((Action)SystemAction.get(ResetCounterAction.class));
                    }
                    if (SceneChildFactory.this.showLikeCounter) {
                        list.add((Action)SystemAction.get(ResetIcameCounterAction.class));
                    }
                    list.add(null);
                    list.add((Action)SystemAction.get(RecreateScreencapAction.class));
                    list.add((Action)SystemAction.get(DeleteScreencapAction.class));
                    list.add((Action)SystemAction.get(DeletePlayableFromDatabaseAction.class));
                    list.add(null);
                    list.add((Action)SystemAction.get(AddPersonsAction.class));
                    list.add((Action)SystemAction.get(AddPersonsFromClipboardAction.class));
                    Action[] actions = new Action[list.size()];
                    actions = list.toArray(actions);
                    return actions;
                }

                public Action getPreferredAction() {
                    Scene sceneToOpen = scene;
                    if (this.getValue("scene") != null && this.getValue("scene") instanceof Scene) {
                        sceneToOpen = (Scene)this.getValue("scene");
                    }
                    LOG.info("open scene " + sceneToOpen.getNameOfPlayable());
                    TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                    if (movieList != null) {
                        ((MovieListTopComponent)movieList).openVlc(sceneToOpen.getNameOfPlayable(), null, sceneToOpen, null, null, true);
                    }
                    return null;
                }

                public Image getIcon(String iconPath) {
                    Scene scene2 = null;
                    if (!(node instanceof Scene)) {
                        return ImageUtilities.loadImage((String)iconPath);
                    }
                    scene2 = (Scene)node;
                    if (ScenerixxCommon.sceneIdsOnDefaultPlaylist.contains(scene2.getId())) {
                        Image defaultPlaylistMergeImages = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"icons/notes.png"), (Image)ImageUtilities.loadImage((String)SceneChildFactory.ICON_FAVORITE_NAME), (int)3, (int)2);
                        Image mergeImages = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)defaultPlaylistMergeImages, (int)7, (int)7);
                        return mergeImages;
                    }
                    if (ScenerixxCommon.sceneIdsOnAnyPlaylist.contains(scene2.getId())) {
                        return ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)ImageUtilities.loadImage((String)"icons/notes.png"), (int)7, (int)7);
                    }
                    switch (iconPath) {
                        case "icons/favourites.png": {
                            return ICON_FAVORITE;
                        }
                        case "icons/Lock.png": {
                            return ICON_LOCK;
                        }
                        case "icons/redbookmark.png": {
                            return ICON_BONUS;
                        }
                        case "icons/blackbookmark.png": {
                            return ICON_BEHIND_THE_SCENES;
                        }
                        case "icons/Cut.png": {
                            return ICON_INTERCUT;
                        }
                        case "icons/Component.png": {
                            return ICON_SUMMARY;
                        }
                        case "icons/bluebookmark.png": {
                            return ICON_DEFAULT;
                        }
                    }
                    return ImageUtilities.loadImage((String)iconPath);
                }

                public Image getOpenedIcon(int type) {
                    if (scene.isFavorite()) {
                        return this.getIcon(SceneChildFactory.ICON_FAVORITE_NAME);
                    }
                    if (SceneChildFactory.this.comingFromSearch && scene.getMovie().isSecret()) {
                        return this.getIcon(SceneChildFactory.ICON_LOCK_NAME);
                    }
                    if (scene.isBonusScene()) {
                        return this.getIcon(SceneChildFactory.ICON_BONUS_NAME);
                    }
                    if (scene.isBehindTheScenes()) {
                        return this.getIcon(SceneChildFactory.ICON_BEHIND_THE_SCENES_NAME);
                    }
                    if (scene.isIntercut()) {
                        return this.getIcon(SceneChildFactory.ICON_INTERCUT_NAME);
                    }
                    if (scene.isSummary()) {
                        return this.getIcon(SceneChildFactory.ICON_SUMMARY_NAME);
                    }
                    return this.getIcon(SceneChildFactory.ICON_DEFAULT_NAME);
                }

                public Image getIcon(int type) {
                    return this.getOpenedIcon(type);
                }

                public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
                    return new PasteType(){

                        private void addPictureToScene(MediumFile mf, Scene s) {
                            if (MediumFileService.isPicture((MediumFile)mf)) {
                                s.getPictures().add(mf);
                                try {
                                    SceneChildFactory.this.db.getEntityService().save((AbstractEntity)scene);
                                }
                                catch (RollbackException ex) {
                                    AbstractTopComponent.notify("Picture is already assigned", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "The picture is already assigned to this scene", null, NotificationDisplayer.Priority.LOW);
                                }
                                LOG.fine("added " + mf.getFileCompletePath() + " to scene " + scene.toString());
                            }
                        }

                        private void addSeveralPicturesToScene(Node[] nodes, Scene s) {
                            for (Node n : nodes) {
                                Object object = n.getValue("mediumFile");
                                if (!(object instanceof MediumFile)) continue;
                                MediumFile mf = (MediumFile)object;
                                this.addPictureToScene(mf, s);
                            }
                        }

                        private Scene addPersonToScene(Node n, Person p) {
                            LOG.info("before: " + scene.getEndTime());
                            Scene sceneReloaded = (Scene)SceneChildFactory.this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                            LOG.info("After: " + sceneReloaded.getEndTime());
                            if (!p.getName().contains("Unknown") && scene.getPersons(Scenerixx.unlocked).contains(p)) {
                                AbstractTopComponent.notifyWarning(p.getName() + " is already added to this scene");
                            } else {
                                SceneDetails sd = new SceneDetails();
                                sd.setDateOfCreation(LocalDateTime.now());
                                sd.setScene(sceneReloaded);
                                sd.setPerson(p);
                                sceneReloaded.getDetails().add(sd);
                                sceneReloaded = (Scene)SceneChildFactory.this.db.getEntityService().save((AbstractEntity)sceneReloaded);
                                LOG.fine("added " + p.getName() + " to movie " + sceneReloaded.getMovie().getTitle() + " scene " + sceneReloaded.getPosition());
                                AbstractTopComponent.notifyInfo("added " + p.getName() + " to movie " + sceneReloaded.getMovie().getTitle() + " scene " + sceneReloaded.getPosition());
                            }
                            n.setValue("scene", (Object)sceneReloaded);
                            TopComponent detailsTC = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                            if (detailsTC != null) {
                                ((DetailsTopComponent)detailsTC).loadScene(sceneReloaded);
                            }
                            return sceneReloaded;
                        }

                        private void addSeveralPersonsToScene(Node[] nodes, Node sceneNode) {
                            ArrayList<Person> tmpMales = new ArrayList<Person>();
                            ArrayList<Person> tmpFemales = new ArrayList<Person>();
                            ArrayList<Person> tmpTS = new ArrayList<Person>();
                            for (Node n : nodes) {
                                Object object = n.getValue("person");
                                if (!(object instanceof Person)) continue;
                                Person person = (Person)object;
                                if (Gender.MALE.equals((Object)person.getGender())) {
                                    tmpMales.add(person);
                                }
                                if (Gender.FEMALE.equals((Object)person.getGender())) {
                                    tmpFemales.add(person);
                                }
                                if (!Gender.TS.equals((Object)person.getGender())) continue;
                                tmpTS.add(person);
                            }
                            Collections.sort(tmpFemales, new PersonComparator());
                            Collections.sort(tmpTS, new PersonComparator());
                            Collections.sort(tmpMales, new PersonComparator());
                            for (Person p : tmpFemales) {
                                this.addPersonToScene(sceneNode, p);
                            }
                            for (Person p : tmpTS) {
                                this.addPersonToScene(sceneNode, p);
                            }
                            for (Person p : tmpMales) {
                                this.addPersonToScene(sceneNode, p);
                            }
                        }

                        private void updateDetailsComponent(Scene scene) {
                            TopComponent detailsTC = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                            if (detailsTC != null) {
                                ((DetailsTopComponent)detailsTC).loadScene(scene);
                            }
                        }

                        private void reloadPersonListAndOtherComponents(Node nodeToSelectAfterReload2, boolean fullReload) {
                            Object object;
                            if (fullReload) {
                                SceneChildFactory.this.reloadList(nodeToSelectAfterReload2, true);
                            } else {
                                DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                                if (detailTC != null) {
                                    detailTC.updateDisplayNameOfSelectedNode();
                                }
                            }
                            AbstractTopComponent.dirtyPersonList();
                            if (nodeToSelectAfterReload2.getValue("scene") != null && (object = nodeToSelectAfterReload2.getValue("scene")) instanceof Scene) {
                                Scene scene = (Scene)object;
                                TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                                if (movieList != null) {
                                    LOG.info("Selecting scene: " + String.valueOf(scene));
                                    ((MovieListTopComponent)movieList).selectSceneNode(scene, true);
                                }
                                this.updateDetailsComponent((Scene)nodeToSelectAfterReload2.getValue("scene"));
                            }
                        }

                        public Transferable paste() throws IOException {
                            Object tmpScene;
                            Object object;
                            Node node = NodeTransfer.node((Transferable)t, (int)action);
                            Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)action);
                            if (node != null && node.getValue("person") != null && (object = node.getValue("person")) instanceof Person) {
                                Person p = (Person)object;
                                this.addPersonToScene(node, p);
                                this.reloadPersonListAndOtherComponents(node, false);
                            } else if (node != null && node.getValue("mediumFile") != null && (object = node.getValue("mediumFile")) instanceof MediumFile) {
                                MediumFile medium = (MediumFile)object;
                                this.addPictureToScene(medium, scene);
                                this.updateDetailsComponent(scene);
                            } else if (node != null && node.getValue("bookmark") != null && (object = node.getValue("bookmark")) instanceof Bookmark) {
                                Bookmark dragBookmark = (Bookmark)object;
                                dragBookmark = (Bookmark)SceneChildFactory.this.db.getEntityService().load(Bookmark.class, dragBookmark.getId().longValue());
                                LOG.finer("node bookmark (drag): " + dragBookmark.getNameOfPlayable());
                                LOG.finer("scene (drop): " + scene.getNameOfPlayable());
                                dragBookmark.setScene(scene);
                                dragBookmark = (Bookmark)SceneChildFactory.this.db.getEntityService().save((AbstractEntity)dragBookmark);
                                scene.getBookmarks(Scenerixx.unlocked).add(dragBookmark);
                                tmpScene = (Scene)SceneChildFactory.this.db.getEntityService().save((AbstractEntity)scene);
                                TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                                if (movieList != null) {
                                    ((MovieListTopComponent)movieList).selectSceneNode((Scene)tmpScene);
                                    SceneChildFactory.this.db.evictCache(Movie.class);
                                    SceneChildFactory.this.db.evictCache(Scene.class);
                                    SceneChildFactory.this.db.evictCache(Bookmark.class);
                                    ((MovieListTopComponent)movieList).reloadListAndRefocus();
                                }
                            } else if (node != null && node.getValue("scene") != null && (tmpScene = node.getValue("scene")) instanceof Scene) {
                                Scene dragScene = (Scene)tmpScene;
                                dragScene = (Scene)SceneChildFactory.this.db.getEntityService().load(Scene.class, dragScene.getId().longValue());
                                SceneChildFactory.this.movie = (Movie)SceneChildFactory.this.db.getEntityService().load(Movie.class, SceneChildFactory.this.movie.getId().longValue());
                                if (dragScene.getMovie().getId().longValue() != scene.getMovie().getId().longValue()) {
                                    dragScene.getMovie().getScenes().remove(dragScene.getPosition() - 1);
                                    for (int i = 0; i < dragScene.getMovie().getScenes().size(); ++i) {
                                        ((Scene)dragScene.getMovie().getScenes().get(i)).setPosition(i + 1);
                                        SceneChildFactory.this.db.getEntityService().save((AbstractEntity)((Scene)dragScene.getMovie().getScenes().get(i)));
                                        LOG.fine("[drag] Saved: " + ((Scene)dragScene.getMovie().getScenes().get(i)).getNameOfPlayable() + " - " + ((Scene)dragScene.getMovie().getScenes().get(i)).getPosition());
                                    }
                                    SceneChildFactory.this.db.getEntityService().save((AbstractEntity)dragScene.getMovie());
                                    LOG.info("target is a different movie");
                                    dragScene.setMovie(scene.getMovie());
                                    dragScene = (Scene)SceneChildFactory.this.db.getEntityService().save((AbstractEntity)dragScene);
                                    scene.getMovie().getScenes().add(scene.getPosition(), dragScene);
                                    SceneChildFactory.this.db.getEntityService().save((AbstractEntity)scene.getMovie());
                                    this.setScenePositionAndSaveMovie();
                                } else {
                                    Scene sceneToMove = (Scene)SceneChildFactory.this.movie.getScenes().get(dragScene.getPosition() - 1);
                                    SceneChildFactory.this.movie.getScenes().remove(dragScene.getPosition() - 1);
                                    SceneChildFactory.this.movie.getScenes().add(scene.getPosition() - 1, sceneToMove);
                                    this.setScenePositionAndSaveMovie();
                                }
                                LOG.finer("node scene (drag): " + dragScene.getNameOfPlayable());
                                LOG.finer("scene (drop): " + scene.getNameOfPlayable());
                                SwingUtilities.invokeLater(() -> {
                                    TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                                    if (movieList != null) {
                                        Node selectedMovieNode = ((MovieListTopComponent)movieList).selectMovieNode(SceneChildFactory.this.movie);
                                        LOG.fine("selected movie node after d&d: " + String.valueOf(selectedMovieNode));
                                        ((MovieListTopComponent)movieList).reloadListAndRefocus();
                                    }
                                });
                            } else if (nodes != null) {
                                this.addSeveralPersonsToScene(nodes, (Node)nodeToSelectAfterReload);
                                this.addSeveralPicturesToScene(nodes, scene);
                                this.reloadPersonListAndOtherComponents((Node)nodeToSelectAfterReload, false);
                            } else {
                                LOG.finest("Dragged object was no person or picture");
                            }
                            return null;
                        }

                        private void setScenePositionAndSaveMovie() {
                            for (int i = 0; i < SceneChildFactory.this.movie.getScenes().size(); ++i) {
                                ((Scene)SceneChildFactory.this.movie.getScenes().get(i)).setPosition(i + 1);
                                SceneChildFactory.this.db.getEntityService().save((AbstractEntity)((Scene)SceneChildFactory.this.movie.getScenes().get(i)));
                                LOG.finer("Saved: " + ((Scene)SceneChildFactory.this.movie.getScenes().get(i)).getNameOfPlayable() + " - " + ((Scene)SceneChildFactory.this.movie.getScenes().get(i)).getPosition());
                            }
                            SceneChildFactory.this.movie = (Movie)SceneChildFactory.this.db.getEntityService().save((AbstractEntity)SceneChildFactory.this.movie);
                        }
                    };
                }

                public PasteType getDropType(Transferable t, int action, int index) {
                    return this.createPasteType(t, action, this);
                }

                public String getHtmlDisplayName() {
                    return this.getDisplayName();
                }

                class RemovePictureFilesPopupAction
                extends AbstractAction
                implements ActionListener,
                Presenter.Popup {
                    Scene scene;
                    Node node;

                    public RemovePictureFilesPopupAction(Node node, Scene scene) {
                        this.node = node;
                        this.scene = scene;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }

                    public JMenuItem getPopupPresenter() {
                        JMenu main = new JMenu("Remove picture from scene ");
                        for (MediumFile mf : this.scene.getPictures()) {
                            main.add((Action)WeakListeners.create(Action.class, (EventListener)new RemovePictureFromSceneAction(this.node, mf), null));
                        }
                        main.setEnabled(!this.scene.getPictures().isEmpty());
                        return main;
                    }
                }

                class RemovePersonAction
                extends AbstractAction {
                    private Node node;
                    private Person person;

                    public RemovePersonAction(Node node, Person p) {
                        this.putValue("Name", "Remove " + p.getName());
                        this.node = node;
                        this.person = p;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Scene scene = (Scene)this.getLookup().lookup(Scene.class);
                        SceneDetails sd = (SceneDetails)SceneChildFactory.this.db.getEntityService().find((EntityPathBase)QSceneDetails.sceneDetails).filter(f -> f.person.eq((Object)this.person)).filter(f -> f.scene.eq((Object)scene)).findFirst();
                        if (sd != null) {
                            SceneChildFactory.this.db.getEntityService().delete((AbstractEntity)sd);
                            AbstractTopComponent.dirtyPersonList();
                            DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                            if (detailTC != null) {
                                detailTC.updateDisplayNameOfSelectedNode();
                            }
                        }
                    }
                }

                class RemovePictureFromSceneAction
                extends AbstractAction {
                    private Node node;
                    private MediumFile mf;

                    public RemovePictureFromSceneAction(Node node, MediumFile mf) {
                        this.putValue("Name", "Remove " + mf.getFileName() + " [" + ScenerixxCommon.readableFileSize(mf.getFileSize()) + "]");
                        this.node = node;
                        this.mf = mf;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Scene scene = (Scene)this.getLookup().lookup(Scene.class);
                        scene.getPictures().remove(this.mf);
                        SceneChildFactory.this.db.getEntityService().save((AbstractEntity)scene);
                        SceneChildFactory.this.reloadList(this.node);
                        AbstractTopComponent.reloadMediumFileList();
                    }
                }
            };
            Object displayName = "";
            if (this.showPosition && !this.showSceneNumber) {
                displayName = (String)displayName + scene.getPositionInList() + ". ";
                LOG.info("showPos: " + this.showPosition + " - showSceneNumber: " + this.showSceneNumber + " - " + (String)displayName);
            }
            if (this.showSceneNumber && !this.comingFromSearch) {
                displayName = (String)displayName + scene.getPosition() + " ";
            }
            if (scene.isBehindTheScenes()) {
                displayName = (String)displayName + "Behind the scenes ";
            }
            if (this.showMovieTitle) {
                displayName = (String)displayName + "'" + scene.getMovie().getTitle() + "' - ";
            }
            if (this.showSceneNumber && this.comingFromSearch) {
                displayName = (String)displayName + "Scene " + scene.getPosition() + " - ";
            }
            if (this.showPersons) {
                ArrayList<Person> tmpMales = new ArrayList<Person>();
                ArrayList<Object> tmpFemales = new ArrayList<Object>();
                ArrayList<Person> tmpTS = new ArrayList<Person>();
                for (Person person2 : scene.getPersons(Scenerixx.unlocked)) {
                    if (Gender.MALE.equals((Object)person2.getGender()) && (!person2.isSecret() || person2.isSecret() && Scenerixx.unlocked)) {
                        tmpMales.add(person2);
                    }
                    if (Gender.TS.equals((Object)person2.getGender()) && (!person2.isSecret() || person2.isSecret() && Scenerixx.unlocked)) {
                        tmpTS.add(person2);
                    }
                    if (Gender.FEMALE.equals((Object)person2.getGender()) && (!person2.isSecret() || person2.isSecret() && Scenerixx.unlocked)) {
                        tmpFemales.add(person2);
                    }
                    if (scene.getDetails(person2) == null) continue;
                    person2.setRemindsMeOf(scene.getDetails(person2).getRemindsMeOf());
                }
                Collections.sort(tmpFemales, new PersonComparator());
                Collections.sort(tmpTS, new PersonComparator());
                Collections.sort(tmpMales, new PersonComparator());
                tmpFemales.addAll(tmpTS);
                tmpFemales.addAll(tmpMales);
                displayName = (String)displayName + tmpFemales.stream().map(person -> person.getHtmlDisplayedName(Scenerixx.unlocked, scene) + " " + ScenerixxCommon.calculateAge(scene, person)).collect(Collectors.joining(" & "));
            }
            if (this.showCounter) {
                int cnt = 0;
                stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.scene.eq((Object)scene)).findFirst();
                if (stat != null) {
                    cnt = stat.getStarted().size();
                }
                displayName = (String)displayName + " [" + ScenerixxCommon.getSumSymbol(cnt) + "]";
            }
            if (this.showLikeCounter) {
                int cnt = 0;
                stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.scene.eq((Object)scene)).findFirst();
                if (stat != null) {
                    cnt = stat.getLikes().size();
                }
                displayName = (String)displayName + " [" + ScenerixxCommon.getColoredHeart(cnt) + "]";
            }
            if (this.showRuntime) {
                int runtime = scene.getTotalRuntime();
                sRuntime = ScenerixxCommon.formatRuntime(runtime);
                displayName = (String)displayName + " [" + sRuntime + "]";
            }
            if (this.showRating) {
                int rating = 0;
                if (scene.getRating() != null && scene.getRating() > -1) {
                    rating = scene.getRating();
                }
                displayName = (String)displayName + "[" + ScenerixxCommon.getColoredStar(rating, scene.getRatingDifferentiator()) + "]";
            }
            displayName = ScenerixxCommon.highlighting((String)displayName, this.getSearchTerms());
            LOG.info((String)displayName + " - " + this.getSearchTerms());
            result.setDisplayName((String)displayName);
            result.setName((String)displayName);
            result.setValue("scene", (Object)scene);
        }
        return result;
    }

    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    public class MovieBookmarkBeanNode
    extends BeanNode {
        public MovieBookmarkBeanNode(Bookmark bean) throws IntrospectionException {
            super((Object)bean, Children.LEAF, Lookups.singleton((Object)bean));
        }

        public String getHtmlDisplayName() {
            return this.getDisplayName();
        }

        public Action[] getActions(boolean context) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(SystemAction.get(OpenBookmarkAction.class));
            list.add(SystemAction.get(OpenBookmarkLoopedAction.class));
            list.add(null);
            list.add(SystemAction.get(MarkAsFavoriteAction.class));
            list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
            list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
            list.add(null);
            list.add(SystemAction.get(CreateGifAction.class));
            list.add(null);
            list.add(SystemAction.get(DeletePlayableFromDatabaseAction.class));
            if (SceneChildFactory.this.showCounter) {
                list.add(SystemAction.get(ResetCounterAction.class));
            }
            if (SceneChildFactory.this.showLikeCounter) {
                list.add(SystemAction.get(ResetIcameCounterAction.class));
            }
            Action[] actions = new Action[list.size()];
            actions = list.toArray(actions);
            return actions;
        }

        public Action getPreferredAction() {
            LOG.info("open movie bookmark " + ((Bookmark)this.getLookup().lookup(Bookmark.class)).getNameOfPlayable());
            Bookmark bookmarkToLoad = (Bookmark)SceneChildFactory.this.db.getEntityService().load(Bookmark.class, ((Bookmark)this.getLookup().lookup(Bookmark.class)).getId().longValue());
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).openVlc(bookmarkToLoad.getNameOfPlayable(), null, null, bookmarkToLoad, null, true);
            }
            return null;
        }

        public Image getIcon(String iconPath) {
            Bookmark p = null;
            if (this.getLookup().lookup(Bookmark.class) instanceof Bookmark) {
                p = (Bookmark)this.getLookup().lookup(Bookmark.class);
            }
            if (p != null && SceneChildFactory.this.ps.contains((IPlayable)p, SceneChildFactory.this.ps.getDefaultPlaylist(Scenerixx.unlocked), Scenerixx.unlocked)) {
                return ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)iconPath), (Image)ImageUtilities.loadImage((String)"icons/notes.png"), (int)7, (int)7);
            }
            return ImageUtilities.loadImage((String)iconPath);
        }

        public Image getOpenedIcon(int type) {
            Bookmark obj = (Bookmark)this.getLookup().lookup(Bookmark.class);
            if (obj.isFavorite()) {
                return this.getIcon(SceneChildFactory.ICON_FAVORITE_NAME);
            }
            if (obj.isSecret()) {
                return this.getIcon(SceneChildFactory.ICON_LOCK_NAME);
            }
            return this.getIcon("icons/greenbookmark.png");
        }

        public Image getIcon(int type) {
            return this.getOpenedIcon(type);
        }

        public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    Node node = NodeTransfer.node((Transferable)t, (int)action);
                    if (node instanceof MovieBookmarkBeanNode) {
                        Bookmark source = (Bookmark)node.getValue("bookmark");
                        Bookmark target = (Bookmark)MovieBookmarkBeanNode.this.getValue("bookmark");
                        Bookmark tmp = (Bookmark)source.getMovie().getBookmarks(true).remove(source.getPosition());
                        source.getMovie().getBookmarks(true).add(target.getPosition(), tmp);
                        int i = 0;
                        for (Bookmark bookmark : source.getMovie().getBookmarks(true)) {
                            bookmark.setPosition(i);
                            ++i;
                            SceneChildFactory.this.db.getEntityService().save((AbstractEntity)bookmark);
                        }
                        SceneChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                    } else {
                        LOG.fine("Something pasted to a bookmark but not a MovieBookmarkBeanNode: " + node.getDisplayName());
                    }
                    SceneChildFactory.this.refresh(true);
                    return null;
                }
            };
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return this.createPasteType(t, action, (AbstractNode)this);
        }
    }
}

