/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene;

import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.SceneChildFactory;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class CallableSceneChildFactory
implements Callable {
    public static final Logger LOG = Logger.getLogger(CallableSceneChildFactory.class.getName());
    private final Movie movie;
    private final Person person;
    private boolean showCounter;
    private boolean showLikeCounter;
    private boolean showRuntime;
    private boolean showRating;
    private boolean showPosition;
    private String searchTerms;

    public CallableSceneChildFactory(Movie movie, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPosition, String searchTerm) {
        this.person = null;
        this.movie = movie;
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showRating = showRating;
        this.showPosition = showPosition;
        this.searchTerms = searchTerm;
    }

    public CallableSceneChildFactory(Movie movie, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPosition) {
        this.person = null;
        this.movie = movie;
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showRating = showRating;
        this.showPosition = showPosition;
    }

    public CallableSceneChildFactory(Person person, boolean showCounter, boolean showLikeCounter, boolean showRuntime, boolean showRating, boolean showPosition) {
        this.movie = null;
        this.person = person;
        this.showCounter = showCounter;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showRating = showRating;
        this.showPosition = showPosition;
    }

    public Children call() throws Exception {
        Children result = Children.LEAF;
        if (this.movie != null) {
            LOG.finer("call -> " + this.movie.getTitle());
            if (this.movie.getScenes().isEmpty()) {
                result = Children.LEAF;
            } else {
                SceneChildFactory sceneChildFactory = new SceneChildFactory(this.movie, this.movie.getScenesAsINode(), true, false, true, true, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition){

                    @Override
                    public void reloadList(Node node, boolean reloadFromDb) {
                        super.reloadList(node, reloadFromDb);
                        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                        if (movieList != null && movieList instanceof MovieListTopComponent) {
                            MovieListTopComponent tc = (MovieListTopComponent)movieList;
                            tc.reloadListAndRefocus();
                            tc.selectMovieNode(CallableSceneChildFactory.this.movie);
                        }
                        LOG.fine("Reload scene list from SceneChildFactory");
                    }
                };
                sceneChildFactory.setSearchTerms(this.searchTerms);
                result = Children.create((ChildFactory)sceneChildFactory, (boolean)true);
            }
        } else if (this.person != null) {
            LOG.finer("call -> " + this.person.getName());
            SceneChildFactory sceneChildFactory = new SceneChildFactory(this, this.person.getScenesAsINode(Scenerixx.unlocked), true, true, true, true, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, this.showPosition){

                @Override
                public void reloadList(Node node, boolean reloadFromDb) {
                    super.reloadList(node, reloadFromDb);
                    AbstractTopComponent.reloadMovieList(true);
                    LOG.fine("Reload scene list from SceneChildFactory");
                }
            };
            if (this.person.getScenesAsINode(Scenerixx.unlocked).isEmpty()) {
                result = Children.LEAF;
            } else {
                sceneChildFactory.setSearchTerms(this.searchTerms);
                result = Children.create((ChildFactory)sceneChildFactory, (boolean)true);
            }
        }
        return result;
    }
}

