/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class StartPlaylistFromHereReverseAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(StartPlaylistFromHereReverseAction.class.getName());
    private DB db = DB.getInstance();

    public StartPlaylistFromHereReverseAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/vlc.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons/Raise.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
        for (Node n : activatedNodes) {
            Object p;
            if (n.getValue("entry") == null || !(n.getValue("entry") instanceof PlaylistEntry)) continue;
            PlaylistEntry pe = (PlaylistEntry)n.getValue("entry");
            Playlist srcPlaylist = scenerixxCommon.correctPositions(pe.getPlaylist());
            if (pe.getId() != null) {
                pe = (PlaylistEntry)this.db.getEntityService().load(PlaylistEntry.class, pe.getId().longValue());
            }
            ArrayList startPlayables = new ArrayList();
            List playables = srcPlaylist.getPlayables(Scenerixx.unlocked);
            if (srcPlaylist.isHistoryPlaylist() || srcPlaylist.isSecretHistoryPlaylist()) {
                Collections.reverse(playables);
            }
            Movie current = null;
            if (pe.getMovie() != null) {
                current = pe.getMovie();
            }
            if (pe.getScene() != null) {
                current = pe.getScene();
            }
            if (pe.getBookmark() != null) {
                current = pe.getBookmark();
            }
            if (pe.getPerson() != null) {
                current = pe.getPerson();
            }
            if (pe.getStudio() != null) {
                current = pe.getStudio();
            }
            if (pe.getMediumFile() != null) {
                current = pe.getMediumFile();
            }
            LOG.info("current: " + String.valueOf(current));
            int i = 0;
            if (current != null) {
                Iterator iterator = playables.iterator();
                while (iterator.hasNext() && !(p = (IPlayablePlaylistItems)iterator.next()).getId().equals(current.getId())) {
                    ++i;
                }
            }
            startPlayables.addAll(playables.subList(i, playables.size()));
            startPlayables.addAll(playables.subList(0, i));
            Playlist playlist = new Playlist();
            for (IPlayablePlaylistItems p2 : startPlayables) {
                scenerixxCommon.fillPlaylistEntry(p2, playlist);
            }
            Collections.reverse(playlist.getEntries(Scenerixx.unlocked));
            Collections.rotate(playlist.getEntries(Scenerixx.unlocked), 1);
            p = playlist.getEntries(Scenerixx.unlocked).iterator();
            while (p.hasNext()) {
                PlaylistEntry ent = (PlaylistEntry)p.next();
                LOG.fine("playlist entry: " + ent.getNameOfPlayable());
            }
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList == null) continue;
            ((MovieListTopComponent)movieList).openVlc(playlist, true, false);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.info("activated nodes (start playlist from here (reverse) action) " + activatedNodes.length);
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Start playlist from here (reverse)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

