/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlist.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class SetAsDefaultAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(SetAsDefaultAction.class.getName());
    private PlaylistService ps = new PlaylistService();

    public SetAsDefaultAction() {
        Image image = ImageUtilities.loadImage((String)"icons/favourites.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        LOG.info("act " + String.valueOf(activatedNodes));
        for (Node n : activatedNodes) {
            if (n.getValue("playlist") != null && n.getValue("playlist") instanceof Playlist) {
                this.ps.saveAsNewDefaultPlaylist((Playlist)n.getValue("playlist"));
            }
            SwingUtilities.invokeLater(() -> {
                TopComponent playlistTC = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                if (playlistTC != null) {
                    ((PlaylistTopComponent)playlistTC).reloadList();
                }
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("act " + String.valueOf(activatedNodes));
        boolean res = true;
        if (activatedNodes != null) {
            for (Node n : activatedNodes) {
                if (n.getValue("playlist") == null || !(n.getValue("playlist") instanceof Playlist) || !((Playlist)n.getValue("playlist")).isHistoryPlaylist() && !((Playlist)n.getValue("playlist")).isSecretHistoryPlaylist() && !((Playlist)n.getValue("playlist")).isTemporaryPlaylist()) continue;
                res = false;
            }
        }
        return res;
    }

    public String getName() {
        return "Set As Default";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

