/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlist.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.exporter.XspfExporter;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ExportToXspfAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ExportToXspfAction.class.getName());

    public ExportToXspfAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/text_exports.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int n = 0;
        Node[] nodeArray = activatedNodes;
        int n2 = nodeArray.length;
        if (n < n2) {
            Object object;
            Node n3 = nodeArray[n];
            if (n3.getValue("playlist") != null && (object = n3.getValue("playlist")) instanceof Playlist) {
                Playlist playlist = (Playlist)object;
                try {
                    String exportPlaylistToXspf = new XspfExporter().exportPlaylistToXspf(playlist, Scenerixx.scenerixxPlaylistsDir, Scenerixx.unlocked);
                    AbstractTopComponent.notify("Exported to: " + exportPlaylistToXspf, ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.NORMAL);
                }
                catch (ParserConfigurationException pce) {
                    AbstractTopComponent.notify("An error occured during parsing. Could not export playlist.", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                    pce.printStackTrace();
                }
                catch (TransformerException tfe) {
                    AbstractTopComponent.notify("An error occured during transforming. Could not export playlist.", ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
                    tfe.printStackTrace();
                }
            }
            return;
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Export to VLC playlist (*.xspf)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

