/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Desktop;
import java.awt.Image;
import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class OpenDirectoryAction
extends NodeAction
implements Presenter.Popup {
    public OpenDirectoryAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/folder_go.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        Object object;
        if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0].getValue("movie") != null && activatedNodes[0].getValue("movie") instanceof Movie) {
            Movie movie = (Movie)activatedNodes[0].getValue("movie");
            List mediumFiles = DB.getInstance().getMediumFiles(movie, Scenerixx.unlocked);
            if (!mediumFiles.isEmpty()) {
                this.openDirectory((MediumFile)mediumFiles.get(0));
            } else {
                AbstractTopComponent.notifyWarning("Could not open directory. No associated medium file.");
            }
        } else if (activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0].getValue("mediumFile") != null && (object = activatedNodes[0].getValue("mediumFile")) instanceof MediumFile) {
            MediumFile mf = (MediumFile)object;
            this.openDirectory(mf);
        } else {
            AbstractTopComponent.notifyWarning("Could not open directory because movie could not be determined.");
        }
    }

    private void openDirectory(MediumFile mediumFile) {
        try {
            Desktop.getDesktop().open(new File(mediumFile.getFileCompletePath()).getParentFile());
        }
        catch (Exception ex) {
            AbstractTopComponent.notifyError("Could not open directory. An error occured: " + ex.getMessage());
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public String getName() {
        return "Open Directory";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

