/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.LocalDateTime;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.PlaylistSelectionPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class AddToPlaylistAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(AddToPlaylistAction.class.getName());
    private final DB db = DB.getInstance();
    private final PlaylistService ps = new PlaylistService();
    private Playlist playlist;

    public AddToPlaylistAction() {
        Image image = ImageUtilities.loadImage((String)"icons/notes.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        LOG.fine("activated nodes:" + activatedNodes.length);
        final PlaylistSelectionPanel panel = new PlaylistSelectionPanel();
        JOptionPane op = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                LOG.info("selectInitialValue: " + String.valueOf(panel.getComboPlaylist()));
                panel.getComboPlaylist();
                1 v0 = this;
                panel.setPlaylist(v0.panel.getLastSelectedPlaylist());
            }
        };
        JDialog dlg = op.createDialog("Select a playlist");
        dlg.setVisible(true);
        dlg.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                panel.gainedFocus();
            }
        });
        this.playlist = op.getValue() != null && op.getValue().equals(0) ? panel.getPlaylist() : null;
        LOG.info("playlist: " + String.valueOf(this.playlist));
        if (this.playlist == null) {
            return;
        }
        LOG.info("perform action addtoplaylistaction: " + this.playlist.getName());
        if (this.playlist == null) {
            AbstractTopComponent.notifyError("No playlist passed. Cannot add anything.");
            LOG.warning("no playlist passed");
            return;
        }
        Object addedPlayables = "";
        for (Node n : activatedNodes) {
            Object add2;
            Object object;
            if (n.getValue("movie") != null && (object = n.getValue("movie")) instanceof Movie) {
                Movie movie = (Movie)object;
                LOG.fine("add movie");
                addedPlayables = (String)addedPlayables + " " + movie.getTitle() + " - ";
                movie = (Movie)this.db.getEntityService().load(Movie.class, movie.getId().longValue());
                if (this.db.getDvd(movie, Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, movies on DVD cannot be added to a playlist (yet)");
                    continue;
                }
                if (this.db.getMediumFiles(movie, Scenerixx.unlocked).isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this movie since a medium is missing. Please assign a medium first.");
                    continue;
                }
                boolean add2 = true;
                if (this.ps.contains((IPlayable)movie, this.playlist, Scenerixx.unlocked)) {
                    int showConfirmDialog = JOptionPane.showConfirmDialog(null, movie.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movie, this.playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this movie another time?", 1);
                    if (1 == showConfirmDialog) {
                        add2 = false;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (!add2) continue;
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setMovie(movie);
                this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("scene") != null && (add2 = n.getValue("scene")) instanceof Scene) {
                int showConfirmDialog;
                Scene scene = (Scene)add2;
                LOG.fine("add scene");
                addedPlayables = (String)addedPlayables + " " + scene.getNameOfPlayable() + " - ";
                scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
                if (this.db.getDvd(scene.getMovie(), Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, scenes on DVD cannot be added to a playlist (yet)");
                    continue;
                }
                if (scene.getStartMedium() == null) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this scene since a medium is missing. Please assign a medium first to this scene.");
                    continue;
                }
                boolean add3 = true;
                if (this.ps.contains((IPlayable)scene, this.playlist, Scenerixx.unlocked) && 0 != (showConfirmDialog = JOptionPane.showConfirmDialog(null, scene.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)scene, this.playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this scene another time?", 1))) {
                    if (2 == showConfirmDialog) {
                        return;
                    }
                    add3 = false;
                }
                if (!add3) continue;
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setScene(scene);
                this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("bookmark") != null && (add2 = n.getValue("bookmark")) instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)add2;
                LOG.fine("add bookmark");
                addedPlayables = (String)addedPlayables + " " + bookmark.getNameOfPlayable() + " - ";
                bookmark = (Bookmark)this.db.getEntityService().load(Bookmark.class, bookmark.getId().longValue());
                if (bookmark.getMovie() != null && this.db.getDvd(bookmark.getMovie(), Scenerixx.unlocked) != null || bookmark.getScene() != null && this.db.getDvd(bookmark.getScene().getMovie(), Scenerixx.unlocked) != null) {
                    JOptionPane.showMessageDialog(null, "Sorry, bookmarks on DVD cannot be added to a playlist (yet)");
                    continue;
                }
                if (bookmark.getMedium() == null) {
                    JOptionPane.showMessageDialog(null, "Sorry, we cannot add this bookmark since a medium is missing. Please assign a medium first.");
                    continue;
                }
                boolean add4 = true;
                if (this.ps.contains((IPlayable)bookmark, this.playlist, Scenerixx.unlocked)) {
                    int showConfirmDialog = JOptionPane.showConfirmDialog(null, bookmark.getNameOfPlayable() + " is already on the playlist at position " + this.ps.getPositionInPlaylist((IPlayablePlaylistItems)bookmark, this.playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this bookmark another time?", 1);
                    if (1 == showConfirmDialog) {
                        add4 = false;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (!add4) continue;
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setBookmark(bookmark);
                this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("studio") != null && (add2 = n.getValue("studio")) instanceof Studio) {
                Studio studio = (Studio)add2;
                LOG.fine("add studio");
                addedPlayables = (String)addedPlayables + " " + studio.getName() + " - ";
                studio = (Studio)this.db.getEntityService().load(Studio.class, studio.getId().longValue());
                boolean add5 = true;
                if (this.ps.contains(studio, this.playlist, Scenerixx.unlocked)) {
                    int showConfirmDialog = JOptionPane.showConfirmDialog(null, studio.getName() + " is already on the playlist at position " + this.ps.getPositionInPlaylist(studio, this.playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this studio another time?", 1);
                    if (1 == showConfirmDialog) {
                        add5 = false;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (!add5) continue;
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setStudio(studio);
                this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("person") != null && (add2 = n.getValue("person")) instanceof Person) {
                Person person = (Person)add2;
                LOG.fine("add person");
                addedPlayables = (String)addedPlayables + " " + person.getName() + " - ";
                person = (Person)this.db.getEntityService().load(Person.class, person.getId().longValue());
                boolean add6 = true;
                if (this.ps.contains(person, this.playlist, Scenerixx.unlocked)) {
                    int showConfirmDialog = JOptionPane.showConfirmDialog(null, person.getName() + " is already on the playlist at position " + this.ps.getPositionInPlaylist(person, this.playlist, Scenerixx.unlocked) + ". Add anyway?", "Do you really want to add this person another time?", 1);
                    if (1 == showConfirmDialog) {
                        add6 = false;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (!add6) continue;
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                pe.setPerson(person);
                this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("mediumFile") != null && (add2 = n.getValue("mediumFile")) instanceof MediumFile) {
                MediumFile mf = (MediumFile)add2;
                LOG.fine("add medium file");
                addedPlayables = (String)addedPlayables + " " + mf.getFileName() + " - ";
                mf = (MediumFile)this.db.getEntityService().load(MediumFile.class, mf.getId().longValue());
                boolean add7 = true;
                Movie movieToCheck = mf.getMovie();
                if (movieToCheck == null) {
                    movieToCheck = new Movie();
                }
                if (this.ps.contains((IPlayable)mf, this.playlist, Scenerixx.unlocked) || this.ps.contains((IPlayable)movieToCheck, this.playlist, Scenerixx.unlocked)) {
                    int showConfirmDialog;
                    int positionInPlaylist = this.ps.getPositionInPlaylist((IPlayablePlaylistItems)mf, this.playlist, Scenerixx.unlocked);
                    if (positionInPlaylist == -1) {
                        positionInPlaylist = this.ps.getPositionInPlaylist((IPlayablePlaylistItems)movieToCheck, this.playlist, Scenerixx.unlocked);
                    }
                    if (1 == (showConfirmDialog = JOptionPane.showConfirmDialog(null, mf.getNameOfPlayable() + " is already on the playlist at position " + positionInPlaylist + ". Add anyway?", "Do you really want to add this medium file another time?", 1))) {
                        add7 = false;
                    } else if (2 == showConfirmDialog) {
                        return;
                    }
                }
                if (!add7) continue;
                LOG.fine("add playlist entry in db");
                PlaylistEntry pe = new PlaylistEntry();
                pe.setDateOfCreation(LocalDateTime.now());
                if (mf.getMovie() != null) {
                    pe.setMovie(mf.getMovie());
                    LOG.info("Added movie '" + mf.getMovie().getTitle() + "' to playlist '" + this.playlist.getName() + "'");
                } else {
                    pe.setMediumFile(mf);
                    LOG.info("Added medium file '" + mf.getFileName() + "' to playlist '" + this.playlist.getName() + "'");
                }
                this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
                continue;
            }
            if (n.getValue("entry") == null || !((add2 = n.getValue("entry")) instanceof PlaylistEntry)) continue;
            PlaylistEntry entry = (PlaylistEntry)add2;
            LOG.fine("add playlist entry");
            addedPlayables = (String)addedPlayables + " " + entry.getNameOfPlayable() + " - ";
            entry = (PlaylistEntry)this.db.getEntityService().load(PlaylistEntry.class, entry.getId().longValue());
            boolean add2 = true;
            if (this.ps.contains(entry, this.playlist, Scenerixx.unlocked)) {
                int showConfirmDialog = JOptionPane.showConfirmDialog(null, entry.getNameOfPlayable() + " is already on the playlist. Add anyway?", "Do you really want to add it another time?", 1);
                if (1 == showConfirmDialog) {
                    add2 = false;
                } else if (2 == showConfirmDialog) {
                    return;
                }
            }
            if (!add2) continue;
            LOG.fine("add playlist entry in db");
            PlaylistEntry pe = new PlaylistEntry();
            pe.setDateOfCreation(LocalDateTime.now());
            if (entry.getMovie() != null) {
                pe.setMovie(entry.getMovie());
                LOG.info("Added movie '" + entry.getMovie().getTitle() + "' to playlist '" + this.playlist.getName() + "'");
            }
            if (entry.getScene() != null) {
                pe.setScene(entry.getScene());
                LOG.info("Added scene '" + entry.getScene().getTitle() + "' to playlist '" + this.playlist.getName() + "'");
            }
            if (entry.getBookmark() != null) {
                pe.setBookmark(entry.getBookmark());
                LOG.info("Added bookmark '" + entry.getBookmark().getTitle() + "' to playlist '" + this.playlist.getName() + "'");
            }
            if (entry.getStudio() != null) {
                pe.setStudio(entry.getStudio());
                LOG.info("Added studio '" + entry.getStudio().getName() + "' to playlist '" + this.playlist.getName() + "'");
            }
            if (entry.getPerson() != null) {
                pe.setPerson(entry.getPerson());
                LOG.info("Added person '" + entry.getPerson().getName() + "' to playlist '" + this.playlist.getName() + "'");
            }
            this.playlist = this.ps.addPlaylistEntry(pe, this.playlist, Scenerixx.unlocked);
        }
        if (((String)addedPlayables).endsWith(" - ")) {
            addedPlayables = ((String)addedPlayables).substring(0, ((String)addedPlayables).length() - " - ".length());
        }
        int maxMsgLength = 150;
        if (((String)addedPlayables).length() > 150) {
            addedPlayables = ((String)addedPlayables).substring(0, 150) + "...";
        }
        String msg = "No item added to playlist " + this.playlist.getName();
        if (((String)addedPlayables).length() > 3) {
            msg = "Added '" + (String)addedPlayables + "' to playlist " + this.playlist.getName();
        }
        AbstractTopComponent.notifyInfo(msg);
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add To Specific Playlist";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }
}

