/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions.secretitems;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.mindrot.jbcrypt.BCrypt;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.options.PasswordPanel;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.search.SearchTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.statistic.StatisticTopComponent;

public final class UnlockSecretItems
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private final DB db = DB.getInstance();

    public UnlockSecretItems() {
        this.setEnabled(!Scenerixx.unlocked);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScenerixxSettings settings = this.db.getScenerixxSettings();
        if (settings == null || settings.getSecretPassword() == null) {
            Scenerixx.unlocked = true;
            this.updateOtherWindows();
            JOptionPane.showMessageDialog(null, "Unlocked. If you want to provide a password for unlocking, go to the options dialog", "Unlocked", 1, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"icons/big24/Unlock.png")));
        } else {
            final PasswordPanel pwdPanel = new PasswordPanel();
            JOptionPane op = new JOptionPane(pwdPanel, 2, -1);
            JDialog dlgPassword = op.createDialog("Enter your password to unlock secret items");
            dlgPassword.setVisible(true);
            dlgPassword.addWindowFocusListener(new WindowAdapter(this){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    pwdPanel.gainedFocus();
                }
            });
            if (op.getValue() != null && op.getValue().equals(0)) {
                if (BCrypt.checkpw((String)new String(pwdPanel.getPassword()), (String)settings.getSecretPassword())) {
                    Scenerixx.unlocked = true;
                    this.updateOtherWindows();
                    JOptionPane.showMessageDialog(null, "Successfully unlocked.", "Unlocked", 1, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"icons/big24/Unlock.png")));
                } else {
                    JOptionPane.showMessageDialog(null, "Password was wrong!", "Error", 0);
                }
            }
        }
    }

    private void updateOtherWindows() {
        ScenerixxCommon.setSelectedNodesInTitle(-1);
        EventQueue.invokeLater(() -> {
            LocalDateTime now = LocalDateTime.now();
            AbstractTopComponent.dirtyMovieList();
            ScenerixxCommon.LOG.info("finished movies window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyPersonList();
            ScenerixxCommon.LOG.info("finished persons window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyPlaylist();
            ScenerixxCommon.LOG.info("finished playlist window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyMediumFileList();
            ScenerixxCommon.LOG.info("finished medium file window " + Duration.between(LocalDateTime.now(), now).toString());
            TopComponent search = WindowManager.getDefault().findTopComponent("SearchTopComponent");
            if (search != null) {
                ((SearchTopComponent)search).reload();
            }
            ScenerixxCommon.LOG.info("finished search window " + Duration.between(LocalDateTime.now(), now).toString());
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).unlockElements();
            }
            ScenerixxCommon.LOG.info("finished details window " + Duration.between(LocalDateTime.now(), now).toString());
            block0: for (Mode m : WindowManager.getDefault().getModes()) {
                TopComponent[] openedTopComponents;
                if (!m.getName().equals("editor")) continue;
                for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(m)) {
                    if (tc.getName() == null || !tc.getName().equals("Statistic") || !tc.isOpened()) continue;
                    ((StatisticTopComponent)tc).setDirty();
                    ScenerixxCommon.LOG.info("finished statistic window " + Duration.between(LocalDateTime.now(), now).toString());
                    continue block0;
                }
            }
        });
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    @Override
    public boolean isEnabled() {
        return !Scenerixx.unlocked;
    }
}

