/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import api.api.ScenerixxRestApiApi;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.backend.ScenerixxVersion;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;

public final class CheckForUpdatesAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(CheckForUpdatesAction.class.getName());
    private boolean showDialog = true;

    public CheckForUpdatesAction(boolean showDialog) {
        this();
        this.showDialog = showDialog;
    }

    public CheckForUpdatesAction() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScenerixxRestApiApi api = new ScenerixxRestApiApi();
        String currentVersion = api.newestVersion(Scenerixx.VERSION);
        ScenerixxVersion scenerixxVersion = (ScenerixxVersion)ScenerixxCommonLib.getGsonBuilder().create().fromJson(currentVersion, ScenerixxVersion.class);
        LOG.info("Current version: '" + Scenerixx.VERSION + "' - Available version: '" + scenerixxVersion.getVersion() + "'");
        if (Scenerixx.VERSION.equals(scenerixxVersion.getVersion())) {
            LOG.info("up-to-date");
            if (this.showDialog) {
                JOptionPane.showMessageDialog(null, "You are up to date", "Everything's fine", 1);
            }
        } else {
            LOG.info("newer version available: " + scenerixxVersion.getVersion());
            JOptionPane.showMessageDialog(null, "The new version " + scenerixxVersion.getVersion() + " is out. Get it at www.scenerixx.com", "Great news", 1);
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }
}

